/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.exceptions;

import com.yahoo.elide.ElideErrorResponse;
import com.yahoo.elide.core.exceptions.ErrorContext;
import com.yahoo.elide.core.exceptions.ExceptionMapper;
import com.yahoo.elide.core.exceptions.ExceptionMapperRegistration;
import com.yahoo.elide.core.exceptions.ExceptionMappers;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class BasicExceptionMappers
implements ExceptionMappers {
    private final List<ExceptionMapperRegistration> exceptionMapperRegistrations;

    public BasicExceptionMappers(List<ExceptionMapperRegistration> exceptionMapperRegistrations) {
        this.exceptionMapperRegistrations = exceptionMapperRegistrations;
    }

    @Override
    public ElideErrorResponse<Object> toErrorResponse(Throwable exception, ErrorContext errorContext) {
        for (ExceptionMapperRegistration exceptionMapperRegistration : this.exceptionMapperRegistrations) {
            if (!exceptionMapperRegistration.isSupported(exception)) continue;
            ExceptionMapper<Throwable, ?> exceptionMapper = exceptionMapperRegistration.getExceptionMapper();
            try {
                ElideErrorResponse<Object> response = exceptionMapper.toErrorResponse(exception, errorContext);
                if (response == null) continue;
                return response;
            }
            catch (ClassCastException classCastException) {
            }
        }
        return null;
    }

    public static BasicExceptionMappersBuilder builder() {
        return new BasicExceptionMappersBuilder();
    }

    @Override
    public ExceptionMappers.ExceptionMappersBuilder mutate() {
        return BasicExceptionMappers.builder().registrations(registrations -> registrations.addAll(this.exceptionMapperRegistrations));
    }

    public static class BasicExceptionMappersBuilder
    implements ExceptionMappers.ExceptionMappersBuilder {
        private final List<ExceptionMapperRegistration> exceptionMapperRegistrations = new ArrayList<ExceptionMapperRegistration>();

        @Override
        public BasicExceptionMappersBuilder register(ExceptionMapperRegistration registration) {
            this.exceptionMapperRegistrations.add(registration);
            return this;
        }

        @Override
        public BasicExceptionMappersBuilder register(Class<? extends Throwable> supported, ExceptionMapper<? extends Throwable, ?> exceptionMapper) {
            ExceptionMappers.ExceptionMappersBuilder.super.register(supported, exceptionMapper);
            return this;
        }

        @Override
        public BasicExceptionMappersBuilder register(ExceptionMapper<? extends Throwable, ?> exceptionMapper) {
            ExceptionMappers.ExceptionMappersBuilder.super.register(exceptionMapper);
            return this;
        }

        @Override
        public BasicExceptionMappersBuilder registrations(Consumer<List<ExceptionMapperRegistration>> exceptionMapperRegistrations) {
            exceptionMapperRegistrations.accept(this.exceptionMapperRegistrations);
            return this;
        }

        @Override
        public BasicExceptionMappers build() {
            return new BasicExceptionMappers(this.exceptionMapperRegistrations);
        }
    }
}

