/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.dictionary;

import com.yahoo.elide.annotation.CreatePermission;
import com.yahoo.elide.annotation.DeletePermission;
import com.yahoo.elide.annotation.NonTransferable;
import com.yahoo.elide.annotation.ReadPermission;
import com.yahoo.elide.annotation.UpdatePermission;
import com.yahoo.elide.core.dictionary.EntityBinding;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.type.AccessibleObject;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.generated.parsers.ExpressionLexer;
import com.yahoo.elide.generated.parsers.ExpressionParser;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityPermissions {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntityPermissions.class);
    private static final List<Class<? extends Annotation>> PERMISSION_ANNOTATIONS = Arrays.asList(ReadPermission.class, CreatePermission.class, DeletePermission.class, NonTransferable.class, UpdatePermission.class);
    public static final EntityPermissions EMPTY_PERMISSIONS = new EntityPermissions();
    private static final AnnotationBinding EMPTY_BINDING = new AnnotationBinding(null, Collections.emptyMap());
    private final HashMap<Class<? extends Annotation>, AnnotationBinding> bindings = new HashMap();

    private EntityPermissions() {
    }

    public EntityPermissions(Type<?> cls, Collection<AccessibleObject> fieldOrMethodList) {
        for (Class<? extends Annotation> annotationClass : PERMISSION_ANNOTATIONS) {
            ParseTree classPermission;
            HashMap<String, ParseTree> fieldPermissions = new HashMap<String, ParseTree>();
            fieldOrMethodList.stream().forEach(member -> this.bindMemberPermissions((Map<String, ParseTree>)fieldPermissions, (AccessibleObject)member, annotationClass));
            if (annotationClass == NonTransferable.class || (classPermission = this.bindClassPermissions(cls, annotationClass)) == null && fieldPermissions.isEmpty()) continue;
            this.bindings.put(annotationClass, new AnnotationBinding(classPermission, fieldPermissions));
        }
    }

    private ParseTree bindClassPermissions(Type<?> cls, Class<? extends Annotation> annotationClass) {
        Annotation annotation = EntityDictionary.getFirstAnnotation(cls, Arrays.asList(annotationClass));
        return annotation == null ? null : this.getPermissionExpressionTree(annotationClass, annotation);
    }

    private void bindMemberPermissions(Map<String, ParseTree> fieldPermissions, AccessibleObject field, Class<? extends Annotation> annotationClass) {
        Annotation annotation = field.getAnnotation(annotationClass);
        if (annotation != null) {
            ParseTree permissions = this.getPermissionExpressionTree(annotationClass, annotation);
            fieldPermissions.put(EntityBinding.getFieldName(field), permissions);
        }
    }

    private ParseTree getPermissionExpressionTree(Class<? extends Annotation> annotationClass, Annotation annotation) {
        try {
            boolean hasExpression;
            String expression = (String)annotationClass.getMethod("expression", new Class[0]).invoke((Object)annotation, new Object[0]);
            boolean bl = hasExpression = !expression.isEmpty();
            if (!hasExpression) {
                log.warn("Poorly configured permission: {} {}", (Object)annotationClass.getName(), (Object)"no checks specified.");
                throw new IllegalArgumentException("Poorly configured permission '" + annotationClass.getName() + "'");
            }
            return EntityPermissions.parseExpression(expression);
        }
        catch (ReflectiveOperationException e) {
            log.warn("Unknown permission: {}, {}", (Object)annotationClass.getName(), (Object)e.toString());
            throw new IllegalArgumentException("Unknown permission '" + annotationClass.getName() + "'", e);
        }
    }

    public static ParseTree parseExpression(String expression) {
        CodePointCharStream is = CharStreams.fromString((String)expression);
        ExpressionLexer lexer = new ExpressionLexer((CharStream)is);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                throw new ParseCancellationException(msg, (Throwable)e);
            }
        });
        ExpressionParser parser = new ExpressionParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
        lexer.reset();
        return parser.start();
    }

    public boolean hasChecksForPermission(Class<? extends Annotation> annotationClass) {
        return this.bindings.containsKey(annotationClass);
    }

    public ParseTree getClassChecksForPermission(Class<? extends Annotation> annotationClass) {
        return this.bindings.getOrDefault(annotationClass, (AnnotationBinding)EntityPermissions.EMPTY_BINDING).classPermission;
    }

    public ParseTree getFieldChecksForPermission(String field, Class<? extends Annotation> annotationClass) {
        return this.bindings.getOrDefault(annotationClass, (AnnotationBinding)EntityPermissions.EMPTY_BINDING).fieldPermissions.get(field);
    }

    private static class AnnotationBinding {
        final ParseTree classPermission;
        final Map<String, ParseTree> fieldPermissions;

        public AnnotationBinding(ParseTree classPermission, Map<String, ParseTree> fieldPermissions) {
            this.classPermission = classPermission;
            this.fieldPermissions = fieldPermissions.isEmpty() ? Collections.emptyMap() : fieldPermissions;
        }
    }
}

