/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide;

public class ElideResponse<T> {
    private final int status;
    private final T body;

    public ElideResponse(int status, T body) {
        this.status = status;
        this.body = body;
    }

    public int getStatus() {
        return this.status;
    }

    public T getBody() {
        return this.body;
    }

    public <V> V getBody(Class<V> clazz) {
        if (clazz.isInstance(this.body)) {
            return clazz.cast(this.body);
        }
        return null;
    }

    public static ElideResponseBuilder status(int status) {
        return new ElideResponseBuilder(status);
    }

    public static ElideResponseBuilder ok() {
        return ElideResponse.status(200);
    }

    public static <T> ElideResponse<T> ok(T body) {
        return ElideResponse.ok().body(body);
    }

    public static ElideResponseBuilder badRequest() {
        return ElideResponse.status(400);
    }

    public static <T> ElideResponse<T> badRequest(T body) {
        return ElideResponse.badRequest().body(body);
    }

    public static class ElideResponseBuilder {
        protected int status;

        public ElideResponseBuilder(int status) {
            this.status = status;
        }

        public <T> ElideResponse<T> body(T body) {
            return new ElideResponse<T>(this.status, body);
        }

        public <T> ElideResponse<T> build() {
            return new ElideResponse<Object>(this.status, null);
        }
    }
}

