/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.elide.ElideSettings;
import com.yahoo.elide.Settings;
import com.yahoo.elide.core.SerdeRegistrations;
import com.yahoo.elide.core.TransactionRegistry;
import com.yahoo.elide.core.audit.AuditLogger;
import com.yahoo.elide.core.datastore.DataStore;
import com.yahoo.elide.core.datastore.inmemory.InMemoryDataStore;
import com.yahoo.elide.core.dictionary.Injector;
import com.yahoo.elide.core.utils.ClassScanner;
import com.yahoo.elide.core.utils.coerce.CoerceUtil;
import com.yahoo.elide.core.utils.coerce.converters.ElideTypeConverter;
import com.yahoo.elide.core.utils.coerce.converters.Serde;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Elide {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Elide.class);
    private final ElideSettings elideSettings;
    private final AuditLogger auditLogger;
    private final DataStore dataStore;
    private final ObjectMapper objectMapper;
    private final TransactionRegistry transactionRegistry;
    private final ClassScanner scanner;
    private boolean initialized = false;

    public Elide(ElideSettings elideSettings) {
        this(elideSettings, new TransactionRegistry(), elideSettings.getEntityDictionary().getScanner(), false);
    }

    public Elide(ElideSettings elideSettings, TransactionRegistry transactionRegistry) {
        this(elideSettings, transactionRegistry, elideSettings.getEntityDictionary().getScanner(), false);
    }

    public Elide(ElideSettings elideSettings, TransactionRegistry transactionRegistry, ClassScanner scanner, boolean doScans) {
        this.elideSettings = elideSettings;
        this.scanner = scanner;
        this.auditLogger = elideSettings.getAuditLogger();
        this.dataStore = new InMemoryDataStore(elideSettings.getDataStore());
        this.objectMapper = elideSettings.getObjectMapper();
        this.transactionRegistry = transactionRegistry;
        if (doScans) {
            this.doScans();
        }
    }

    public void doScans() {
        if (!this.initialized) {
            this.elideSettings.getSerdes().forEach((type, serde) -> this.registerCustomSerde((Class)type, (Serde)serde, type.getSimpleName()));
            this.registerCustomSerde();
            this.elideSettings.getEntityDictionary().scanForSecurityChecks();
            this.dataStore.populateEntityDictionary(this.elideSettings.getEntityDictionary());
            this.initialized = true;
        }
    }

    protected void registerCustomSerde() {
        Injector injector = this.elideSettings.getEntityDictionary().getInjector();
        Set<Class<?>> classes = this.registerCustomSerdeScan();
        for (Class<?> clazz : classes) {
            if (!Serde.class.isAssignableFrom(clazz)) {
                log.warn("Skipping Serde registration (not a Serde!): {}", clazz);
                continue;
            }
            Serde serde = (Serde)injector.instantiate(clazz);
            injector.inject(serde);
            ElideTypeConverter converter = clazz.getAnnotation(ElideTypeConverter.class);
            Class<?> baseType = converter.type();
            this.registerCustomSerde(baseType, serde, converter.name());
            for (Class<?> type : converter.subTypes()) {
                if (!baseType.isAssignableFrom(type)) {
                    throw new IllegalArgumentException("Mentioned type " + type + " not subtype of " + baseType);
                }
                this.registerCustomSerde(type, serde, converter.name());
            }
        }
    }

    protected <S, T> void registerCustomSerde(Class<T> type, Serde<S, T> serde, String name) {
        log.info("Registering serde for type : {}", type);
        CoerceUtil.register(type, serde);
        this.registerCustomSerdeInObjectMapper(type, serde, name);
    }

    protected <S, T> void registerCustomSerdeInObjectMapper(Class<T> type, Serde<S, T> serde, String name) {
        SerdeRegistrations.register(this.objectMapper, type, serde, name);
    }

    protected Set<Class<?>> registerCustomSerdeScan() {
        return this.scanner.getAnnotatedClasses(ElideTypeConverter.class);
    }

    public <T extends Settings> T getSettings(Class<T> clazz) {
        return this.elideSettings.getSettings(clazz);
    }

    @Generated
    public ElideSettings getElideSettings() {
        return this.elideSettings;
    }

    @Generated
    public AuditLogger getAuditLogger() {
        return this.auditLogger;
    }

    @Generated
    public DataStore getDataStore() {
        return this.dataStore;
    }

    @Generated
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Generated
    public TransactionRegistry getTransactionRegistry() {
        return this.transactionRegistry;
    }

    @Generated
    public ClassScanner getScanner() {
        return this.scanner;
    }
}

