/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.jsonapi.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.yahoo.elide.jsonapi.models.JsonApiError;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public class JsonApiErrors {
    private final List<JsonApiError> errors;

    @JsonCreator
    public JsonApiErrors(@JsonProperty(value="errors") List<JsonApiError> errors) {
        this.errors = Objects.requireNonNull(errors, "errors must not be null");
    }

    public static JsonApiErrorsBuilder builder() {
        return new JsonApiErrorsBuilder();
    }

    public List<JsonApiError> getErrors() {
        return this.errors;
    }

    public static class JsonApiErrorsBuilder {
        private List<JsonApiError> errors = new ArrayList<JsonApiError>();

        public JsonApiErrorsBuilder error(JsonApiError error) {
            this.errors.add(error);
            return this;
        }

        public JsonApiErrorsBuilder error(Consumer<JsonApiError.JsonApiErrorBuilder> error) {
            JsonApiError.JsonApiErrorBuilder builder = JsonApiError.builder();
            error.accept(builder);
            return this.error(builder.build());
        }

        public JsonApiErrorsBuilder errors(List<JsonApiError> errors) {
            this.errors = errors;
            return this;
        }

        public JsonApiErrorsBuilder errors(Consumer<List<JsonApiError>> errors) {
            errors.accept(this.errors);
            return this;
        }

        public JsonApiErrors build() {
            if (this.errors.isEmpty()) {
                throw new IllegalArgumentException("At least one error is required");
            }
            return new JsonApiErrors(this.errors);
        }
    }
}

