/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.jsonapi.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "links", "status", "code", "source", "title", "detail", "meta"})
public class JsonApiError {
    private final String id;
    private final Links links;
    private final String status;
    private final String code;
    private final Source source;
    private final String title;
    private final String detail;
    private final Object meta;

    @JsonCreator
    public JsonApiError(@JsonProperty(value="id") String id, @JsonProperty(value="links") Links links, @JsonProperty(value="status") String status, @JsonProperty(value="code") String code, @JsonProperty(value="source") Source source, @JsonProperty(value="title") String title, @JsonProperty(value="detail") String detail, @JsonProperty(value="meta") Object meta) {
        this.id = id;
        this.links = links;
        this.status = status;
        this.code = code;
        this.source = source;
        this.title = title;
        this.detail = detail;
        this.meta = meta;
    }

    public <T> T getMeta() {
        return (T)this.meta;
    }

    public static JsonApiErrorBuilder builder() {
        return new JsonApiErrorBuilder();
    }

    public String getId() {
        return this.id;
    }

    public Links getLinks() {
        return this.links;
    }

    public String getStatus() {
        return this.status;
    }

    public String getCode() {
        return this.code;
    }

    public Source getSource() {
        return this.source;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDetail() {
        return this.detail;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonPropertyOrder(value={"about", "type"})
    public static class Links {
        private final String about;
        private final String type;

        @JsonCreator
        public Links(@JsonProperty(value="about") String about, @JsonProperty(value="type") String type) {
            this.about = about;
            this.type = type;
        }

        public static LinksBuilder builder() {
            return new LinksBuilder();
        }

        public String getAbout() {
            return this.about;
        }

        public String getType() {
            return this.type;
        }

        public static class LinksBuilder {
            private String about;
            private String type;

            LinksBuilder() {
            }

            public LinksBuilder about(String about) {
                this.about = about;
                return this;
            }

            public LinksBuilder type(String type) {
                this.type = type;
                return this;
            }

            public Links build() {
                return new Links(this.about, this.type);
            }

            public String toString() {
                return "JsonApiError.Links.LinksBuilder(about=" + this.about + ", type=" + this.type + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonPropertyOrder(value={"pointer", "parameter", "header"})
    public static class Source {
        private final String pointer;
        private final String parameter;
        private final String header;

        @JsonCreator
        public Source(@JsonProperty(value="pointer") String pointer, @JsonProperty(value="parameter") String parameter, @JsonProperty(value="header") String header) {
            this.pointer = pointer;
            this.parameter = parameter;
            this.header = header;
        }

        public static SourceBuilder builder() {
            return new SourceBuilder();
        }

        public String getPointer() {
            return this.pointer;
        }

        public String getParameter() {
            return this.parameter;
        }

        public String getHeader() {
            return this.header;
        }

        public static class SourceBuilder {
            private String pointer;
            private String parameter;
            private String header;

            SourceBuilder() {
            }

            public SourceBuilder pointer(String pointer) {
                this.pointer = pointer;
                return this;
            }

            public SourceBuilder parameter(String parameter) {
                this.parameter = parameter;
                return this;
            }

            public SourceBuilder header(String header) {
                this.header = header;
                return this;
            }

            public Source build() {
                return new Source(this.pointer, this.parameter, this.header);
            }

            public String toString() {
                return "JsonApiError.Source.SourceBuilder(pointer=" + this.pointer + ", parameter=" + this.parameter + ", header=" + this.header + ")";
            }
        }
    }

    public static class JsonApiErrorBuilder {
        private String id;
        private Links links;
        private String status;
        private String code;
        private Source source;
        private String title;
        private String detail;
        private Object meta;

        public JsonApiErrorBuilder links(Links links) {
            this.links = links;
            return this;
        }

        public JsonApiErrorBuilder links(Consumer<Links.LinksBuilder> links) {
            Links.LinksBuilder builder = new Links.LinksBuilder();
            links.accept(builder);
            this.links = builder.build();
            return this;
        }

        public JsonApiErrorBuilder source(Source source) {
            this.source = source;
            return this;
        }

        public JsonApiErrorBuilder source(Consumer<Source.SourceBuilder> source) {
            Source.SourceBuilder builder = new Source.SourceBuilder();
            source.accept(builder);
            this.source = builder.build();
            return this;
        }

        public JsonApiErrorBuilder meta(Consumer<Map<String, Object>> meta) {
            LinkedHashMap builder = new LinkedHashMap();
            meta.accept(builder);
            return this.meta(builder);
        }

        public <M> JsonApiErrorBuilder meta(M meta) {
            this.meta = meta;
            return this;
        }

        JsonApiErrorBuilder() {
        }

        public JsonApiErrorBuilder id(String id) {
            this.id = id;
            return this;
        }

        public JsonApiErrorBuilder status(String status) {
            this.status = status;
            return this;
        }

        public JsonApiErrorBuilder code(String code) {
            this.code = code;
            return this;
        }

        public JsonApiErrorBuilder title(String title) {
            this.title = title;
            return this;
        }

        public JsonApiErrorBuilder detail(String detail) {
            this.detail = detail;
            return this;
        }

        public JsonApiError build() {
            return new JsonApiError(this.id, this.links, this.status, this.code, this.source, this.title, this.detail, this.meta);
        }

        public String toString() {
            return "JsonApiError.JsonApiErrorBuilder(id=" + this.id + ", links=" + this.links + ", status=" + this.status + ", code=" + this.code + ", source=" + this.source + ", title=" + this.title + ", detail=" + this.detail + ", meta=" + this.meta + ")";
        }
    }
}

