/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.jsonapi.models;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.yahoo.elide.core.dictionary.RelationshipType;
import com.yahoo.elide.jsonapi.models.Resource;
import com.yahoo.elide.jsonapi.models.ResourceIdentifier;
import com.yahoo.elide.jsonapi.serialization.DataDeserializer;
import com.yahoo.elide.jsonapi.serialization.DataSerializer;
import io.reactivex.Observable;
import java.util.Collection;
import java.util.Comparator;

@JsonSerialize(using=DataSerializer.class)
@JsonDeserialize(using=DataDeserializer.class)
public class Data<T> {
    private final Observable<T> values;
    private final RelationshipType relationshipType;

    public Data(T value) {
        this.values = value == null ? Observable.empty() : Observable.fromArray((Object[])new Object[]{value});
        this.relationshipType = RelationshipType.MANY_TO_ONE;
    }

    public Data(Observable<T> values) {
        this(values, RelationshipType.MANY_TO_MANY);
    }

    public Data(Observable<T> values, RelationshipType relationshipType) {
        this.values = values;
        this.relationshipType = relationshipType;
    }

    public Data(Collection<T> values) {
        this(values, RelationshipType.MANY_TO_MANY);
    }

    public Data(Collection<T> values, RelationshipType relationshipType) {
        this.values = Observable.fromIterable(values);
        this.relationshipType = relationshipType;
    }

    public void sort(Comparator<T> sortFunction) {
        this.values.sorted(sortFunction);
    }

    public Collection<T> get() {
        return (Collection)this.values.toList().blockingGet();
    }

    public boolean isToOne() {
        return this.relationshipType.isToOne();
    }

    public T getSingleValue() {
        if (this.isToOne()) {
            if (((Boolean)this.values.isEmpty().blockingGet()).booleanValue()) {
                return null;
            }
            return (T)this.values.blockingSingle();
        }
        throw new IllegalAccessError("Data is not toOne");
    }

    public Collection<ResourceIdentifier> toResourceIdentifiers() {
        return (Collection)this.values.map(object -> object != null ? ((Resource)object).toResourceIdentifier() : null).toList().blockingGet();
    }

    public String toString() {
        return "Data(values=" + this.values + ", relationshipType=" + this.relationshipType + ")";
    }
}

