/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.jsonapi.extensions;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.elide.jsonapi.models.Data;
import com.yahoo.elide.jsonapi.models.JsonApiDocument;
import com.yahoo.elide.jsonapi.models.Operations;
import com.yahoo.elide.jsonapi.models.Resource;
import java.util.ArrayList;

public class JsonApiAtomicOperationsMapper {
    protected final ObjectMapper objectMapper;

    public JsonApiAtomicOperationsMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public Operations readDoc(String operationsDoc) throws JsonProcessingException {
        return (Operations)this.objectMapper.readValue(operationsDoc, Operations.class);
    }

    public Resource readResource(JsonNode resource) throws JsonProcessingException {
        return (Resource)this.objectMapper.treeToValue((TreeNode)resource, Resource.class);
    }

    public JsonApiDocument readData(JsonNode data) throws JsonProcessingException {
        JsonApiDocument value = new JsonApiDocument();
        if (data != null) {
            if (data.isArray()) {
                ArrayList<Resource> dataResources = new ArrayList<Resource>();
                for (JsonNode item : data) {
                    dataResources.add(this.readResource(item));
                    value.setData(new Data<Resource>(dataResources));
                }
            } else {
                Resource resource = this.readResource(data);
                value.setData(new Data<Resource>(resource));
            }
        }
        return value;
    }
}

