/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.jsonapi.extensions;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.datastore.DataStore;
import com.yahoo.elide.core.exceptions.HttpStatusException;
import com.yahoo.elide.core.exceptions.InvalidEntityBodyException;
import com.yahoo.elide.core.exceptions.JsonApiAtomicOperationsException;
import com.yahoo.elide.jsonapi.JsonApiMapper;
import com.yahoo.elide.jsonapi.extensions.JsonApiAtomicOperationsRequestScope;
import com.yahoo.elide.jsonapi.models.Data;
import com.yahoo.elide.jsonapi.models.JsonApiDocument;
import com.yahoo.elide.jsonapi.models.Operation;
import com.yahoo.elide.jsonapi.models.Operations;
import com.yahoo.elide.jsonapi.models.Ref;
import com.yahoo.elide.jsonapi.models.Resource;
import com.yahoo.elide.jsonapi.models.Result;
import com.yahoo.elide.jsonapi.models.Results;
import com.yahoo.elide.jsonapi.parser.DeleteVisitor;
import com.yahoo.elide.jsonapi.parser.JsonApiParser;
import com.yahoo.elide.jsonapi.parser.PatchVisitor;
import com.yahoo.elide.jsonapi.parser.PostVisitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.owasp.encoder.Encode;

public class JsonApiAtomicOperations {
    public static final String EXTENSION = "https://jsonapi.org/ext/atomic";
    private final List<OperationAction> actions;
    private final String rootUri;
    private static final ObjectNode ERR_NODE_ERR_IN_SUBSEQUENT_OPERATION;
    private static final ObjectNode ERR_NODE_OPERATION_NOT_RUN;

    public static Supplier<Pair<Integer, JsonNode>> processAtomicOperations(DataStore dataStore, String uri, String operationsDoc, JsonApiAtomicOperationsRequestScope requestScope) {
        List<Operation> actions;
        try {
            Operations operations = requestScope.getMapper().forAtomicOperations().readDoc(operationsDoc);
            actions = operations.getOperations();
        }
        catch (InvalidFormatException e) {
            if (Operation.OperationCode.class.equals((Object)e.getTargetType())) {
                throw new InvalidEntityBodyException("Invalid Atomic Operations extension operation code:" + e.getValue());
            }
            throw new InvalidEntityBodyException(operationsDoc);
        }
        catch (IOException e) {
            throw new InvalidEntityBodyException(operationsDoc);
        }
        JsonApiAtomicOperations processor = new JsonApiAtomicOperations(dataStore, actions, uri, requestScope);
        return processor.processActions(requestScope);
    }

    private JsonApiAtomicOperations(DataStore dataStore, List<Operation> actions, String rootUri, RequestScope requestScope) {
        this.actions = actions.stream().map(OperationAction::new).toList();
        this.rootUri = rootUri;
    }

    private Supplier<Pair<Integer, JsonNode>> processActions(JsonApiAtomicOperationsRequestScope requestScope) {
        try {
            List<Supplier<Pair<Integer, JsonApiDocument>>> results = this.handleActions(requestScope);
            this.postProcessRelationships(requestScope);
            return () -> {
                try {
                    return Pair.of((Object)200, (Object)JsonApiAtomicOperations.mergeResponse(results, requestScope.getMapper()));
                }
                catch (HttpStatusException e) {
                    this.throwErrorResponse();
                    return null;
                }
            };
        }
        catch (HttpStatusException e) {
            this.throwErrorResponse();
            return () -> null;
        }
    }

    protected String getFullPath(Ref ref, Operation operation) {
        if (ref != null) {
            StringBuilder fullPathBuilder = new StringBuilder();
            if (ref.getType() == null) {
                throw new InvalidEntityBodyException("Atomic Operations extension ref must specify the type member.");
            }
            fullPathBuilder.append(ref.getType());
            if (ref.getRelationship() != null || Operation.OperationCode.UPDATE.equals((Object)operation.getOperationCode()) || Operation.OperationCode.REMOVE.equals((Object)operation.getOperationCode())) {
                if (ref.getId() != null) {
                    fullPathBuilder.append("/");
                    fullPathBuilder.append(ref.getId());
                } else if (ref.getLid() != null) {
                    fullPathBuilder.append("/");
                    fullPathBuilder.append(ref.getLid());
                }
            }
            if (ref.getRelationship() != null) {
                fullPathBuilder.append("/");
                fullPathBuilder.append("relationships");
                fullPathBuilder.append("/");
                fullPathBuilder.append(ref.getRelationship());
            }
            return fullPathBuilder.toString();
        }
        return null;
    }

    private void validateOperation(Operation operation) {
        if (operation == null) {
            throw new InvalidEntityBodyException("Atomic Operations extension operation must be specified.");
        }
        if (operation.getOperationCode() == null) {
            throw new InvalidEntityBodyException("Atomic Operations extension operation code must be specified.");
        }
        String href = operation.getHref();
        Ref ref = operation.getRef();
        if (href != null && ref != null) {
            throw new InvalidEntityBodyException("Atomic Operations extension operation cannot contain both ref and href members.");
        }
        if (ref != null && ref.getLid() != null && ref.getId() != null) {
            throw new InvalidEntityBodyException("Atomic Operations extension ref cannot contain both id and lid members.");
        }
    }

    private List<Supplier<Pair<Integer, JsonApiDocument>>> handleActions(JsonApiAtomicOperationsRequestScope requestScope) {
        return this.actions.stream().map(action -> {
            try {
                boolean refSpecified;
                Operation operation = action.operation;
                this.validateOperation(operation);
                JsonNode data = operation.getData();
                String href = operation.getHref();
                Ref ref = operation.getRef();
                String fullPath = href;
                boolean bl = refSpecified = ref != null;
                if (fullPath == null) {
                    if (ref == null) {
                        ref = this.inferRef(requestScope.getMapper(), operation);
                    }
                    fullPath = this.getFullPath(ref, operation);
                }
                if (fullPath == null) {
                    throw new InvalidEntityBodyException("Atomic Operations extension operation requires either ref or href members to be specified.");
                }
                if (refSpecified && Operation.OperationCode.ADD.equals((Object)operation.getOperationCode()) && this.isResourceOperation(fullPath)) {
                    throw new InvalidEntityBodyException("Atomic Operations extension add resource operation may only specify the href member.");
                }
                return switch (operation.getOperationCode()) {
                    case Operation.OperationCode.ADD -> this.handleAddOp(fullPath, data, requestScope, (OperationAction)action);
                    case Operation.OperationCode.UPDATE -> this.handleUpdateOp(fullPath, data, requestScope, (OperationAction)action);
                    case Operation.OperationCode.REMOVE -> this.handleRemoveOp(fullPath, data, requestScope);
                    default -> throw new InvalidEntityBodyException("Invalid Atomic Operations extension operation code:" + operation.getOperationCode());
                };
            }
            catch (HttpStatusException e) {
                action.cause = e;
                throw e;
            }
        }).toList();
    }

    private Ref inferRef(JsonApiMapper mapper, Operation operation) {
        if (operation.getData() != null && !operation.getData().isArray()) {
            try {
                Resource resource = mapper.forAtomicOperations().readResource(operation.getData());
                if (resource.getType() != null && this.isResourceOperation(resource)) {
                    if (Operation.OperationCode.ADD.equals((Object)operation.getOperationCode())) {
                        return new Ref(resource.getType(), null, null, null);
                    }
                    if (Operation.OperationCode.UPDATE.equals((Object)operation.getOperationCode())) {
                        if (resource.getLid() != null) {
                            return new Ref(resource.getType(), null, resource.getLid(), null);
                        }
                        if (resource.getId() != null) {
                            return new Ref(resource.getType(), resource.getId(), null, null);
                        }
                    }
                }
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean isResourceOperation(Resource resource) {
        return resource.getAttributes() != null && !resource.getAttributes().isEmpty() || resource.getRelationships() != null && !resource.getRelationships().isEmpty();
    }

    private boolean isResourceOperation(String href) {
        return !href.contains("/relationships/");
    }

    private Supplier<Pair<Integer, JsonApiDocument>> handleAddOp(String path, JsonNode dataValue, JsonApiAtomicOperationsRequestScope requestScope, OperationAction action) {
        try {
            JsonApiDocument value = requestScope.getMapper().forAtomicOperations().readData(dataValue);
            Data<Resource> data = value.getData();
            if (data == null || data.get() == null) {
                throw new InvalidEntityBodyException("Expected an entity body but received none.");
            }
            Collection<Resource> resources = data.get();
            if (!path.contains("relationships")) {
                String id = JsonApiAtomicOperations.getSingleResource(resources).getId();
                if (StringUtils.isEmpty((CharSequence)id)) {
                    throw new InvalidEntityBodyException("Atomic Operations extension requires all objects to have an assigned ID (temporary or permanent) when assigning relationships.");
                }
                String fullPath = path + "/" + id;
                JsonApiAtomicOperations.getSingleResource(resources).setRelationships(null);
                action.doc = requestScope.getMapper().forAtomicOperations().readData(dataValue);
                action.path = fullPath;
                action.isPostProcessing = true;
            }
            PostVisitor visitor = new PostVisitor(new JsonApiAtomicOperationsRequestScope(path, value, requestScope));
            return (Supplier)visitor.visit(JsonApiParser.parse(path));
        }
        catch (HttpStatusException e) {
            action.cause = e;
            throw e;
        }
        catch (IOException e) {
            throw new InvalidEntityBodyException("Could not parse Atomic Operations extension value: " + dataValue);
        }
    }

    private Supplier<Pair<Integer, JsonApiDocument>> handleUpdateOp(String path, JsonNode dataValue, JsonApiAtomicOperationsRequestScope requestScope, OperationAction action) {
        try {
            JsonApiDocument value = requestScope.getMapper().forAtomicOperations().readData(dataValue);
            if (!path.contains("relationships")) {
                Data<Resource> data = value.getData();
                Collection<Resource> resources = data.get();
                JsonApiAtomicOperations.getSingleResource(resources).setRelationships(null);
                action.doc = requestScope.getMapper().forAtomicOperations().readData(dataValue);
                action.path = path;
                action.isPostProcessing = true;
            }
            PatchVisitor visitor = new PatchVisitor(new JsonApiAtomicOperationsRequestScope(path, value, requestScope));
            return (Supplier)visitor.visit(JsonApiParser.parse(path));
        }
        catch (IOException e) {
            throw new InvalidEntityBodyException("Could not parse Atomic Operations extension value: " + dataValue);
        }
    }

    private Supplier<Pair<Integer, JsonApiDocument>> handleRemoveOp(String path, JsonNode dataValue, JsonApiAtomicOperationsRequestScope requestScope) {
        try {
            Object fullPath;
            JsonApiDocument value = requestScope.getMapper().forAtomicOperations().readData(dataValue);
            if (path.contains("relationships")) {
                fullPath = path;
            } else {
                Data<Resource> data = value.getData();
                if (data == null || data.get() == null) {
                    fullPath = path;
                } else {
                    Collection<Resource> resources = data.get();
                    String id = JsonApiAtomicOperations.getSingleResource(resources).getId();
                    fullPath = path + "/" + id;
                }
            }
            DeleteVisitor visitor = new DeleteVisitor(new JsonApiAtomicOperationsRequestScope(path, value, requestScope));
            return (Supplier)visitor.visit(JsonApiParser.parse((String)fullPath));
        }
        catch (IOException e) {
            throw new InvalidEntityBodyException("Could not parse Atomic Operations extension value: " + dataValue);
        }
    }

    private void postProcessRelationships(JsonApiAtomicOperationsRequestScope requestScope) {
        this.actions.forEach(action -> action.postProcess(requestScope));
    }

    private void throwErrorResponse() {
        ArrayNode errorContainer = this.getErrorContainer();
        boolean failed = false;
        for (OperationAction action : this.actions) {
            failed = this.processAction(errorContainer, failed, action);
        }
        JsonApiAtomicOperationsException failure = new JsonApiAtomicOperationsException(400, (JsonNode)errorContainer);
        for (OperationAction action : this.actions) {
            if (action.cause == null) continue;
            failure.addSuppressed(action.cause);
        }
        throw failure;
    }

    private ArrayNode getErrorContainer() {
        return JsonNodeFactory.instance.arrayNode();
    }

    private boolean processAction(ArrayNode errorList, boolean failed, OperationAction action) {
        ObjectNode container = JsonNodeFactory.instance.objectNode();
        ArrayNode errors = JsonNodeFactory.instance.arrayNode();
        container.set("errors", (JsonNode)errors);
        errorList.add((JsonNode)container);
        if (action.cause != null) {
            errors.add(JsonApiAtomicOperations.toErrorNode(action.cause.getMessage(), action.cause.getStatus()));
            failed = true;
        } else if (!failed) {
            errors.add((JsonNode)ERR_NODE_ERR_IN_SUBSEQUENT_OPERATION);
        } else {
            errors.add((JsonNode)ERR_NODE_OPERATION_NOT_RUN);
        }
        return failed;
    }

    protected String getRootUri() {
        return this.rootUri;
    }

    private static void clearAllExceptRelationships(JsonApiDocument doc) {
        Data<Resource> data = doc.getData();
        if (data == null || data.get() == null) {
            return;
        }
        data.get().forEach(JsonApiAtomicOperations::clearAllExceptRelationships);
    }

    private static void clearAllExceptRelationships(Resource resource) {
        resource.setAttributes(null);
        resource.setLinks(null);
        resource.setMeta(null);
    }

    private static JsonNode toErrorNode(String detail, Integer status) {
        ObjectNode formattedError = JsonNodeFactory.instance.objectNode();
        formattedError.set("detail", (JsonNode)JsonNodeFactory.instance.textNode(Encode.forHtml((String)detail)));
        if (status != null) {
            formattedError.set("status", (JsonNode)JsonNodeFactory.instance.textNode(status.toString()));
        }
        return formattedError;
    }

    private static JsonNode mergeResponse(List<Supplier<Pair<Integer, JsonApiDocument>>> results, JsonApiMapper mapper) {
        ArrayList<Result> list = new ArrayList<Result>();
        for (Supplier<Pair<Integer, JsonApiDocument>> result : results) {
            JsonApiDocument document = (JsonApiDocument)result.get().getRight();
            if (document != null) {
                document.getData().get().stream().map(resource -> new Result((Resource)resource, document.getMeta())).forEach(list::add);
                continue;
            }
            list.add(new Result(null));
        }
        return mapper.getObjectMapper().valueToTree((Object)new Results(list));
    }

    public static boolean isAtomicOperationsExtension(String header) {
        if (header == null) {
            return false;
        }
        return Arrays.stream(header.split(";")).map(key -> key.split("=")).filter(value -> ((String[])value).length == 2).anyMatch(value -> value[0].trim().equals("ext") && JsonApiAtomicOperations.parameterValues(value[1]).contains(EXTENSION));
    }

    private static Set<String> parameterValues(String value) {
        String trimmed = value.trim();
        if (trimmed.length() > 1 && trimmed.startsWith("\"") && trimmed.endsWith("\"")) {
            String unquoted = trimmed.substring(1, trimmed.length() - 1);
            HashSet<String> result = new HashSet<String>();
            Collections.addAll(result, unquoted.split(" "));
            return result;
        }
        return Collections.singleton(trimmed);
    }

    private static Resource getSingleResource(Collection<Resource> resources) {
        if (resources == null || resources.size() != 1) {
            throw new InvalidEntityBodyException("Expected single resource.");
        }
        return (Resource)IterableUtils.first(resources);
    }

    static {
        ERR_NODE_OPERATION_NOT_RUN = JsonNodeFactory.instance.objectNode();
        ERR_NODE_OPERATION_NOT_RUN.set("detail", (JsonNode)JsonNodeFactory.instance.textNode("Operation not executed. Terminated by earlier failure."));
        ERR_NODE_ERR_IN_SUBSEQUENT_OPERATION = JsonNodeFactory.instance.objectNode();
        ERR_NODE_ERR_IN_SUBSEQUENT_OPERATION.set("detail", (JsonNode)JsonNodeFactory.instance.textNode("Subsequent operation failed."));
    }

    private static class OperationAction {
        public final Operation operation;
        public HttpStatusException cause;
        public boolean isPostProcessing;
        public JsonApiDocument doc;
        public String path;

        public OperationAction(Operation operation) {
            this.operation = operation;
            this.cause = null;
        }

        public void postProcess(JsonApiAtomicOperationsRequestScope requestScope) {
            if (this.isPostProcessing) {
                try {
                    JsonApiAtomicOperations.clearAllExceptRelationships(this.doc);
                    PatchVisitor visitor = new PatchVisitor(new JsonApiAtomicOperationsRequestScope(this.path, this.doc, requestScope));
                    visitor.visit(JsonApiParser.parse(this.path));
                }
                catch (HttpStatusException e) {
                    this.cause = e;
                    throw e;
                }
            }
        }
    }
}

