/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.jsonapi.document.processors;

import com.google.common.collect.Lists;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.exceptions.ForbiddenAccessException;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.core.request.Relationship;
import com.yahoo.elide.jsonapi.EntityProjectionMaker;
import com.yahoo.elide.jsonapi.document.processors.DocumentProcessor;
import com.yahoo.elide.jsonapi.models.JsonApiDocument;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IncludedProcessor
implements DocumentProcessor {
    private static final String RELATION_PATH_DELIMITER = "\\.";
    private static final String RELATION_PATH_SEPARATOR = ",";
    private static final String INCLUDE = "include";

    @Override
    public void execute(JsonApiDocument jsonApiDocument, RequestScope scope, PersistentResource resource, Map<String, List<String>> queryParams) {
        if (IncludedProcessor.isPresent(queryParams, INCLUDE)) {
            this.addIncludedResources(jsonApiDocument, resource, queryParams.get(INCLUDE));
        }
    }

    @Override
    public void execute(JsonApiDocument jsonApiDocument, RequestScope scope, LinkedHashSet<PersistentResource> resources, Map<String, List<String>> queryParams) {
        if (IncludedProcessor.isPresent(queryParams, INCLUDE)) {
            resources.forEach(resource -> this.addIncludedResources(jsonApiDocument, (PersistentResource)resource, (List)queryParams.get(INCLUDE)));
        }
    }

    private void addIncludedResources(JsonApiDocument jsonApiDocument, PersistentResource rec, List<String> requestedRelationPaths) {
        EntityProjectionMaker maker = new EntityProjectionMaker(rec.getDictionary(), rec.getRequestScope());
        EntityProjection projection = maker.parseInclude(rec.getResourceType());
        requestedRelationPaths.forEach(pathParam -> {
            List<String> pathList = Arrays.asList(pathParam.split(RELATION_PATH_SEPARATOR));
            pathList.forEach(requestedRelationPath -> {
                ArrayList relationPath = Lists.newArrayList((Object[])requestedRelationPath.split(RELATION_PATH_DELIMITER));
                this.addResourcesForPath(jsonApiDocument, rec, relationPath, projection);
            });
        });
    }

    private void addResourcesForPath(JsonApiDocument jsonApiDocument, PersistentResource<?> rec, List<String> relationPath, EntityProjection projection) {
        Set collection;
        String relation = relationPath.remove(0);
        Relationship relationship = projection.getRelationship(relation).orElseThrow(IllegalStateException::new);
        try {
            collection = (Set)rec.getRelationCheckedFiltered(relationship).toList(LinkedHashSet::new).blockingGet();
        }
        catch (ForbiddenAccessException e) {
            return;
        }
        collection.forEach(resource -> {
            jsonApiDocument.addIncluded(resource.toResource());
            if (!relationPath.isEmpty()) {
                this.addResourcesForPath(jsonApiDocument, (PersistentResource<?>)resource, (List<String>)new ArrayList<String>(relationPath), relationship.getProjection());
            }
        });
    }

    private static boolean isPresent(Map<String, List<String>> queryParams, String key) {
        return queryParams != null && queryParams.get(key) != null;
    }
}

