/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.jsonapi;

import com.yahoo.elide.ElideSettings;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.datastore.DataStoreTransaction;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.exceptions.BadRequestException;
import com.yahoo.elide.core.filter.dialect.ParseException;
import com.yahoo.elide.core.filter.dialect.RSQLFilterDialect;
import com.yahoo.elide.core.filter.dialect.jsonapi.DefaultFilterDialect;
import com.yahoo.elide.core.filter.dialect.jsonapi.JoinFilterDialect;
import com.yahoo.elide.core.filter.dialect.jsonapi.MultipleFilterDialect;
import com.yahoo.elide.core.filter.dialect.jsonapi.SubqueryFilterDialect;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.core.request.route.Route;
import com.yahoo.elide.core.security.User;
import com.yahoo.elide.jsonapi.EntityProjectionMaker;
import com.yahoo.elide.jsonapi.JsonApiMapper;
import com.yahoo.elide.jsonapi.JsonApiSettings;
import com.yahoo.elide.jsonapi.models.JsonApiDocument;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;

public class JsonApiRequestScope
extends RequestScope {
    private final JsonApiDocument jsonApiDocument;
    private final JsonApiMapper mapper;
    private final int updateStatusCode;
    private final MultipleFilterDialect filterDialect;

    public JsonApiRequestScope(Route route, DataStoreTransaction transaction, User user, UUID requestId, ElideSettings elideSettings, Function<RequestScope, EntityProjection> entityProjection, JsonApiDocument jsonApiDocument) {
        block11: {
            super(route, transaction, user, requestId, elideSettings, entityProjection);
            this.jsonApiDocument = jsonApiDocument;
            JsonApiSettings jsonApiSettings = elideSettings.getSettings(JsonApiSettings.class);
            this.mapper = jsonApiSettings.getJsonApiMapper();
            this.updateStatusCode = jsonApiSettings.getUpdateStatusCode();
            ArrayList<JoinFilterDialect> joinFilterDialects = new ArrayList<JoinFilterDialect>(jsonApiSettings.getJoinFilterDialects());
            ArrayList<SubqueryFilterDialect> subqueryFilterDialects = new ArrayList<SubqueryFilterDialect>(jsonApiSettings.getSubqueryFilterDialects());
            EntityDictionary entityDictionary = elideSettings.getEntityDictionary();
            if (joinFilterDialects.isEmpty()) {
                joinFilterDialects.add(new DefaultFilterDialect(entityDictionary));
                joinFilterDialects.add(RSQLFilterDialect.builder().dictionary(entityDictionary).build());
            }
            if (subqueryFilterDialects.isEmpty()) {
                subqueryFilterDialects.add(new DefaultFilterDialect(entityDictionary));
                subqueryFilterDialects.add(RSQLFilterDialect.builder().dictionary(entityDictionary).build());
            }
            this.filterDialect = new MultipleFilterDialect(joinFilterDialects, subqueryFilterDialects);
            Map<String, List<String>> queryParams = this.getRoute().getParameters();
            String path = route.getPath();
            String apiVersion = route.getApiVersion();
            if (!queryParams.isEmpty()) {
                Map<String, List<String>> filterParams = JsonApiRequestScope.getFilterParams(queryParams);
                Object errorMessage = "";
                if (!filterParams.isEmpty()) {
                    try {
                        this.globalFilterExpression = this.filterDialect.parseGlobalExpression(path, filterParams, apiVersion);
                    }
                    catch (ParseException e) {
                        errorMessage = e.getMessage();
                    }
                    try {
                        this.expressionsByType.putAll(this.filterDialect.parseTypedExpression(path, filterParams, apiVersion));
                    }
                    catch (ParseException e) {
                        if (this.globalFilterExpression != null) break block11;
                        if (((String)errorMessage).isEmpty()) {
                            errorMessage = e.getMessage();
                        } else if (!((String)errorMessage).equals(e.getMessage())) {
                            errorMessage = (String)errorMessage + "\n" + e.getMessage();
                        }
                        throw new BadRequestException((String)errorMessage, e);
                    }
                }
            }
        }
    }

    protected JsonApiRequestScope(Route route, JsonApiDocument jsonApiDocument, JsonApiRequestScope outerRequestScope) {
        super(outerRequestScope);
        this.route = route;
        this.jsonApiDocument = jsonApiDocument;
        this.setEntityProjection(new EntityProjectionMaker(outerRequestScope.getElideSettings().getEntityDictionary(), this).parsePath(this.route.getPath()));
        this.updateStatusCode = outerRequestScope.getUpdateStatusCode();
        this.mapper = outerRequestScope.getMapper();
        this.filterDialect = outerRequestScope.getFilterDialect();
    }

    private static Map<String, List<String>> getFilterParams(Map<String, List<String>> queryParams) {
        LinkedHashMap<String, List<String>> returnMap = new LinkedHashMap<String, List<String>>();
        queryParams.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("filter")).forEach(entry -> returnMap.put((String)entry.getKey(), (List)entry.getValue()));
        return returnMap;
    }

    public static JsonApiRequestScopeBuilder builder() {
        return new JsonApiRequestScopeBuilder();
    }

    public JsonApiDocument getJsonApiDocument() {
        return this.jsonApiDocument;
    }

    public JsonApiMapper getMapper() {
        return this.mapper;
    }

    public int getUpdateStatusCode() {
        return this.updateStatusCode;
    }

    public MultipleFilterDialect getFilterDialect() {
        return this.filterDialect;
    }

    public static class JsonApiRequestScopeBuilder
    extends RequestScope.RequestScopeBuilder {
        protected JsonApiDocument jsonApiDocument;

        public JsonApiRequestScopeBuilder jsonApiDocument(JsonApiDocument jsonApiDocument) {
            this.jsonApiDocument = jsonApiDocument;
            return this;
        }

        @Override
        public JsonApiRequestScope build() {
            this.applyDefaults();
            return new JsonApiRequestScope(this.route, this.dataStoreTransaction, this.user, this.requestId, this.elideSettings, this.entityProjection, this.jsonApiDocument);
        }

        @Override
        public JsonApiRequestScopeBuilder route(Route route) {
            super.route(route);
            return this;
        }

        @Override
        public JsonApiRequestScopeBuilder dataStoreTransaction(DataStoreTransaction transaction) {
            super.dataStoreTransaction(transaction);
            return this;
        }

        @Override
        public JsonApiRequestScopeBuilder user(User user) {
            super.user(user);
            return this;
        }

        @Override
        public JsonApiRequestScopeBuilder requestId(UUID requestId) {
            super.requestId(requestId);
            return this;
        }

        @Override
        public JsonApiRequestScopeBuilder elideSettings(ElideSettings elideSettings) {
            super.elideSettings(elideSettings);
            return this;
        }

        @Override
        public JsonApiRequestScopeBuilder entityProjection(Function<RequestScope, EntityProjection> entityProjection) {
            super.entityProjection(entityProjection);
            return this;
        }
    }
}

