/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.jsonapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.elide.jsonapi.extensions.JsonApiAtomicOperationsMapper;
import com.yahoo.elide.jsonapi.extensions.JsonApiJsonPatchMapper;
import com.yahoo.elide.jsonapi.models.JsonApiDocument;
import com.yahoo.elide.jsonapi.serialization.JsonApiModule;
import java.io.IOException;

public class JsonApiMapper {
    protected final ObjectMapper mapper;
    protected final JsonApiJsonPatchMapper jsonPatchMapper;
    protected final JsonApiAtomicOperationsMapper atomicOperationsMapper;

    public JsonApiMapper() {
        this(new ObjectMapper());
    }

    public JsonApiMapper(ObjectMapper mapper) {
        this(mapper, new JsonApiJsonPatchMapper(mapper), new JsonApiAtomicOperationsMapper(mapper));
    }

    public JsonApiMapper(ObjectMapper mapper, JsonApiJsonPatchMapper jsonPatchMapper, JsonApiAtomicOperationsMapper atomicOperationsMapper) {
        this.mapper = mapper;
        this.mapper.registerModule((Module)new JsonApiModule());
        this.jsonPatchMapper = jsonPatchMapper;
        this.atomicOperationsMapper = atomicOperationsMapper;
    }

    public JsonNode toJsonObject(JsonApiDocument jsonApiDocument) {
        return (JsonNode)this.mapper.convertValue((Object)jsonApiDocument, JsonNode.class);
    }

    public <T> String writeJsonApiDocument(T doc) throws JsonProcessingException {
        return this.mapper.writeValueAsString(doc);
    }

    public JsonApiDocument readJsonApiDocument(String doc) throws IOException {
        JsonNode node = this.mapper.readTree(doc);
        return this.readJsonApiDocument(node);
    }

    public JsonApiDocument readJsonApiDocument(JsonNode node) throws IOException {
        return (JsonApiDocument)this.mapper.treeToValue((TreeNode)node, JsonApiDocument.class);
    }

    public ObjectMapper getObjectMapper() {
        return this.mapper;
    }

    public JsonApiJsonPatchMapper forJsonPatch() {
        return this.jsonPatchMapper;
    }

    public JsonApiAtomicOperationsMapper forAtomicOperations() {
        return this.atomicOperationsMapper;
    }
}

