/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.jsonapi;

import com.yahoo.elide.core.exceptions.ErrorContext;
import com.yahoo.elide.jsonapi.JsonApiMapper;

public class JsonApiErrorContext
implements ErrorContext {
    private final boolean verbose;
    private final JsonApiMapper mapper;

    JsonApiErrorContext(boolean verbose, JsonApiMapper mapper) {
        this.verbose = verbose;
        this.mapper = mapper;
    }

    public static JsonApiErrorContextBuilder builder() {
        return new JsonApiErrorContextBuilder();
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    public JsonApiMapper getMapper() {
        return this.mapper;
    }

    public static class JsonApiErrorContextBuilder {
        private boolean verbose;
        private JsonApiMapper mapper;

        JsonApiErrorContextBuilder() {
        }

        public JsonApiErrorContextBuilder verbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public JsonApiErrorContextBuilder mapper(JsonApiMapper mapper) {
            this.mapper = mapper;
            return this;
        }

        public JsonApiErrorContext build() {
            return new JsonApiErrorContext(this.verbose, this.mapper);
        }

        public String toString() {
            return "JsonApiErrorContext.JsonApiErrorContextBuilder(verbose=" + this.verbose + ", mapper=" + this.mapper + ")";
        }
    }
}

