/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.jsonapi;

import com.fasterxml.jackson.core.JacksonException;
import com.yahoo.elide.ElideError;
import com.yahoo.elide.ElideErrorResponse;
import com.yahoo.elide.ElideErrors;
import com.yahoo.elide.ElideResponse;
import com.yahoo.elide.core.exceptions.BadRequestException;
import com.yahoo.elide.core.exceptions.ExceptionHandlerSupport;
import com.yahoo.elide.core.exceptions.ExceptionLogger;
import com.yahoo.elide.core.exceptions.ExceptionMappers;
import com.yahoo.elide.core.exceptions.ForbiddenAccessException;
import com.yahoo.elide.core.exceptions.HttpStatusException;
import com.yahoo.elide.core.exceptions.InvalidURLException;
import com.yahoo.elide.core.exceptions.JsonApiAtomicOperationsException;
import com.yahoo.elide.core.exceptions.JsonPatchExtensionException;
import com.yahoo.elide.core.exceptions.TransactionException;
import com.yahoo.elide.jsonapi.JsonApiErrorContext;
import com.yahoo.elide.jsonapi.JsonApiErrorMapper;
import com.yahoo.elide.jsonapi.JsonApiExceptionHandler;
import com.yahoo.elide.jsonapi.models.JsonApiErrors;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJsonApiExceptionHandler
extends ExceptionHandlerSupport<JsonApiErrorContext>
implements JsonApiExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultJsonApiExceptionHandler.class);
    protected JsonApiErrorMapper jsonApiErrorMapper;

    public DefaultJsonApiExceptionHandler(ExceptionLogger exceptionLogger, ExceptionMappers exceptionMappers, JsonApiErrorMapper jsonApiErrorMapper) {
        super(exceptionLogger, exceptionMappers);
        this.jsonApiErrorMapper = jsonApiErrorMapper;
    }

    @Override
    public ElideResponse<?> handleException(Throwable exception, JsonApiErrorContext errorContext) {
        return super.handleException(exception, errorContext);
    }

    @Override
    protected ElideResponse<?> handleRuntimeException(RuntimeException exception, JsonApiErrorContext errorContext) {
        if (exception instanceof ForbiddenAccessException) {
            ForbiddenAccessException e = (ForbiddenAccessException)exception;
            return this.buildResponse(e, errorContext);
        }
        if (exception instanceof JsonPatchExtensionException) {
            JsonPatchExtensionException e = (JsonPatchExtensionException)exception;
            return this.buildResponse(e, errorContext);
        }
        if (exception instanceof JsonApiAtomicOperationsException) {
            JsonApiAtomicOperationsException e = (JsonApiAtomicOperationsException)exception;
            return this.buildResponse(e, errorContext);
        }
        if (exception instanceof HttpStatusException) {
            HttpStatusException e = (HttpStatusException)exception;
            return this.buildResponse(e, errorContext);
        }
        if (exception instanceof ParseCancellationException) {
            ParseCancellationException e = (ParseCancellationException)exception;
            return this.buildResponse(new InvalidURLException((Exception)e), errorContext);
        }
        if (exception instanceof ConstraintViolationException) {
            ConstraintViolationException e = (ConstraintViolationException)exception;
            JsonApiErrors.JsonApiErrorsBuilder errors = JsonApiErrors.builder();
            for (ConstraintViolation constraintViolation : e.getConstraintViolations()) {
                errors.error(error -> {
                    error.detail(constraintViolation.getMessage());
                    error.code(constraintViolation.getConstraintDescriptor().getAnnotation().annotationType().getSimpleName());
                    String propertyPathString = constraintViolation.getPropertyPath().toString();
                    if (!propertyPathString.isEmpty()) {
                        error.source(source -> source.pointer("/data/attributes/" + propertyPathString.replace(".", "/")));
                        error.meta(meta -> {
                            meta.put("type", "ConstraintViolation");
                            meta.put("property", propertyPathString);
                        });
                    }
                });
            }
            return this.buildResponse(400, errors.build());
        }
        log.error("Error or exception uncaught by Elide", (Throwable)exception);
        throw exception;
    }

    @Override
    protected ElideResponse<?> handleNonRuntimeException(Exception exception, JsonApiErrorContext errorContext) {
        if (exception instanceof JacksonException) {
            JacksonException jacksonException = (JacksonException)exception;
            String message = jacksonException.getLocation() != null && jacksonException.getLocation().contentReference().getRawContent() != null ? exception.getMessage() : jacksonException.getOriginalMessage();
            return this.buildResponse(new BadRequestException(message), errorContext);
        }
        if (exception instanceof IOException) {
            return this.buildResponse(new TransactionException(exception), errorContext);
        }
        log.error("Error or exception uncaught by Elide", (Throwable)exception);
        if (exception instanceof IOException) {
            IOException e = (IOException)exception;
            throw new UncheckedIOException(e);
        }
        throw new RuntimeException(exception);
    }

    @Override
    protected ElideResponse<?> buildResponse(ElideErrorResponse<?> errorResponse) {
        Object t = errorResponse.getBody();
        if (t instanceof ElideErrors) {
            ElideErrors errors = (ElideErrors)t;
            JsonApiErrors.JsonApiErrorsBuilder builder = JsonApiErrors.builder();
            for (ElideError error : errors.getErrors()) {
                builder.error(this.jsonApiErrorMapper.toJsonApiError(error));
            }
            return this.buildResponse(errorResponse.getStatus(), builder.build());
        }
        return this.buildResponse(errorResponse.getStatus(), errorResponse.getBody());
    }

    @Override
    protected ElideResponse<?> buildResponse(int status, Object body) {
        return new ElideResponse<Object>(status, body);
    }
}

