/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.jsonapi;

import com.yahoo.elide.ElideError;
import com.yahoo.elide.jsonapi.JsonApiErrorMapper;
import com.yahoo.elide.jsonapi.models.JsonApiError;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;

public class DefaultJsonApiErrorMapper
implements JsonApiErrorMapper {
    @Override
    public JsonApiError toJsonApiError(ElideError error) {
        JsonApiError.JsonApiErrorBuilder jsonApiError = JsonApiError.builder();
        if (error.getMessage() != null) {
            jsonApiError.detail(error.getMessage());
        }
        if (error.getAttributes() != null && !error.getAttributes().isEmpty()) {
            LinkedHashMap<String, Object> meta = new LinkedHashMap<String, Object>(error.getAttributes());
            this.attribute("id", meta, value -> {
                jsonApiError.id(value.toString());
                return true;
            });
            this.attribute("status", meta, value -> {
                jsonApiError.status(value.toString());
                return true;
            });
            this.attribute("code", meta, value -> {
                jsonApiError.code(value.toString());
                return true;
            });
            this.attribute("title", meta, value -> {
                jsonApiError.title(value.toString());
                return true;
            });
            this.attribute("source", meta, value -> {
                if (value instanceof JsonApiError.Source) {
                    JsonApiError.Source source = (JsonApiError.Source)value;
                    jsonApiError.source(source);
                } else if (value instanceof Map) {
                    Map map = (Map)value;
                    jsonApiError.source(this.toSource(map));
                }
                return true;
            });
            this.attribute("links", meta, value -> {
                if (value instanceof JsonApiError.Links) {
                    JsonApiError.Links links = (JsonApiError.Links)value;
                    jsonApiError.links(links);
                } else if (value instanceof Map) {
                    Map map = (Map)value;
                    jsonApiError.links(this.toLinks(map));
                }
                return true;
            });
            if (!meta.isEmpty()) {
                jsonApiError.meta(meta);
            }
        }
        return jsonApiError.build();
    }

    protected JsonApiError.Links toLinks(Map<?, ?> map) {
        JsonApiError.Links.LinksBuilder builder = JsonApiError.Links.builder();
        this.get("about", map).ifPresent(builder::about);
        this.get("type", map).ifPresent(builder::type);
        return builder.build();
    }

    protected JsonApiError.Source toSource(Map<?, ?> map) {
        JsonApiError.Source.SourceBuilder builder = JsonApiError.Source.builder();
        this.get("pointer", map).ifPresent(builder::pointer);
        this.get("parameter", map).ifPresent(builder::parameter);
        this.get("header", map).ifPresent(builder::header);
        return builder.build();
    }

    protected Optional<String> get(String key, Map<?, ?> map) {
        Object obj = map.get(key);
        if (obj instanceof String) {
            String value = (String)obj;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    protected void attribute(String key, Map<String, Object> map, Predicate<Object> processor) {
        if (map.containsKey(key) && processor.test(map.get(key))) {
            map.remove(key);
        }
    }
}

