/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.utils.coerce.converters;

import com.yahoo.elide.core.utils.coerce.converters.Serde;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public class OffsetDateTimeSerde
implements Serde<String, OffsetDateTime> {
    @Override
    public OffsetDateTime deserialize(String val) {
        try {
            return OffsetDateTime.parse(val, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }
        catch (DateTimeParseException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public String serialize(OffsetDateTime val) {
        return val.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }
}

