/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.security.visitors;

import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.filter.Operator;
import com.yahoo.elide.core.filter.expression.AndFilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpressionVisitor;
import com.yahoo.elide.core.filter.expression.NotFilterExpression;
import com.yahoo.elide.core.filter.expression.OrFilterExpression;
import com.yahoo.elide.core.filter.predicates.FilterPredicate;
import com.yahoo.elide.core.security.RequestScope;
import com.yahoo.elide.core.security.checks.Check;
import com.yahoo.elide.core.security.checks.FilterExpressionCheck;
import com.yahoo.elide.core.security.checks.UserCheck;
import com.yahoo.elide.core.security.permissions.expressions.AndExpression;
import com.yahoo.elide.core.security.permissions.expressions.AnyFieldExpression;
import com.yahoo.elide.core.security.permissions.expressions.BooleanExpression;
import com.yahoo.elide.core.security.permissions.expressions.CheckExpression;
import com.yahoo.elide.core.security.permissions.expressions.ExpressionVisitor;
import com.yahoo.elide.core.security.permissions.expressions.NotExpression;
import com.yahoo.elide.core.security.permissions.expressions.OrExpression;
import com.yahoo.elide.core.security.permissions.expressions.SpecificFieldExpression;
import com.yahoo.elide.core.type.Type;
import java.util.Objects;

public class PermissionToFilterExpressionVisitor
implements ExpressionVisitor<FilterExpression> {
    private final EntityDictionary dictionary;
    private final Type entityClass;
    private final RequestScope requestScope;
    public static final FilterExpression NO_EVALUATION_EXPRESSION = new FilterExpression(){

        @Override
        public <T> T accept(FilterExpressionVisitor<T> visitor) {
            return (T)this;
        }

        public String toString() {
            return "NO_EVALUATION_EXPRESSION";
        }
    };
    public static final FilterExpression FALSE_USER_CHECK_EXPRESSION = new FilterExpression(){

        @Override
        public <T> T accept(FilterExpressionVisitor<T> visitor) {
            return (T)this;
        }

        public String toString() {
            return "FALSE_USER_CHECK_EXPRESSION";
        }
    };
    public static final FilterExpression TRUE_USER_CHECK_EXPRESSION = new FilterExpression(){

        @Override
        public <T> T accept(FilterExpressionVisitor<T> visitor) {
            return (T)this;
        }

        public String toString() {
            return "TRUE_USER_EXPRESSION";
        }
    };

    public PermissionToFilterExpressionVisitor(EntityDictionary dictionary, RequestScope requestScope, Type entityClass) {
        this.dictionary = dictionary;
        this.requestScope = requestScope;
        this.entityClass = entityClass;
    }

    @Override
    public FilterExpression visitNotExpression(NotExpression notExpression) {
        FilterExpression expression = notExpression.getLogical().accept(this);
        if (Objects.equals(expression, TRUE_USER_CHECK_EXPRESSION)) {
            return FALSE_USER_CHECK_EXPRESSION;
        }
        if (Objects.equals(expression, FALSE_USER_CHECK_EXPRESSION)) {
            return TRUE_USER_CHECK_EXPRESSION;
        }
        if (Objects.equals(expression, NO_EVALUATION_EXPRESSION)) {
            return NO_EVALUATION_EXPRESSION;
        }
        if (expression instanceof FilterPredicate) {
            return ((FilterPredicate)expression).negate();
        }
        return new NotFilterExpression(expression);
    }

    @Override
    public FilterExpression visitOrExpression(OrExpression orExpression) {
        FilterExpression left = orExpression.getLeft().accept(this);
        FilterExpression right = orExpression.getRight().accept(this);
        if (this.expressionWillNotFilter(left)) {
            return left;
        }
        if (this.expressionWillNotFilter(right)) {
            return right;
        }
        boolean leftFails = this.expressionWillFail(left);
        boolean rightFails = this.expressionWillFail(right);
        if (leftFails && rightFails) {
            return FALSE_USER_CHECK_EXPRESSION;
        }
        if (leftFails) {
            return right;
        }
        if (rightFails) {
            return left;
        }
        return new OrFilterExpression(left, right);
    }

    @Override
    public FilterExpression visitAndExpression(AndExpression andExpression) {
        FilterExpression left = andExpression.getLeft().accept(this);
        FilterExpression right = andExpression.getRight().accept(this);
        if (this.expressionWillFail(left) || this.expressionWillFail(right)) {
            return FALSE_USER_CHECK_EXPRESSION;
        }
        if (this.expressionWillNotFilter(left)) {
            return right;
        }
        if (this.expressionWillNotFilter(right)) {
            return left;
        }
        return new AndFilterExpression(left, right);
    }

    private boolean expressionWillFail(FilterExpression expression) {
        return Objects.equals(expression, FALSE_USER_CHECK_EXPRESSION) || this.operator(expression) == Operator.FALSE;
    }

    private boolean expressionWillNotFilter(FilterExpression expression) {
        return Objects.equals(expression, NO_EVALUATION_EXPRESSION) || Objects.equals(expression, TRUE_USER_CHECK_EXPRESSION) || this.operator(expression) == Operator.TRUE;
    }

    @Override
    public FilterExpression visitCheckExpression(CheckExpression checkExpression) {
        Check check = checkExpression.getCheck();
        if (check instanceof FilterExpressionCheck) {
            FilterExpressionCheck filterCheck = (FilterExpressionCheck)check;
            FilterExpression filterExpression = filterCheck.getFilterExpression(this.entityClass, this.requestScope);
            if (filterExpression == null) {
                throw new IllegalStateException("FilterCheck#getFilterExpression must not return null.");
            }
            return filterExpression;
        }
        if (check instanceof UserCheck) {
            boolean userCheckResult = ((UserCheck)check).ok(this.requestScope.getUser());
            return userCheckResult ? TRUE_USER_CHECK_EXPRESSION : FALSE_USER_CHECK_EXPRESSION;
        }
        return NO_EVALUATION_EXPRESSION;
    }

    private Operator operator(FilterExpression expression) {
        return expression instanceof FilterPredicate ? ((FilterPredicate)expression).getOperator() : null;
    }

    @Override
    public FilterExpression visitSpecificFieldExpression(SpecificFieldExpression expression) {
        return NO_EVALUATION_EXPRESSION;
    }

    @Override
    public FilterExpression visitAnyFieldExpression(AnyFieldExpression expression) {
        return NO_EVALUATION_EXPRESSION;
    }

    @Override
    public FilterExpression visitBooleanExpression(BooleanExpression expression) {
        return NO_EVALUATION_EXPRESSION;
    }
}

