/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.security.executors;

import com.yahoo.elide.annotation.ReadPermission;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.security.ChangeSpec;
import com.yahoo.elide.core.security.executors.AbstractPermissionExecutor;
import com.yahoo.elide.core.security.permissions.ExpressionResult;
import com.yahoo.elide.core.security.permissions.expressions.Expression;
import com.yahoo.elide.core.type.Type;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregationStorePermissionExecutor
extends AbstractPermissionExecutor {
    private static final Logger log = LoggerFactory.getLogger(AggregationStorePermissionExecutor.class);

    public AggregationStorePermissionExecutor(RequestScope requestScope) {
        super(log, requestScope);
    }

    @Override
    public <A extends Annotation> ExpressionResult checkPermission(Class<A> annotationClass, PersistentResource resource, Set<String> requestedFields) {
        if (!annotationClass.equals(ReadPermission.class)) {
            return ExpressionResult.FAIL;
        }
        Supplier<Expression> expressionSupplier = () -> this.expressionBuilder.buildUserCheckAnyFieldOnlyExpression(resource.getResourceType(), annotationClass, requestedFields, this.requestScope);
        return this.checkOnlyUserPermissions(resource.getResourceType(), annotationClass, requestedFields, expressionSupplier);
    }

    @Override
    public <A extends Annotation> ExpressionResult checkSpecificFieldPermissions(PersistentResource<?> resource, ChangeSpec changeSpec, Class<A> annotationClass, String field) {
        if (!annotationClass.equals(ReadPermission.class)) {
            return ExpressionResult.FAIL;
        }
        return this.checkUserPermissions(resource.getResourceType(), annotationClass, field);
    }

    @Override
    public <A extends Annotation> ExpressionResult checkSpecificFieldPermissionsDeferred(PersistentResource<?> resource, ChangeSpec changeSpec, Class<A> annotationClass, String field) {
        return this.checkSpecificFieldPermissions(resource, changeSpec, annotationClass, field);
    }

    @Override
    public <A extends Annotation> ExpressionResult checkUserPermissions(Type<?> resourceClass, Class<A> annotationClass, Set<String> requestedFields) {
        if (!annotationClass.equals(ReadPermission.class)) {
            return ExpressionResult.FAIL;
        }
        Expression expression = this.expressionBuilder.buildUserCheckEntityAndAnyFieldExpression(resourceClass, annotationClass, requestedFields, this.requestScope);
        return this.executeExpressions(expression, annotationClass, Expression.EvaluationMode.USER_CHECKS_ONLY);
    }

    @Override
    public <A extends Annotation> ExpressionResult checkUserPermissions(Type<?> resourceClass, Class<A> annotationClass, String field) {
        if (!annotationClass.equals(ReadPermission.class)) {
            return ExpressionResult.FAIL;
        }
        Supplier<Expression> expressionSupplier = () -> this.expressionBuilder.buildUserCheckFieldExpressions(resourceClass, this.requestScope, annotationClass, field, false);
        return this.checkOnlyUserPermissions(resourceClass, annotationClass, Collections.singleton(field), expressionSupplier);
    }

    @Override
    public Optional<FilterExpression> getReadPermissionFilter(Type<?> resourceClass, Set<String> requestedFields) {
        FilterExpression filterExpression = this.expressionBuilder.buildEntityFilterExpression(resourceClass, this.requestScope);
        return Optional.ofNullable(filterExpression);
    }
}

