/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.security.executors;

import com.google.common.collect.ImmutableSet;
import com.yahoo.elide.annotation.CreatePermission;
import com.yahoo.elide.annotation.DeletePermission;
import com.yahoo.elide.annotation.NonTransferable;
import com.yahoo.elide.annotation.ReadPermission;
import com.yahoo.elide.annotation.UpdatePermission;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.exceptions.ForbiddenAccessException;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.security.ChangeSpec;
import com.yahoo.elide.core.security.PermissionExecutor;
import com.yahoo.elide.core.security.permissions.ExpressionResult;
import com.yahoo.elide.core.security.permissions.ExpressionResultCache;
import com.yahoo.elide.core.security.permissions.PermissionExpressionBuilder;
import com.yahoo.elide.core.security.permissions.expressions.Expression;
import com.yahoo.elide.core.type.Type;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivePermissionExecutor
implements PermissionExecutor {
    private static final Logger log = LoggerFactory.getLogger(ActivePermissionExecutor.class);
    private final Queue<QueuedCheck> commitCheckQueue = new LinkedBlockingQueue<QueuedCheck>();
    private final RequestScope requestScope;
    private final PermissionExpressionBuilder expressionBuilder;
    private final Map<Triple<Class<? extends Annotation>, Type, ImmutableSet<String>>, ExpressionResult> userPermissionCheckCache;
    private final Map<String, Long> checkStats;

    public ActivePermissionExecutor(RequestScope requestScope) {
        ExpressionResultCache cache = new ExpressionResultCache();
        this.requestScope = requestScope;
        this.expressionBuilder = new PermissionExpressionBuilder(cache, requestScope.getDictionary());
        this.userPermissionCheckCache = new HashMap<Triple<Class<? extends Annotation>, Type, ImmutableSet<String>>, ExpressionResult>();
        this.checkStats = new HashMap<String, Long>();
    }

    @Override
    public <A extends Annotation> ExpressionResult checkPermission(Class<A> annotationClass, PersistentResource resource, Set<String> requestedFields) {
        Supplier<Expression> expressionSupplier = () -> {
            if (NonTransferable.class == annotationClass) {
                if (this.requestScope.getDictionary().isTransferable(resource.getResourceType())) {
                    return this.expressionBuilder.buildAnyFieldExpressions(resource, ReadPermission.class, requestedFields, null);
                }
                return PermissionExpressionBuilder.FAIL_EXPRESSION;
            }
            return this.expressionBuilder.buildAnyFieldExpressions(resource, annotationClass, requestedFields, null);
        };
        Function<Expression, ExpressionResult> expressionExecutor = expression -> {
            if (resource.isNewlyCreated()) {
                return this.executeUserChecksDeferInline(annotationClass, (Expression)expression);
            }
            return this.executeExpressions((Expression)expression, annotationClass, Expression.EvaluationMode.INLINE_CHECKS_ONLY);
        };
        return this.checkPermissions(resource.getResourceType(), annotationClass, requestedFields, expressionSupplier, expressionExecutor);
    }

    private <A extends Annotation> ExpressionResult executeUserChecksDeferInline(Class<A> annotationClass, Expression expression) {
        ExpressionResult result = this.executeExpressions(expression, annotationClass, Expression.EvaluationMode.USER_CHECKS_ONLY);
        if (result == ExpressionResult.DEFERRED) {
            this.commitCheckQueue.add(new QueuedCheck(expression, annotationClass));
        }
        return result;
    }

    @Override
    public <A extends Annotation> ExpressionResult checkSpecificFieldPermissions(PersistentResource<?> resource, ChangeSpec changeSpec, Class<A> annotationClass, String field) {
        Supplier<Expression> expressionSupplier = () -> this.expressionBuilder.buildSpecificFieldExpressions(resource, annotationClass, field, changeSpec);
        Function<Expression, ExpressionResult> expressionExecutor = expression -> this.executeExpressions((Expression)expression, annotationClass, Expression.EvaluationMode.INLINE_CHECKS_ONLY);
        return this.checkPermissions(resource.getResourceType(), annotationClass, Collections.singleton(field), expressionSupplier, expressionExecutor);
    }

    @Override
    public <A extends Annotation> ExpressionResult checkSpecificFieldPermissionsDeferred(PersistentResource<?> resource, ChangeSpec changeSpec, Class<A> annotationClass, String field) {
        Class expressionAnnotation = annotationClass.isAssignableFrom(UpdatePermission.class) && this.requestScope.getNewResources().contains(resource) ? CreatePermission.class : annotationClass;
        Supplier<Expression> expressionSupplier = () -> this.expressionBuilder.buildSpecificFieldExpressions(resource, expressionAnnotation, field, changeSpec);
        Function<Expression, ExpressionResult> expressionExecutor = expression -> {
            if (this.requestScope.getNewPersistentResources().contains(resource)) {
                return this.executeUserChecksDeferInline(expressionAnnotation, (Expression)expression);
            }
            return this.executeExpressions((Expression)expression, expressionAnnotation, Expression.EvaluationMode.INLINE_CHECKS_ONLY);
        };
        return this.checkPermissions(resource.getResourceType(), expressionAnnotation, Collections.singleton(field), expressionSupplier, expressionExecutor);
    }

    @Override
    public <A extends Annotation> ExpressionResult checkUserPermissions(Type<?> resourceClass, Class<A> annotationClass, Set<String> requestedFields) {
        Supplier<Expression> expressionSupplier = () -> this.expressionBuilder.buildUserCheckAnyExpression(resourceClass, annotationClass, requestedFields, this.requestScope);
        return this.checkOnlyUserPermissions(resourceClass, annotationClass, requestedFields, expressionSupplier);
    }

    protected <A extends Annotation> ExpressionResult checkPermissions(Type<?> resourceClass, Class<A> annotationClass, Set<String> fields, Supplier<Expression> expressionSupplier, Optional<Function<Expression, ExpressionResult>> expressionExecutor) {
        ImmutableSet immutableFields = fields == null ? null : ImmutableSet.copyOf(fields);
        ExpressionResult expressionResult = this.userPermissionCheckCache.get(Triple.of(annotationClass, resourceClass, (Object)immutableFields));
        if (expressionResult == ExpressionResult.PASS) {
            return expressionResult;
        }
        Expression expression = expressionSupplier.get();
        if (expressionResult == null) {
            expressionResult = this.executeExpressions(expression, annotationClass, Expression.EvaluationMode.USER_CHECKS_ONLY);
            this.userPermissionCheckCache.put((Triple<Class<? extends Annotation>, Type, ImmutableSet<String>>)Triple.of(annotationClass, resourceClass, (Object)immutableFields), expressionResult);
            if (expressionResult == ExpressionResult.PASS) {
                return expressionResult;
            }
        }
        return expressionExecutor.map(executor -> (ExpressionResult)((Object)((Object)executor.apply(expression)))).orElse(expressionResult);
    }

    protected <A extends Annotation> ExpressionResult checkOnlyUserPermissions(Type<?> resourceClass, Class<A> annotationClass, Set<String> fields, Supplier<Expression> expressionSupplier) {
        return this.checkPermissions(resourceClass, annotationClass, fields, expressionSupplier, Optional.empty());
    }

    protected <A extends Annotation> ExpressionResult checkPermissions(Type<?> resourceClass, Class<A> annotationClass, Set<String> fields, Supplier<Expression> expressionSupplier, Function<Expression, ExpressionResult> expressionExecutor) {
        return this.checkPermissions(resourceClass, annotationClass, fields, expressionSupplier, Optional.of(expressionExecutor));
    }

    @Override
    public Optional<FilterExpression> getReadPermissionFilter(Type<?> resourceClass, Set<String> requestedFields) {
        FilterExpression filterExpression = this.expressionBuilder.buildAnyFieldFilterExpression(resourceClass, this.requestScope, requestedFields);
        return Optional.ofNullable(filterExpression);
    }

    @Override
    public void executeCommitChecks() {
        this.commitCheckQueue.forEach(expr -> {
            Expression expression = expr.getExpression();
            ExpressionResult result = expression.evaluate(Expression.EvaluationMode.ALL_CHECKS);
            if (result == ExpressionResult.FAIL) {
                ForbiddenAccessException e = new ForbiddenAccessException(expr.getAnnotationClass(), expression, Expression.EvaluationMode.ALL_CHECKS);
                if (log.isTraceEnabled()) {
                    log.trace("{}", (Object)e.getLoggedMessage());
                }
                throw e;
            }
        });
        this.commitCheckQueue.clear();
    }

    private ExpressionResult executeExpressions(Expression expression, Class<? extends Annotation> annotationClass, Expression.EvaluationMode mode) {
        ForbiddenAccessException e;
        ExpressionResult result = expression.evaluate(mode);
        if (log.isTraceEnabled()) {
            String checkKey = expression.toString();
            Long checkOccurrences = this.checkStats.getOrDefault(checkKey, 0L) + 1L;
            this.checkStats.put(checkKey, checkOccurrences);
        }
        if (result == ExpressionResult.DEFERRED) {
            if (mode == Expression.EvaluationMode.USER_CHECKS_ONLY) {
                return ExpressionResult.DEFERRED;
            }
            if (this.isInlineOnlyCheck(annotationClass)) {
                result = expression.evaluate(Expression.EvaluationMode.ALL_CHECKS);
                if (result == ExpressionResult.FAIL) {
                    e = new ForbiddenAccessException(annotationClass, expression, Expression.EvaluationMode.ALL_CHECKS);
                    if (log.isTraceEnabled()) {
                        log.trace("{}", (Object)e.getLoggedMessage());
                    }
                    throw e;
                }
                return result;
            }
            this.commitCheckQueue.add(new QueuedCheck(expression, annotationClass));
            return ExpressionResult.DEFERRED;
        }
        if (result == ExpressionResult.FAIL) {
            e = new ForbiddenAccessException(annotationClass, expression, mode);
            if (log.isTraceEnabled()) {
                log.trace("{}", (Object)e.getLoggedMessage());
            }
            throw e;
        }
        return result;
    }

    private boolean isInlineOnlyCheck(Class<? extends Annotation> annotationClass) {
        return ReadPermission.class.isAssignableFrom(annotationClass) || DeletePermission.class.isAssignableFrom(annotationClass);
    }

    @Override
    public void logCheckStats() {
        if (log.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder("Permission Check Statistics:\n");
            this.checkStats.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEachOrdered(e -> sb.append((String)e.getKey() + ": " + e.getValue() + "\n"));
            String stats = sb.toString();
            log.trace(stats);
        }
    }

    @Override
    public <A extends Annotation> ExpressionResult checkUserPermissions(Type<?> resourceClass, Class<A> annotationClass, String field) {
        Supplier<Expression> expressionSupplier = () -> this.expressionBuilder.buildUserCheckFieldExpressions(resourceClass, this.requestScope, annotationClass, field);
        return this.checkOnlyUserPermissions(resourceClass, annotationClass, Collections.singleton(field), expressionSupplier);
    }

    private static class QueuedCheck {
        private final Expression expression;
        private final Class<? extends Annotation> annotationClass;

        public QueuedCheck(Expression expression, Class<? extends Annotation> annotationClass) {
            this.expression = expression;
            this.annotationClass = annotationClass;
        }

        public Expression getExpression() {
            return this.expression;
        }

        public Class<? extends Annotation> getAnnotationClass() {
            return this.annotationClass;
        }
    }
}

