/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.request.route;

import com.yahoo.elide.core.request.route.ApiVersionValidator;
import com.yahoo.elide.core.request.route.Route;
import com.yahoo.elide.core.request.route.RouteResolver;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ParameterRouteResolver
implements RouteResolver {
    private final String apiVersionParameterName;
    private final ApiVersionValidator apiVersionValidator;

    public ParameterRouteResolver(String apiVersionParameterName, ApiVersionValidator apiVersionValidator) {
        this.apiVersionParameterName = apiVersionParameterName;
        this.apiVersionValidator = apiVersionValidator;
    }

    @Override
    public Route resolve(String mediaType, String baseUrl, String path, Map<String, List<String>> headers, Map<String, List<String>> parameters) {
        String apiVersion;
        Map<String, List<String>> result = parameters;
        if (parameters != null && parameters.get(this.apiVersionParameterName) != null && this.apiVersionValidator.isValidApiVersion(apiVersion = parameters.get(this.apiVersionParameterName).get(0))) {
            result = new LinkedHashMap<String, List<String>>(parameters);
            result.remove(this.apiVersionParameterName);
            return Route.builder().apiVersion(apiVersion).baseUrl(baseUrl).path(path).headers(headers).parameters(result).build();
        }
        return Route.builder().apiVersion("").baseUrl(baseUrl).path(path).headers(headers).parameters(result).build();
    }
}

