/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.request;

import com.yahoo.elide.core.request.EntityProjection;
import lombok.NonNull;

public class Relationship {
    @NonNull
    private String name;
    private String alias;
    @NonNull
    private EntityProjection projection;

    public RelationshipBuilder copyOf() {
        return Relationship.builder().alias(this.alias).name(this.name).projection(this.projection);
    }

    private Relationship(@NonNull String name, String alias, @NonNull EntityProjection projection) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (projection == null) {
            throw new NullPointerException("projection is marked non-null but is null");
        }
        this.name = name;
        this.alias = alias == null ? name : alias;
        this.projection = projection;
    }

    public Relationship merge(Relationship toMerge) {
        return Relationship.builder().name(this.name).alias(this.alias).projection(this.projection.merge(toMerge.projection)).build();
    }

    public static RelationshipBuilder builder() {
        return new RelationshipBuilder();
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    @NonNull
    public EntityProjection getProjection() {
        return this.projection;
    }

    public void setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setProjection(@NonNull EntityProjection projection) {
        if (projection == null) {
            throw new NullPointerException("projection is marked non-null but is null");
        }
        this.projection = projection;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Relationship)) {
            return false;
        }
        Relationship other = (Relationship)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        EntityProjection this$projection = this.getProjection();
        EntityProjection other$projection = other.getProjection();
        return !(this$projection == null ? other$projection != null : !((Object)this$projection).equals(other$projection));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Relationship;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        EntityProjection $projection = this.getProjection();
        result = result * 59 + ($projection == null ? 43 : ((Object)$projection).hashCode());
        return result;
    }

    public String toString() {
        return "Relationship(name=" + this.getName() + ", alias=" + this.getAlias() + ", projection=" + this.getProjection() + ")";
    }

    public static class RelationshipBuilder {
        private String name;
        private String alias;
        private EntityProjection projection;

        RelationshipBuilder() {
        }

        public RelationshipBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public RelationshipBuilder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public RelationshipBuilder projection(@NonNull EntityProjection projection) {
            if (projection == null) {
                throw new NullPointerException("projection is marked non-null but is null");
            }
            this.projection = projection;
            return this;
        }

        public Relationship build() {
            return new Relationship(this.name, this.alias, this.projection);
        }

        public String toString() {
            return "Relationship.RelationshipBuilder(name=" + this.name + ", alias=" + this.alias + ", projection=" + this.projection + ")";
        }
    }
}

