/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.filter.visitors;

import com.yahoo.elide.annotation.ReadPermission;
import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.dictionary.RelationshipType;
import com.yahoo.elide.core.exceptions.ForbiddenAccessException;
import com.yahoo.elide.core.filter.expression.AndFilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpressionVisitor;
import com.yahoo.elide.core.filter.expression.NotFilterExpression;
import com.yahoo.elide.core.filter.expression.OrFilterExpression;
import com.yahoo.elide.core.filter.predicates.FilterPredicate;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.core.request.Relationship;
import com.yahoo.elide.core.security.PermissionExecutor;
import com.yahoo.elide.core.security.permissions.ExpressionResult;
import io.reactivex.Observable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class VerifyFieldAccessFilterExpressionVisitor
implements FilterExpressionVisitor<Boolean> {
    private PersistentResource<?> resource;

    public VerifyFieldAccessFilterExpressionVisitor(PersistentResource<?> resource) {
        this.resource = resource;
    }

    @Override
    public Boolean visitPredicate(FilterPredicate filterPredicate) {
        RequestScope requestScope = this.resource.getRequestScope();
        Set<PersistentResource<Object>> val = Collections.singleton(this.resource);
        PermissionExecutor permissionExecutor = requestScope.getPermissionExecutor();
        ExpressionResult result = permissionExecutor.evaluateFilterJoinUserChecks(this.resource, filterPredicate);
        if (result == ExpressionResult.UNEVALUATED) {
            result = this.evaluateUserChecks(filterPredicate, permissionExecutor);
        }
        if (result == ExpressionResult.PASS) {
            return true;
        }
        if (result == ExpressionResult.FAIL) {
            return false;
        }
        for (Path.PathElement element : filterPredicate.getPath().getPathElements()) {
            String fieldName = element.getFieldName();
            if ("this".equals(fieldName)) continue;
            try {
                val = val.stream().filter(Objects::nonNull).flatMap(x -> ((LinkedHashSet)this.getValueChecked((PersistentResource<?>)x, fieldName, requestScope).toList(LinkedHashSet::new).blockingGet()).stream()).filter(Objects::nonNull).collect(Collectors.toSet());
            }
            catch (ForbiddenAccessException e) {
                result = permissionExecutor.handleFilterJoinReject(filterPredicate, element, e);
                if (result == ExpressionResult.DEFERRED) continue;
                return result == ExpressionResult.PASS;
            }
        }
        return true;
    }

    private Observable<PersistentResource> getValueChecked(PersistentResource<?> resource, String fieldName, RequestScope requestScope) {
        EntityDictionary dictionary = resource.getDictionary();
        requestScope.getPermissionExecutor().checkSpecificFieldPermissions(resource, null, ReadPermission.class, fieldName);
        Object entity = resource.getObject();
        if (entity == null || resource.getDictionary().getRelationshipType(resource.getResourceType(), fieldName) == RelationshipType.NONE) {
            return Observable.empty();
        }
        Relationship relationship = Relationship.builder().name(fieldName).alias(fieldName).projection(EntityProjection.builder().type(dictionary.getParameterizedType(resource.getResourceType(), fieldName)).build()).build();
        return resource.getRelationChecked(relationship);
    }

    private ExpressionResult evaluateUserChecks(FilterPredicate filterPredicate, PermissionExecutor permissionExecutor) {
        PermissionExecutor executor = this.resource.getRequestScope().getPermissionExecutor();
        ExpressionResult ret = ExpressionResult.PASS;
        for (Path.PathElement element : filterPredicate.getPath().getPathElements()) {
            ExpressionResult result;
            try {
                result = executor.checkUserPermissions(element.getType(), ReadPermission.class, element.getFieldName());
            }
            catch (ForbiddenAccessException e) {
                result = permissionExecutor.handleFilterJoinReject(filterPredicate, element, e);
            }
            if (result == ExpressionResult.FAIL) {
                return ExpressionResult.FAIL;
            }
            if (result == ExpressionResult.PASS) continue;
            ret = ExpressionResult.DEFERRED;
        }
        return ret;
    }

    @Override
    public Boolean visitAndExpression(AndFilterExpression expression) {
        FilterExpression left = expression.getLeft();
        FilterExpression right = expression.getRight();
        return left.accept(this) != false && right.accept(this) != false;
    }

    @Override
    public Boolean visitOrExpression(OrFilterExpression expression) {
        FilterExpression left = expression.getLeft();
        FilterExpression right = expression.getRight();
        return left.accept(this) != false && right.accept(this) != false;
    }

    @Override
    public Boolean visitNotExpression(NotFilterExpression expression) {
        return expression.getNegated().accept(this);
    }
}

