/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.filter.dialect.jsonapi;

import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.filter.dialect.ParseException;
import com.yahoo.elide.core.filter.dialect.jsonapi.DefaultFilterDialect;
import com.yahoo.elide.core.filter.dialect.jsonapi.JoinFilterDialect;
import com.yahoo.elide.core.filter.dialect.jsonapi.SubqueryFilterDialect;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleFilterDialect
implements JoinFilterDialect,
SubqueryFilterDialect {
    private static final Logger log = LoggerFactory.getLogger(MultipleFilterDialect.class);
    private List<JoinFilterDialect> joinDialects;
    private List<SubqueryFilterDialect> subqueryDialects;

    public MultipleFilterDialect(EntityDictionary dictionary) {
        DefaultFilterDialect defaultDialect = new DefaultFilterDialect(dictionary);
        this.joinDialects = new ArrayList<JoinFilterDialect>();
        this.joinDialects.add(defaultDialect);
        this.subqueryDialects = new ArrayList<SubqueryFilterDialect>();
        this.subqueryDialects.add(defaultDialect);
    }

    @Override
    public FilterExpression parseGlobalExpression(String path, Map<String, List<String>> queryParams, String apiVersion) throws ParseException {
        if (this.joinDialects.isEmpty()) {
            throw new ParseException("Heterogeneous type filtering not supported");
        }
        return MultipleFilterDialect.parseExpression(this.joinDialects, dialect -> dialect.parseGlobalExpression(path, queryParams, apiVersion));
    }

    @Override
    public Map<String, FilterExpression> parseTypedExpression(String path, Map<String, List<String>> queryParams, String apiVersion) throws ParseException {
        if (this.subqueryDialects.isEmpty()) {
            throw new ParseException("Type filtering not supported");
        }
        return MultipleFilterDialect.parseExpression(this.subqueryDialects, dialect -> dialect.parseTypedExpression(path, queryParams, apiVersion));
    }

    private static <T, R> R parseExpression(List<T> dialects, ParseFunction<T, R> parseFunction) throws ParseException {
        ParseException lastFailure = null;
        for (T dialect : dialects) {
            try {
                return parseFunction.apply(dialect);
            }
            catch (ParseException e) {
                if (log.isTraceEnabled()) {
                    log.trace("Parse Failure: {}", (Object)e.getMessage());
                }
                if (lastFailure != null) {
                    ParseException prev = lastFailure;
                    lastFailure = new ParseException(e.getMessage() + "\n" + lastFailure.getMessage());
                    lastFailure.addSuppressed(prev);
                    lastFailure.addSuppressed(e);
                    continue;
                }
                lastFailure = e;
            }
        }
        if (lastFailure == null) {
            lastFailure = new ParseException("No dialects");
        }
        throw lastFailure;
    }

    public MultipleFilterDialect(List<JoinFilterDialect> joinDialects, List<SubqueryFilterDialect> subqueryDialects) {
        this.joinDialects = joinDialects;
        this.subqueryDialects = subqueryDialects;
    }

    @FunctionalInterface
    public static interface ParseFunction<T, R> {
        public R apply(T var1) throws ParseException;
    }
}

