/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.filter.dialect.jsonapi;

import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.filter.Operator;
import com.yahoo.elide.core.filter.dialect.ParseException;
import com.yahoo.elide.core.filter.dialect.jsonapi.JoinFilterDialect;
import com.yahoo.elide.core.filter.dialect.jsonapi.SubqueryFilterDialect;
import com.yahoo.elide.core.filter.expression.AndFilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.predicates.FilterPredicate;
import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.core.utils.coerce.CoerceUtil;
import com.yahoo.elide.jsonapi.parser.JsonApiParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultFilterDialect
implements JoinFilterDialect,
SubqueryFilterDialect {
    private final EntityDictionary dictionary;

    public DefaultFilterDialect(EntityDictionary dictionary) {
        this.dictionary = dictionary;
    }

    private List<FilterPredicate> extractPredicates(Map<String, List<String>> queryParams, String apiVersion) throws ParseException {
        ArrayList<FilterPredicate> filterPredicates = new ArrayList<FilterPredicate>();
        Pattern pattern = Pattern.compile("filter\\[([^\\]]+)\\](\\[([^\\]]+)\\])?");
        for (Map.Entry<String, List<String>> entry : queryParams.entrySet()) {
            String paramName = entry.getKey();
            List<String> paramValues = entry.getValue();
            Matcher matcher = pattern.matcher(paramName);
            if (!matcher.find()) {
                throw new ParseException("Invalid filter format: " + paramName);
            }
            String[] keyParts = matcher.group(1).split("\\.");
            if (keyParts.length < 2) {
                throw new ParseException("Invalid filter format: " + paramName);
            }
            Operator operator = matcher.group(3) == null ? Operator.IN : Operator.fromString(matcher.group(3));
            Path path = this.getPath(keyParts, apiVersion);
            List<Path.PathElement> elements = path.getPathElements();
            Path.PathElement last = elements.get(elements.size() - 1);
            ArrayList<Object> values = new ArrayList<Object>();
            if (operator.isParameterized()) {
                for (String valueParams : paramValues) {
                    for (String valueParam : valueParams.split(",")) {
                        values.add(CoerceUtil.coerce((Object)valueParam, last.getFieldType()));
                    }
                }
            }
            FilterPredicate filterPredicate = new FilterPredicate(path, operator, values);
            filterPredicates.add(filterPredicate);
        }
        return filterPredicates;
    }

    @Override
    public FilterExpression parseGlobalExpression(String path, Map<String, List<String>> filterParams, String apiVersion) throws ParseException {
        List<FilterPredicate> filterPredicates = this.extractPredicates(filterParams, apiVersion);
        String normalizedPath = JsonApiParser.normalizePath(path);
        String[] pathComponents = normalizedPath.split("/");
        String firstPathComponent = "";
        if (pathComponents.length > 0) {
            firstPathComponent = pathComponents[0];
        }
        FilterExpression joinedExpression = null;
        for (FilterPredicate filterPredicate : filterPredicates) {
            Type firstClass = filterPredicate.getPath().getPathElements().get(0).getType();
            if (!this.dictionary.getJsonAliasFor(firstClass).equals(firstPathComponent)) {
                throw new ParseException(String.format("Invalid predicate: %s", filterPredicate));
            }
            if ((filterPredicate.getOperator().equals((Object)Operator.HASMEMBER) || filterPredicate.getOperator().equals((Object)Operator.HASNOMEMBER)) && !FilterPredicate.isLastPathElementAssignableFrom(this.dictionary, filterPredicate.getPath(), ClassType.COLLECTION_TYPE)) {
                throw new ParseException("Invalid Path: Last Path Element has to be a collection type");
            }
            if (joinedExpression == null) {
                joinedExpression = filterPredicate;
                continue;
            }
            joinedExpression = new AndFilterExpression(joinedExpression, filterPredicate);
        }
        return joinedExpression;
    }

    @Override
    public Map<String, FilterExpression> parseTypedExpression(String path, Map<String, List<String>> filterParams, String apiVersion) throws ParseException {
        HashMap<String, FilterExpression> expressionMap = new HashMap<String, FilterExpression>();
        List<FilterPredicate> filterPredicates = this.extractPredicates(filterParams, apiVersion);
        for (FilterPredicate filterPredicate : filterPredicates) {
            this.validateFilterPredicate(filterPredicate);
            String entityType = this.dictionary.getJsonAliasFor(filterPredicate.getEntityType());
            FilterExpression filterExpression = (FilterExpression)expressionMap.get(entityType);
            if (filterExpression != null) {
                expressionMap.put(entityType, new AndFilterExpression(filterExpression, filterPredicate));
                continue;
            }
            expressionMap.put(entityType, filterPredicate);
        }
        return expressionMap;
    }

    private Path getPath(String[] keyParts, String apiVersion) throws ParseException {
        int i;
        if (keyParts == null || keyParts.length <= 0) {
            throw new ParseException("Invalid filter expression");
        }
        ArrayList<Path.PathElement> path = new ArrayList<Path.PathElement>();
        Type[] types = new Type[keyParts.length];
        String type = keyParts[0];
        types[0] = this.dictionary.getEntityClass(type, apiVersion);
        if (types[0] == null) {
            throw new ParseException("Unknown entity in filter: " + type);
        }
        for (i = 1; i < keyParts.length; ++i) {
            Type<?> fieldType;
            String field = keyParts[i];
            Type entityClass = types[i - 1];
            Type<?> type2 = fieldType = "id".equals(field.toLowerCase(Locale.ENGLISH)) ? this.dictionary.getIdType(entityClass) : this.dictionary.getParameterizedType(entityClass, field);
            if (fieldType == null) {
                throw new ParseException("Unknown field in filter: " + field);
            }
            types[i] = fieldType;
        }
        for (i = 0; i < types.length - 1; ++i) {
            Type typeClass = types[i];
            String fieldName = keyParts[i + 1];
            Type fieldClass = types[i + 1];
            Path.PathElement pathElement = new Path.PathElement(typeClass, fieldClass, fieldName);
            path.add(pathElement);
        }
        return new Path(path);
    }

    private void validateFilterPredicate(FilterPredicate filterPredicate) throws ParseException {
        switch (filterPredicate.getOperator()) {
            case ISEMPTY: 
            case NOTEMPTY: {
                this.emptyOperatorConditions(filterPredicate);
                break;
            }
            case HASMEMBER: 
            case HASNOMEMBER: {
                this.memberOfOperatorConditions(filterPredicate);
            }
        }
    }

    private void emptyOperatorConditions(FilterPredicate filterPredicate) throws ParseException {
        if (FilterPredicate.toManyInPathExceptLastPathElement(this.dictionary, filterPredicate.getPath())) {
            throw new ParseException("Invalid toMany join. toMany association has to be the target collection." + filterPredicate);
        }
    }

    private void memberOfOperatorConditions(FilterPredicate filterPredicate) throws ParseException {
        if (FilterPredicate.toManyInPath(this.dictionary, filterPredicate.getPath())) {
            if (FilterPredicate.isLastPathElementAssignableFrom(this.dictionary, filterPredicate.getPath(), ClassType.COLLECTION_TYPE)) {
                throw new ParseException("Invalid Path: Last Path Element cannot be a collection type");
            }
        } else if (!FilterPredicate.isLastPathElementAssignableFrom(this.dictionary, filterPredicate.getPath(), ClassType.COLLECTION_TYPE)) {
            throw new ParseException("Invalid Path: Last Path Element has to be a collection type");
        }
    }
}

