/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.exceptions;

import com.yahoo.elide.core.exceptions.ExceptionLogger;
import com.yahoo.elide.core.exceptions.ForbiddenAccessException;
import com.yahoo.elide.core.exceptions.HttpStatusException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jExceptionLogger
implements ExceptionLogger {
    private static final Logger log = LoggerFactory.getLogger(Slf4jExceptionLogger.class);

    @Override
    public void log(Throwable exception) {
        if (log.isDebugEnabled()) {
            if (exception instanceof ForbiddenAccessException) {
                ForbiddenAccessException forbiddenAccessException = (ForbiddenAccessException)exception;
                log.debug("Caught {} {}", (Object)exception.getClass().getSimpleName(), (Object)forbiddenAccessException.getLoggedMessage());
            } else if (exception instanceof HttpStatusException) {
                HttpStatusException httpStatusException = (HttpStatusException)exception;
                log.debug("Caught {} with status {}", new Object[]{exception.getClass().getSimpleName(), httpStatusException.getStatus(), exception});
            } else {
                log.debug("Caught {}", (Object)exception.getClass().getSimpleName(), (Object)exception);
            }
        }
    }
}

