/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.exceptions;

import com.yahoo.elide.core.exceptions.ExceptionMapper;
import java.lang.reflect.ParameterizedType;
import java.util.Objects;

public class ExceptionMapperRegistration {
    private final Class<? extends Throwable> supported;
    private final ExceptionMapper<? extends Throwable, ?> exceptionMapper;

    private ExceptionMapperRegistration(Class<? extends Throwable> supported, ExceptionMapper<? extends Throwable, ?> exceptionMapper) {
        this.supported = supported;
        this.exceptionMapper = exceptionMapper;
    }

    public boolean isSupported(Throwable e) {
        return e.getClass().isAssignableFrom(this.supported);
    }

    public static ExceptionMapperRegistrationBuilder builder() {
        return new ExceptionMapperRegistrationBuilder();
    }

    public Class<? extends Throwable> getSupported() {
        return this.supported;
    }

    public ExceptionMapper<? extends Throwable, ?> getExceptionMapper() {
        return this.exceptionMapper;
    }

    public static class ExceptionMapperRegistrationBuilder {
        protected Class<? extends Throwable> supported = null;
        protected ExceptionMapper<? extends Throwable, ?> exceptionMapper = null;

        public ExceptionMapperRegistrationBuilder supported(Class<? extends Throwable> supported) {
            this.supported = supported;
            return this;
        }

        public ExceptionMapperRegistrationBuilder exceptionMapper(ExceptionMapper<? extends Throwable, ?> exceptionMapper) {
            this.exceptionMapper = exceptionMapper;
            return this;
        }

        public ExceptionMapperRegistration build() {
            Objects.requireNonNull(this.exceptionMapper, "exceptionMapper should be set");
            if (this.supported != null) {
                return new ExceptionMapperRegistration(this.supported, this.exceptionMapper);
            }
            Class clazz = Throwable.class;
            try {
                clazz = (Class)((ParameterizedType)this.exceptionMapper.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0];
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return new ExceptionMapperRegistration(clazz, this.exceptionMapper);
        }
    }
}

