/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.exceptions;

import com.yahoo.elide.ElideErrorResponse;
import com.yahoo.elide.ElideResponse;
import com.yahoo.elide.core.exceptions.ErrorContext;
import com.yahoo.elide.core.exceptions.ExceptionHandler;
import com.yahoo.elide.core.exceptions.ExceptionLogger;
import com.yahoo.elide.core.exceptions.ExceptionMappers;
import com.yahoo.elide.core.exceptions.HttpStatusException;

public abstract class ExceptionHandlerSupport<C extends ErrorContext>
implements ExceptionHandler<C> {
    protected final ExceptionLogger exceptionLogger;
    protected final ExceptionMappers exceptionMappers;

    protected ExceptionHandlerSupport(ExceptionLogger exceptionLogger, ExceptionMappers exceptionMappers) {
        this.exceptionLogger = exceptionLogger;
        this.exceptionMappers = exceptionMappers;
    }

    @Override
    public ElideResponse<?> handleException(Throwable exception, C errorContext) {
        ElideErrorResponse<Object> errorResponse;
        this.exceptionLogger.log(exception);
        if (this.exceptionMappers != null && (errorResponse = this.exceptionMappers.toErrorResponse(exception, (ErrorContext)errorContext)) != null) {
            return this.buildResponse(errorResponse);
        }
        if (exception instanceof RuntimeException) {
            RuntimeException e = (RuntimeException)exception;
            return this.handleRuntimeException(e, errorContext);
        }
        if (exception instanceof Exception) {
            Exception e = (Exception)exception;
            return this.handleNonRuntimeException(e, errorContext);
        }
        return this.handleThrowable(exception, (ErrorContext)errorContext);
    }

    protected abstract ElideResponse<?> buildResponse(ElideErrorResponse<?> var1);

    protected ElideResponse<?> buildResponse(HttpStatusException exception, C errorContext) {
        ElideErrorResponse<? extends Object> errorResponse = errorContext.isVerbose() ? exception.getVerboseErrorResponse() : exception.getErrorResponse();
        return this.buildResponse(errorResponse);
    }

    protected abstract ElideResponse<?> buildResponse(int var1, Object var2);

    protected abstract ElideResponse<?> handleRuntimeException(RuntimeException var1, C var2);

    protected abstract ElideResponse<?> handleNonRuntimeException(Exception var1, C var2);

    protected ElideResponse<?> handleThrowable(Throwable exception, ErrorContext errorContext) {
        return ElideResponse.status(500).build();
    }
}

