/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.exceptions;

import com.yahoo.elide.ElideErrorResponse;
import com.yahoo.elide.ElideErrors;
import com.yahoo.elide.core.exceptions.HttpStatusException;
import java.util.Objects;

public class ErrorResponseException
extends HttpStatusException {
    private static final long serialVersionUID = 1L;
    private final ElideErrors errors;

    public ErrorResponseException(int status, String message, ElideErrors errors) {
        this(status, message, null, errors);
    }

    public ErrorResponseException(int status, String message, Throwable cause, ElideErrors errors) {
        super(status, message, cause, null);
        this.errors = Objects.requireNonNull(errors, "errors must not be null");
    }

    @Override
    public ElideErrorResponse<? extends Object> getErrorResponse() {
        return this.buildResponse(this.errors);
    }

    @Override
    public ElideErrorResponse<? extends Object> getVerboseErrorResponse() {
        return this.buildResponse(this.errors);
    }

    protected ElideErrorResponse<?> buildResponse(Object body) {
        return ElideErrorResponse.status(this.getStatus()).body(body);
    }
}

