/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.datastore.inmemory;

import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.datastore.DataStoreIterable;
import com.yahoo.elide.core.datastore.DataStoreIterableBuilder;
import com.yahoo.elide.core.datastore.DataStoreTransaction;
import com.yahoo.elide.core.datastore.inmemory.Operation;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.exceptions.TransactionException;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.core.request.Relationship;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.core.utils.ObjectCloner;
import com.yahoo.elide.core.utils.coerce.converters.Serde;
import jakarta.persistence.GeneratedValue;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class HashMapStoreTransaction
implements DataStoreTransaction {
    private final Map<Type<?>, Map<String, Object>> dataStore;
    private final List<Operation> operations;
    private final EntityDictionary dictionary;
    private final Map<Type<?>, AtomicLong> typeIds;
    private final Lock lock;
    private final boolean readOnly;
    private final ObjectCloner objectCloner;
    private boolean committed = false;
    private Map<Type<?>, Map<String, Object>> rollbackCache = new HashMap();

    public HashMapStoreTransaction(ReadWriteLock readWriteLock, Map<Type<?>, Map<String, Object>> dataStore, EntityDictionary dictionary, Map<Type<?>, AtomicLong> typeIds, ObjectCloner objectCloner, boolean readOnly) {
        this.readOnly = readOnly;
        this.dataStore = dataStore;
        this.dictionary = dictionary;
        this.operations = new ArrayList<Operation>();
        this.typeIds = typeIds;
        this.objectCloner = objectCloner;
        if (readWriteLock != null) {
            this.lock = readOnly ? readWriteLock.readLock() : readWriteLock.writeLock();
            this.lock.lock();
        } else {
            this.lock = null;
        }
    }

    @Override
    public void flush(RequestScope requestScope) {
    }

    public void save(Object object, RequestScope requestScope) {
        if (object == null) {
            return;
        }
        String id = this.dictionary.getId(object);
        if (id == null || "null".equals(id) || "0".equals(id)) {
            this.createObject(object, requestScope);
        }
        id = this.dictionary.getId(object);
        this.operations.add(new Operation(id, object, EntityDictionary.getType(object), Operation.OpType.UPDATE));
        this.replicateOperationToParent(object, Operation.OpType.UPDATE);
    }

    public void delete(Object object, RequestScope requestScope) {
        if (object == null) {
            return;
        }
        String id = this.dictionary.getId(object);
        this.operations.add(new Operation(id, object, EntityDictionary.getType(object), Operation.OpType.DELETE));
        this.replicateOperationToParent(object, Operation.OpType.DELETE);
    }

    @Override
    public void commit(RequestScope scope) {
        this.operations.stream().filter(op -> op.getInstance() != null).forEach(op -> {
            Object instance = op.getInstance();
            String id = op.getId();
            Map<String, Object> data = this.dataStore.get(op.getType());
            if (op.getOpType() == Operation.OpType.DELETE) {
                data.remove(id);
            } else {
                if (op.getOpType() == Operation.OpType.CREATE && data.get(id) != null) {
                    throw new TransactionException(new IllegalStateException("Duplicate key"));
                }
                data.put(id, instance);
            }
        });
        this.operations.clear();
        this.committed = true;
    }

    public void createObject(Object entity, RequestScope scope) {
        String id;
        Type<Object> entityClass = EntityDictionary.getType(entity);
        String idFieldName = this.dictionary.getIdFieldName(entityClass);
        if (this.containsObject(entity)) {
            throw new TransactionException(new IllegalStateException("Duplicate key"));
        }
        if (this.dictionary.getAttributeOrRelationAnnotation(entityClass, GeneratedValue.class, idFieldName) != null) {
            AtomicLong nextId = this.getId(entityClass);
            id = String.valueOf(nextId.getAndIncrement());
            this.setId(entity, id);
        } else {
            id = this.dictionary.getId(entity);
        }
        this.replicateOperationToParent(entity, Operation.OpType.CREATE);
        this.operations.add(new Operation(id, entity, EntityDictionary.getType(entity), Operation.OpType.CREATE));
    }

    public void setId(Object value, String id) {
        this.dictionary.setValue(value, this.dictionary.getIdFieldName(EntityDictionary.getType(value)), id);
    }

    public DataStoreIterable<Object> getToManyRelation(DataStoreTransaction relationTx, Object entity, Relationship relationship, RequestScope scope) {
        return new DataStoreIterableBuilder((Iterable)this.dictionary.getValue(entity, relationship.getName(), scope)).allInMemory().build();
    }

    public DataStoreIterable<Object> loadObjects(EntityProjection projection, RequestScope scope) {
        Map<String, Object> data = this.dataStore.get(projection.getType());
        this.cacheForRollback(projection.getType(), data);
        return new DataStoreIterableBuilder<Object>(data.values()).allInMemory().build();
    }

    public Object loadObject(EntityProjection projection, Serializable id, RequestScope scope) {
        EntityDictionary dictionary = scope.getDictionary();
        Map<String, Object> data = this.dataStore.get(projection.getType());
        this.cacheForRollback(projection.getType(), data);
        if (data == null) {
            return null;
        }
        Serde serde = dictionary.getSerdeLookup().apply(id.getClass());
        String idString = serde == null ? id.toString() : (String)serde.serialize(id);
        return data.get(idString);
    }

    protected void cacheForRollback(Type<?> type, Map<String, Object> data) {
        if (!this.readOnly) {
            this.rollbackCache.computeIfAbsent(type, key -> {
                if (data != null) {
                    HashMap copy = new HashMap();
                    data.entrySet().stream().forEach(entry -> {
                        Object value = this.objectCloner.clone(entry.getValue(), type);
                        copy.put((String)entry.getKey(), value);
                    });
                    return copy;
                }
                return null;
            });
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (!this.committed && !this.readOnly) {
                this.rollback();
            }
            this.operations.clear();
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    public void rollback() {
        this.dataStore.putAll(this.rollbackCache);
        this.rollbackCache.clear();
    }

    private boolean containsObject(Object obj) {
        return this.containsObject(EntityDictionary.getType(obj), obj);
    }

    private boolean containsObject(Type<?> clazz, Object obj) {
        return this.dataStore.get(clazz).containsValue(obj);
    }

    @Override
    public void cancel(RequestScope scope) {
    }

    private void replicateOperationToParent(Object entity, Operation.OpType opType) {
        this.dictionary.getSuperClassEntities(EntityDictionary.getType(entity)).stream().forEach(superClass -> {
            if (opType.equals((Object)Operation.OpType.CREATE) && this.containsObject((Type<?>)superClass, entity)) {
                throw new TransactionException(new IllegalStateException("Duplicate key in Parent"));
            }
            String id = this.dictionary.getId(entity);
            this.operations.add(new Operation(id, entity, (Type<?>)superClass, opType));
        });
    }

    private AtomicLong getId(Type<?> entityClass) {
        return this.dictionary.getSuperClassEntities(entityClass).stream().findFirst().map(this::getId).orElseGet(() -> this.typeIds.computeIfAbsent(entityClass, key -> {
            long maxId = this.dataStore.get(key).keySet().stream().mapToLong(Long::parseLong).max().orElse(0L);
            return new AtomicLong(maxId + 1L);
        }));
    }
}

