/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core;

import com.yahoo.elide.ElideSettings;
import com.yahoo.elide.annotation.LifeCycleHookBinding;
import com.yahoo.elide.core.ObjectEntityCache;
import com.yahoo.elide.core.audit.AuditLogger;
import com.yahoo.elide.core.datastore.DataStoreTransaction;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.exceptions.InvalidAttributeException;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.lifecycle.CRUDEvent;
import com.yahoo.elide.core.lifecycle.LifecycleHookInvoker;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.core.request.route.Route;
import com.yahoo.elide.core.security.ChangeSpec;
import com.yahoo.elide.core.security.PermissionExecutor;
import com.yahoo.elide.core.security.PersistentResource;
import com.yahoo.elide.core.security.User;
import com.yahoo.elide.core.security.executors.ActivePermissionExecutor;
import com.yahoo.elide.core.security.executors.MultiplexPermissionExecutor;
import com.yahoo.elide.core.type.Type;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;

public class RequestScope
implements com.yahoo.elide.core.security.RequestScope {
    protected Route route;
    private final DataStoreTransaction transaction;
    private final User user;
    protected final EntityDictionary dictionary;
    private final AuditLogger auditLogger;
    private final PermissionExecutor permissionExecutor;
    private final ObjectEntityCache objectEntityCache;
    private final Set<com.yahoo.elide.core.PersistentResource> newPersistentResources;
    private final LinkedHashSet<com.yahoo.elide.core.PersistentResource> dirtyResources;
    private final LinkedHashSet<com.yahoo.elide.core.PersistentResource> deletedResources;
    private final ElideSettings elideSettings;
    private final Map<String, Set<String>> sparseFields;
    private EntityProjection entityProjection;
    protected Function<RequestScope, EntityProjection> entityProjectionResolver;
    private final UUID requestId;
    protected Map<String, FilterExpression> expressionsByType;
    private final Map<String, Object> metadata;
    private LinkedHashSet<CRUDEvent> eventQueue;
    protected FilterExpression globalFilterExpression;

    public RequestScope(Route route, DataStoreTransaction transaction, User user, UUID requestId, ElideSettings elideSettings, Function<RequestScope, EntityProjection> entityProjection) {
        this.route = route;
        this.eventQueue = new LinkedHashSet();
        this.transaction = transaction;
        this.user = user;
        this.dictionary = elideSettings.getEntityDictionary();
        this.auditLogger = elideSettings.getAuditLogger();
        this.elideSettings = elideSettings;
        this.globalFilterExpression = null;
        this.expressionsByType = new LinkedHashMap<String, FilterExpression>();
        this.objectEntityCache = new ObjectEntityCache();
        this.newPersistentResources = new LinkedHashSet<com.yahoo.elide.core.PersistentResource>();
        this.dirtyResources = new LinkedHashSet();
        this.deletedResources = new LinkedHashSet();
        this.requestId = requestId;
        this.metadata = new LinkedHashMap<String, Object>();
        this.sparseFields = RequestScope.parseSparseFields(this.getRoute().getParameters());
        this.entityProjectionResolver = entityProjection;
        if (this.entityProjectionResolver != null) {
            this.entityProjection = this.entityProjectionResolver.apply(this);
        }
        Function<RequestScope, PermissionExecutor> permissionExecutorGenerator = elideSettings.getPermissionExecutor();
        this.permissionExecutor = new MultiplexPermissionExecutor(this.dictionary.buildPermissionExecutors(this), permissionExecutorGenerator == null ? new ActivePermissionExecutor(this) : permissionExecutorGenerator.apply(this), this.dictionary);
    }

    public RequestScope(RequestScope copy) {
        this.route = copy.route;
        this.transaction = copy.transaction;
        this.user = copy.user;
        this.dictionary = copy.dictionary;
        this.auditLogger = copy.auditLogger;
        this.objectEntityCache = copy.objectEntityCache;
        this.newPersistentResources = copy.newPersistentResources;
        this.dirtyResources = copy.dirtyResources;
        this.deletedResources = copy.deletedResources;
        this.elideSettings = copy.elideSettings;
        this.sparseFields = copy.sparseFields;
        this.requestId = copy.requestId;
        this.expressionsByType = copy.expressionsByType;
        this.metadata = copy.metadata;
        this.eventQueue = copy.eventQueue;
        this.globalFilterExpression = copy.globalFilterExpression;
        this.permissionExecutor = copy.permissionExecutor;
        this.entityProjectionResolver = copy.entityProjectionResolver;
        if (this.entityProjectionResolver != null) {
            this.entityProjection = this.entityProjectionResolver.apply(this);
        }
    }

    public Set<PersistentResource> getNewResources() {
        return this.newPersistentResources;
    }

    public boolean isNewResource(Object entity) {
        return this.newPersistentResources.stream().anyMatch(r -> r.getObject() == entity);
    }

    public static Map<String, Set<String>> parseSparseFields(Map<String, List<String>> queryParams) {
        LinkedHashMap<String, Set<String>> result = new LinkedHashMap<String, Set<String>>();
        for (Map.Entry<String, List<String>> kv : queryParams.entrySet()) {
            String key = kv.getKey();
            if (!key.startsWith("fields[") || !key.endsWith("]")) continue;
            String type = key.substring(7, key.length() - 1);
            LinkedHashSet filters = new LinkedHashSet();
            for (String filterParams : kv.getValue()) {
                Collections.addAll(filters, filterParams.split(","));
            }
            if (filters.isEmpty()) continue;
            result.put(type, filters);
        }
        return result;
    }

    public Optional<FilterExpression> getFilterExpressionByType(String type) {
        return Optional.ofNullable(this.expressionsByType.get(type));
    }

    public Optional<FilterExpression> getFilterExpressionByType(Type<?> entityClass) {
        return Optional.ofNullable(this.expressionsByType.get(this.dictionary.getJsonAliasFor(entityClass)));
    }

    public Optional<FilterExpression> getLoadFilterExpression(Type<?> loadClass) {
        Optional<FilterExpression> filterExpression;
        if (this.globalFilterExpression == null) {
            String typeName = this.dictionary.getJsonAliasFor(loadClass);
            filterExpression = this.getFilterExpressionByType(typeName);
        } else {
            filterExpression = Optional.of(this.globalFilterExpression);
        }
        return filterExpression;
    }

    public Optional<FilterExpression> getExpressionForRelation(Type<?> parentType, String relationName) {
        Type<?> entityClass = this.dictionary.getParameterizedType(parentType, relationName);
        if (entityClass == null) {
            throw new InvalidAttributeException(relationName, this.dictionary.getJsonAliasFor(parentType));
        }
        String valType = this.dictionary.getJsonAliasFor(entityClass);
        return this.getFilterExpressionByType(valType);
    }

    private static Map<String, List<String>> getFilterParams(Map<String, List<String>> queryParams) {
        LinkedHashMap<String, List<String>> returnMap = new LinkedHashMap<String, List<String>>();
        queryParams.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("filter")).forEach(entry -> returnMap.put((String)entry.getKey(), (List)entry.getValue()));
        return returnMap;
    }

    private void notifySubscribers(LifeCycleHookBinding.Operation operation, LifeCycleHookBinding.TransactionPhase phase) {
        LifecycleHookInvoker invoker = new LifecycleHookInvoker(this.dictionary, operation, phase);
        this.eventQueue.stream().filter(event -> event.getEventType().equals((Object)operation)).forEach(event -> invoker.onNext((CRUDEvent)event));
    }

    public void runQueuedPreSecurityTriggers() {
        this.notifySubscribers(LifeCycleHookBinding.Operation.CREATE, LifeCycleHookBinding.TransactionPhase.PRESECURITY);
    }

    public void runQueuedPreFlushTriggers() {
        this.runQueuedPreFlushTriggers(LifeCycleHookBinding.ALL_OPERATIONS);
    }

    public void runQueuedPreFlushTriggers(LifeCycleHookBinding.Operation[] operations) {
        for (LifeCycleHookBinding.Operation op : operations) {
            this.notifySubscribers(op, LifeCycleHookBinding.TransactionPhase.PREFLUSH);
        }
    }

    public void runQueuedPreCommitTriggers() {
        for (LifeCycleHookBinding.Operation op : LifeCycleHookBinding.ALL_OPERATIONS) {
            this.notifySubscribers(op, LifeCycleHookBinding.TransactionPhase.PRECOMMIT);
        }
    }

    public void runQueuedPostCommitTriggers() {
        for (LifeCycleHookBinding.Operation op : LifeCycleHookBinding.ALL_OPERATIONS) {
            this.notifySubscribers(op, LifeCycleHookBinding.TransactionPhase.POSTCOMMIT);
        }
    }

    protected void publishLifecycleEvent(com.yahoo.elide.core.PersistentResource<?> resource, LifeCycleHookBinding.Operation crudAction) {
        this.publishLifecycleEvent(new CRUDEvent(crudAction, resource, "", Optional.empty()));
    }

    protected void publishLifecycleEvent(com.yahoo.elide.core.PersistentResource<?> resource, String fieldName, LifeCycleHookBinding.Operation crudAction, Optional<ChangeSpec> changeSpec) {
        this.publishLifecycleEvent(new CRUDEvent(crudAction, resource, fieldName, changeSpec));
    }

    protected void publishLifecycleEvent(CRUDEvent event) {
        if (!this.eventQueue.contains(event)) {
            if (event.getEventType().equals((Object)LifeCycleHookBinding.Operation.DELETE) || event.getEventType().equals((Object)LifeCycleHookBinding.Operation.UPDATE)) {
                LifecycleHookInvoker invoker = new LifecycleHookInvoker(this.dictionary, event.getEventType(), LifeCycleHookBinding.TransactionPhase.PRESECURITY);
                invoker.onNext(event);
            }
            this.eventQueue.add(event);
        }
    }

    public void saveOrCreateObjects() {
        this.dirtyResources.removeAll(this.newPersistentResources);
        this.dirtyResources.removeAll(this.deletedResources);
        this.newPersistentResources.stream().map(com.yahoo.elide.core.PersistentResource::getObject).forEach(s -> this.transaction.createObject(s, this));
        this.dirtyResources.stream().map(com.yahoo.elide.core.PersistentResource::getObject).forEach(obj -> this.transaction.save(obj, this));
    }

    public String getUUIDFor(Object o) {
        return this.objectEntityCache.getUUID(o);
    }

    public Object getObjectById(Type<?> type, String id) {
        Type<?> boundType = this.dictionary.lookupBoundClass(type);
        Object result = this.objectEntityCache.get(boundType.getName(), id);
        Iterator<Type<?>> it = this.dictionary.getSubclassingEntities(boundType).iterator();
        while (result == null && it.hasNext()) {
            String newType = this.getInheritanceKey(it.next().getName(), boundType.getName());
            result = this.objectEntityCache.get(newType, id);
        }
        return result;
    }

    public void setUUIDForObject(Type<?> type, String id, Object object) {
        Type<?> boundType = this.dictionary.lookupBoundClass(type);
        this.objectEntityCache.put(boundType.getName(), id, object);
        this.dictionary.getSuperClassEntities(type).stream().map(i -> this.getInheritanceKey(boundType.getName(), i.getName())).forEach(newType -> this.objectEntityCache.put((String)newType, id, object));
    }

    private String getInheritanceKey(String subClass, String superClass) {
        return subClass + "!" + superClass;
    }

    @Override
    public void setMetadataField(String property, Object value) {
        this.metadata.put(property, value);
    }

    @Override
    public Optional<Object> getMetadataField(String property) {
        return Optional.ofNullable(this.metadata.getOrDefault(property, null));
    }

    @Override
    public Set<String> getMetadataFields() {
        return this.metadata.keySet();
    }

    @Override
    public Route getRoute() {
        return this.route;
    }

    @Override
    public ElideSettings getElideSettings() {
        return this.elideSettings;
    }

    public static RequestScopeBuilder builder() {
        return new RequestScopeBuilder();
    }

    @Override
    public DataStoreTransaction getTransaction() {
        return this.transaction;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    public EntityDictionary getDictionary() {
        return this.dictionary;
    }

    public AuditLogger getAuditLogger() {
        return this.auditLogger;
    }

    public PermissionExecutor getPermissionExecutor() {
        return this.permissionExecutor;
    }

    public ObjectEntityCache getObjectEntityCache() {
        return this.objectEntityCache;
    }

    public Set<com.yahoo.elide.core.PersistentResource> getNewPersistentResources() {
        return this.newPersistentResources;
    }

    public LinkedHashSet<com.yahoo.elide.core.PersistentResource> getDirtyResources() {
        return this.dirtyResources;
    }

    public LinkedHashSet<com.yahoo.elide.core.PersistentResource> getDeletedResources() {
        return this.deletedResources;
    }

    public Map<String, Set<String>> getSparseFields() {
        return this.sparseFields;
    }

    public EntityProjection getEntityProjection() {
        return this.entityProjection;
    }

    public void setEntityProjection(EntityProjection entityProjection) {
        this.entityProjection = entityProjection;
    }

    public UUID getRequestId() {
        return this.requestId;
    }

    public static class RequestScopeBuilder {
        protected Route route;
        protected DataStoreTransaction dataStoreTransaction;
        protected User user;
        protected UUID requestId;
        protected ElideSettings elideSettings;
        protected Function<RequestScope, EntityProjection> entityProjection;

        protected void applyDefaults() {
            if (this.requestId == null) {
                this.requestId = UUID.randomUUID();
            }
        }

        public RequestScope build() {
            this.applyDefaults();
            return new RequestScope(this.route, this.dataStoreTransaction, this.user, this.requestId, this.elideSettings, this.entityProjection);
        }

        public RequestScopeBuilder route(Route route) {
            this.route = route;
            return this;
        }

        public RequestScopeBuilder dataStoreTransaction(DataStoreTransaction transaction) {
            this.dataStoreTransaction = transaction;
            return this;
        }

        public RequestScopeBuilder user(User user) {
            this.user = user;
            return this;
        }

        public RequestScopeBuilder requestId(UUID requestId) {
            this.requestId = requestId;
            return this;
        }

        public RequestScopeBuilder elideSettings(ElideSettings elideSettings) {
            this.elideSettings = elideSettings;
            return this;
        }

        public RequestScopeBuilder entityProjection(Function<RequestScope, EntityProjection> entityProjection) {
            this.entityProjection = entityProjection;
            return this;
        }

        public RequestScopeBuilder entityProjection(EntityProjection entityProjection) {
            this.entityProjection = requestScope -> entityProjection;
            return this;
        }
    }
}

