/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.Sets;
import com.yahoo.elide.annotation.Audit;
import com.yahoo.elide.annotation.CreatePermission;
import com.yahoo.elide.annotation.DeletePermission;
import com.yahoo.elide.annotation.LifeCycleHookBinding;
import com.yahoo.elide.annotation.NonTransferable;
import com.yahoo.elide.annotation.ReadPermission;
import com.yahoo.elide.annotation.UpdatePermission;
import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.PersistentResourceSet;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.ResourceLineage;
import com.yahoo.elide.core.audit.InvalidSyntaxException;
import com.yahoo.elide.core.audit.LogMessageImpl;
import com.yahoo.elide.core.datastore.DataStoreIterable;
import com.yahoo.elide.core.datastore.DataStoreTransaction;
import com.yahoo.elide.core.dictionary.EntityBinding;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.dictionary.RelationshipType;
import com.yahoo.elide.core.exceptions.BadRequestException;
import com.yahoo.elide.core.exceptions.ForbiddenAccessException;
import com.yahoo.elide.core.exceptions.InternalServerErrorException;
import com.yahoo.elide.core.exceptions.InvalidAttributeException;
import com.yahoo.elide.core.exceptions.InvalidEntityBodyException;
import com.yahoo.elide.core.exceptions.InvalidObjectIdentifierException;
import com.yahoo.elide.core.filter.expression.AndFilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.predicates.InPredicate;
import com.yahoo.elide.core.filter.visitors.VerifyFieldAccessFilterExpressionVisitor;
import com.yahoo.elide.core.request.Argument;
import com.yahoo.elide.core.request.Attribute;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.core.request.Pagination;
import com.yahoo.elide.core.request.Relationship;
import com.yahoo.elide.core.request.Sorting;
import com.yahoo.elide.core.security.ChangeSpec;
import com.yahoo.elide.core.security.permissions.ExpressionResult;
import com.yahoo.elide.core.security.visitors.CanPaginateVisitor;
import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.core.utils.coerce.CoerceUtil;
import com.yahoo.elide.jsonapi.JsonApiSettings;
import com.yahoo.elide.jsonapi.document.processors.WithMetadata;
import com.yahoo.elide.jsonapi.models.Data;
import com.yahoo.elide.jsonapi.models.Meta;
import com.yahoo.elide.jsonapi.models.Resource;
import com.yahoo.elide.jsonapi.models.ResourceIdentifier;
import io.reactivex.Observable;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.lang3.StringUtils;

public class PersistentResource<T>
implements com.yahoo.elide.core.security.PersistentResource<T> {
    public static final Set<String> ALL_FIELDS = null;
    public static final String CLASS_NO_FIELD = "";
    protected final EntityDictionary dictionary;
    private final Type type;
    private final String typeName;
    private final ResourceLineage lineage;
    private final Optional<String> uuid;
    private final DataStoreTransaction transaction;
    private final RequestScope requestScope;
    private final Comparator<String> lengthFirstComparator = (string1, string2) -> {
        int diff = string1.length() - string2.length();
        return diff == 0 ? string1.compareTo((String)string2) : diff;
    };
    protected T obj;
    private int hashCode = 0;

    public PersistentResource(@NonNull T obj, PersistentResource parent, String parentRelationship, String id, @NonNull RequestScope scope) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        if (scope == null) {
            throw new NullPointerException("scope is marked non-null but is null");
        }
        this.obj = obj;
        this.type = EntityDictionary.getType(obj);
        this.uuid = Optional.ofNullable(id);
        this.lineage = parent != null ? new ResourceLineage(parent.lineage, parent, parentRelationship) : new ResourceLineage();
        this.dictionary = scope.getDictionary();
        this.typeName = this.dictionary.getJsonAliasFor(this.type);
        this.transaction = scope.getTransaction();
        this.requestScope = scope;
        this.dictionary.initializeEntity(obj);
    }

    public PersistentResource(@NonNull T obj, String id, @NonNull RequestScope scope) {
        this(obj, null, null, id, scope);
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        if (scope == null) {
            throw new NullPointerException("scope is marked non-null but is null");
        }
    }

    public static <T> PersistentResource<T> createObject(Type<T> entityClass, RequestScope requestScope, Optional<String> uuid) {
        return PersistentResource.createObject(null, null, entityClass, requestScope, uuid);
    }

    public static <T> PersistentResource<T> createObject(PersistentResource<?> parent, String parentRelationship, Type<T> entityClass, RequestScope requestScope, Optional<String> uuid) {
        T obj = requestScope.getTransaction().createNewObject(entityClass, requestScope);
        String id = uuid.orElse(null);
        PersistentResource newResource = new PersistentResource(obj, parent, parentRelationship, id, requestScope);
        PersistentResource.assignId(newResource, id);
        requestScope.getNewPersistentResources().add(newResource);
        PersistentResource.checkPermission(CreatePermission.class, newResource);
        newResource.auditClass(Audit.Action.CREATE, new ChangeSpec(newResource, null, null, newResource.getObject()));
        requestScope.publishLifecycleEvent(newResource, LifeCycleHookBinding.Operation.CREATE);
        requestScope.setUUIDForObject(newResource.type, id, newResource.getObject());
        requestScope.getDictionary().getRelationships(entityClass).stream().filter(relationName -> newResource.getRelationshipType((String)relationName).isToMany() && newResource.getValueUnchecked((String)relationName) == null).forEach(relationName -> newResource.setValue((String)relationName, new LinkedHashSet()));
        newResource.markDirty();
        return newResource;
    }

    @NonNull
    public static <T> PersistentResource<T> loadRecord(EntityProjection projection, String id, RequestScope requestScope) throws InvalidObjectIdentifierException {
        Preconditions.checkNotNull((Object)projection);
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkNotNull((Object)requestScope);
        DataStoreTransaction tx = requestScope.getTransaction();
        EntityDictionary dictionary = requestScope.getDictionary();
        Type<?> loadClass = projection.getType();
        Object obj = requestScope.getObjectById(loadClass, id);
        if (obj == null) {
            Optional<FilterExpression> permissionFilter = PersistentResource.getPermissionFilterExpression(loadClass, requestScope, projection.getRequestedFields());
            Type<?> idType = dictionary.getIdType(loadClass);
            obj = tx.loadObject(projection = projection.copyOf().filterExpression(permissionFilter.orElse(null)).build(), (Serializable)CoerceUtil.coerce((Object)id, idType), requestScope);
            if (obj == null) {
                throw new InvalidObjectIdentifierException(id, dictionary.getJsonAliasFor(loadClass));
            }
        }
        PersistentResource<Object> resource = new PersistentResource<Object>(obj, requestScope.getUUIDFor(obj), requestScope);
        if (!requestScope.getNewResources().contains(resource)) {
            resource.checkFieldAwarePermissions(ReadPermission.class, projection.getRequestedFields());
        }
        return resource;
    }

    private static <T> Optional<FilterExpression> getPermissionFilterExpression(Type<T> loadClass, RequestScope requestScope, Set<String> requestedFields) {
        try {
            return requestScope.getPermissionExecutor().getReadPermissionFilter(loadClass, requestedFields);
        }
        catch (ForbiddenAccessException e) {
            return Optional.empty();
        }
    }

    public static Observable<PersistentResource> loadRecords(EntityProjection projection, List<String> ids, RequestScope requestScope) {
        Optional<FilterExpression> permissionFilter;
        Type<?> loadClass = projection.getType();
        Pagination pagination = projection.getPagination();
        Sorting sorting = projection.getSorting();
        FilterExpression filterExpression = projection.getFilterExpression();
        EntityDictionary dictionary = requestScope.getDictionary();
        DataStoreTransaction tx = requestScope.getTransaction();
        if (PersistentResource.shouldSkipCollection(loadClass, ReadPermission.class, requestScope, projection.getRequestedFields())) {
            if (ids.isEmpty()) {
                return Observable.empty();
            }
            throw new InvalidObjectIdentifierException(ids.toString(), dictionary.getJsonAliasFor(loadClass));
        }
        Set<String> requestedFields = projection.getRequestedFields();
        if (pagination != null && !pagination.isDefaultInstance() && !CanPaginateVisitor.canPaginate(loadClass, dictionary, requestScope, requestedFields)) {
            throw new BadRequestException(String.format("Cannot paginate %s", dictionary.getJsonAliasFor(loadClass)));
        }
        Set newResources = new LinkedHashSet();
        if (!ids.isEmpty()) {
            String typeAlias = dictionary.getJsonAliasFor(loadClass);
            newResources = requestScope.getNewPersistentResources().stream().filter(resource -> typeAlias.equals(resource.getTypeName()) && ids.contains(resource.getUUID().orElse(CLASS_NO_FIELD))).collect(Collectors.toCollection(LinkedHashSet::new));
            FilterExpression idExpression = PersistentResource.buildIdFilterExpression(ids, loadClass, dictionary, requestScope);
            filterExpression = Optional.ofNullable(filterExpression).map(fe -> new AndFilterExpression(idExpression, (FilterExpression)fe)).orElse(idExpression);
        }
        if ((permissionFilter = PersistentResource.getPermissionFilterExpression(loadClass, requestScope, requestedFields)).isPresent()) {
            filterExpression = filterExpression != null ? new AndFilterExpression(filterExpression, permissionFilter.get()) : permissionFilter.get();
        }
        EntityProjection modifiedProjection = projection.copyOf().filterExpression(filterExpression).sorting(sorting).pagination(pagination).build();
        Observable<PersistentResource> existingResources = PersistentResource.filter(ReadPermission.class, Optional.ofNullable(modifiedProjection.getFilterExpression()), projection.getRequestedFields(), (Observable<PersistentResource>)Observable.fromIterable(new PersistentResourceSet(tx.loadObjects(modifiedProjection, requestScope), requestScope)));
        Observable allResources = Observable.fromIterable(newResources).mergeWith(existingResources);
        LinkedHashSet foundIds = new LinkedHashSet();
        allResources = allResources.doOnNext(resource -> {
            String id = (String)resource.getUUID().orElseGet(resource::getId);
            if (ids.contains(id)) {
                foundIds.add(id);
            }
        });
        allResources = allResources.doOnComplete(() -> {
            Sets.SetView missedIds = Sets.difference(new LinkedHashSet(ids), (Set)foundIds);
            if (!missedIds.isEmpty()) {
                throw new InvalidObjectIdentifierException(missedIds.toString(), dictionary.getJsonAliasFor(loadClass));
            }
        });
        return allResources;
    }

    private static FilterExpression buildIdFilterExpression(List<String> ids, Type<?> entityType, EntityDictionary dictionary, RequestScope scope) {
        Type<?> idType = dictionary.getIdType(entityType);
        String idField = dictionary.getIdFieldName(entityType);
        List<Object> coercedIds = ids.stream().filter(id -> scope.getObjectById(entityType, (String)id) == null).map(id -> CoerceUtil.coerce(id, idType)).collect(Collectors.toList());
        InPredicate idFilter = new InPredicate(new Path.PathElement(entityType, idType, idField), coercedIds);
        return idFilter;
    }

    private static boolean shouldSkipCollection(Type<?> resourceClass, Class<? extends Annotation> annotationClass, RequestScope requestScope, Set<String> requestedFields) {
        try {
            requestScope.getPermissionExecutor().checkUserPermissions(resourceClass, annotationClass, requestedFields);
            return false;
        }
        catch (ForbiddenAccessException e) {
            return true;
        }
    }

    public static Object getValue(Object target, String fieldName, RequestScope requestScope) {
        return requestScope.getDictionary().getValue(target, fieldName, requestScope);
    }

    protected static Observable<PersistentResource> filter(Class<? extends Annotation> permission, Optional<FilterExpression> filter, Set<String> requestedFields, Observable<PersistentResource> resources) {
        return resources.filter(resource -> {
            try {
                if (!resource.getRequestScope().getNewResources().contains(resource)) {
                    resource.checkFieldAwarePermissions(permission, requestedFields);
                    return !filter.isPresent() || ((FilterExpression)filter.get()).accept(new VerifyFieldAccessFilterExpressionVisitor((PersistentResource<?>)resource)) != false;
                }
                return true;
            }
            catch (ForbiddenAccessException e) {
                return false;
            }
        });
    }

    private static <A extends Annotation> ExpressionResult checkPermission(Class<A> annotationClass, PersistentResource resource) {
        return resource.requestScope.getPermissionExecutor().checkPermission(annotationClass, resource);
    }

    private static <A extends Annotation> ExpressionResult checkUserPermission(Class<A> annotationClass, Object obj, RequestScope requestScope, Set<String> requestedFields) {
        return requestScope.getPermissionExecutor().checkUserPermissions(EntityDictionary.getType(obj), annotationClass, requestedFields);
    }

    private static void assignId(PersistentResource persistentResource, String id) {
        if (!persistentResource.isIdGenerated()) {
            if (StringUtils.isNotEmpty((CharSequence)id)) {
                persistentResource.setId(id);
            } else {
                throw new BadRequestException("No id provided, cannot persist " + persistentResource.getTypeName());
            }
        }
    }

    private static <T> T firstOrNullIfEmpty(Collection<T> coll) {
        return (T)(CollectionUtils.isEmpty(coll) ? null : IterableUtils.first(coll));
    }

    public static <T> T firstOrNullIfEmpty(Observable<T> coll) {
        return PersistentResource.firstOrNullIfEmpty((Collection)coll.toList().blockingGet());
    }

    public String toString() {
        return String.format("PersistentResource{type=%s, id=%s}", this.typeName, this.uuid.orElseGet(this::getId));
    }

    @Override
    public boolean matchesId(String checkId) {
        if (checkId == null) {
            return false;
        }
        return this.uuid.map(checkId::equals).orElseGet(() -> {
            String id = this.getId();
            return !"0".equals(id) && !"null".equals(id) && checkId.equals(id);
        });
    }

    public boolean updateAttribute(String fieldName, Object newVal) {
        Type<?> fieldClass = this.dictionary.getType(this.getResourceType(), fieldName);
        Object coercedNewValue = this.dictionary.coerce(this.obj, newVal, fieldName, fieldClass);
        Object val = this.getValueUnchecked(fieldName);
        this.checkFieldAwareDeferPermissions(UpdatePermission.class, fieldName, coercedNewValue, val);
        if (!Objects.equals(val, coercedNewValue)) {
            if (val == null || coercedNewValue == null || !this.dictionary.isComplexAttribute(EntityDictionary.getType(this.obj), fieldName)) {
                this.setValueChecked(fieldName, coercedNewValue);
            } else if (newVal instanceof Map) {
                Object copy = this.copyComplexAttribute(val);
                this.updateComplexAttribute(this.dictionary, (Map)newVal, copy, this.requestScope);
                this.dictionary.setValue(this.obj, fieldName, copy);
                this.triggerUpdate(fieldName, val, copy);
            } else {
                this.setValueChecked(fieldName, coercedNewValue);
            }
            this.markDirty();
            if (this.dictionary.isAttribute(EntityDictionary.getType(this.obj), fieldName)) {
                this.transaction.setAttribute(this.obj, Attribute.builder().name(fieldName).type(fieldClass).argument(Argument.builder().name("_UNUSED_").value(newVal).build()).build(), this.requestScope);
            }
            return true;
        }
        return false;
    }

    private void updateComplexAttribute(EntityDictionary dictionary, Map<String, Object> updateValue, Object currentValue, RequestScope scope) {
        for (String field : updateValue.keySet()) {
            Object newValue = updateValue.get(field);
            Object coercedNewValue = dictionary.coerce(currentValue, newValue, field, dictionary.getType(currentValue, field));
            Object newOriginal = dictionary.getValue(currentValue, field, scope);
            if (Objects.equals(newOriginal, coercedNewValue)) continue;
            if (newOriginal == null || coercedNewValue == null || !dictionary.isComplexAttribute(ClassType.of(currentValue.getClass()), field)) {
                dictionary.setValue(currentValue, field, coercedNewValue);
                continue;
            }
            if (newValue instanceof Map) {
                this.updateComplexAttribute(dictionary, (Map)newValue, newOriginal, scope);
                continue;
            }
            dictionary.setValue(currentValue, field, coercedNewValue);
        }
    }

    private Object copyComplexAttribute(Object object) {
        Object copy;
        if (object == null) {
            return null;
        }
        Type<Object> type = EntityDictionary.getType(object);
        EntityBinding binding = this.dictionary.getEntityBinding(type);
        Preconditions.checkState((!binding.equals(EntityBinding.EMPTY_BINDING) ? 1 : 0) != 0, (Object)"Model not found.");
        Preconditions.checkState((boolean)binding.apiRelationships.isEmpty(), (Object)"Deep copy of relationships not supported");
        try {
            copy = type.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Cannot perform deep copy of " + type.getName(), e);
        }
        binding.apiAttributes.forEach(attribute -> {
            Object oldValue = this.dictionary.getValue(object, (String)attribute, this.requestScope);
            Object newValue = !this.dictionary.isComplexAttribute(type, (String)attribute) ? oldValue : this.copyComplexAttribute(oldValue);
            this.dictionary.setValue(copy, (String)attribute, newValue);
        });
        return copy;
    }

    public boolean updateRelation(String fieldName, Set<PersistentResource> resourceIdentifiers) {
        boolean isUpdated;
        RelationshipType type = this.getRelationshipType(fieldName);
        Set resources = (Set)PersistentResource.filter(ReadPermission.class, Optional.empty(), ALL_FIELDS, this.getRelationUncheckedUnfiltered(fieldName)).toList(LinkedHashSet::new).blockingGet();
        if (type.isToMany()) {
            List modifiedResources = CollectionUtils.isEmpty(resourceIdentifiers) ? Collections.emptyList() : resourceIdentifiers.stream().map(PersistentResource::getObject).collect(Collectors.toList());
            this.checkFieldAwareDeferPermissions(UpdatePermission.class, fieldName, modifiedResources, resources.stream().map(PersistentResource::getObject).collect(Collectors.toList()));
            isUpdated = this.updateToManyRelation(fieldName, resourceIdentifiers, resources);
        } else {
            PersistentResource resource = (PersistentResource)PersistentResource.firstOrNullIfEmpty(resources);
            Object original = resource == null ? null : resource.getObject();
            PersistentResource modifiedResource = PersistentResource.firstOrNullIfEmpty(resourceIdentifiers);
            Object modified = modifiedResource == null ? null : modifiedResource.getObject();
            this.checkFieldAwareDeferPermissions(UpdatePermission.class, fieldName, modified, original);
            isUpdated = this.updateToOneRelation(fieldName, resourceIdentifiers, resources);
        }
        return isUpdated;
    }

    protected boolean updateToManyRelation(String fieldName, Set<PersistentResource> resourceIdentifiers, Set<PersistentResource> mine) {
        if (resourceIdentifiers == null) {
            throw new InvalidEntityBodyException("Bad relation data");
        }
        Set<PersistentResource> requested = resourceIdentifiers.isEmpty() ? new LinkedHashSet<PersistentResource>() : resourceIdentifiers;
        Sets.SetView deleted = Sets.difference(mine, requested);
        Sets.SetView updated = Sets.difference((Set)Sets.union(mine, requested), (Set)Sets.intersection(mine, requested));
        Sets.SetView added = Sets.difference((Set)updated, (Set)deleted);
        this.checkTransferablePermission((Set<PersistentResource>)added);
        LinkedHashSet newRelationships = new LinkedHashSet();
        LinkedHashSet deletedRelationships = new LinkedHashSet();
        deleted.stream().forEach(toDelete -> deletedRelationships.add(toDelete.getObject()));
        added.stream().forEach(toAdd -> newRelationships.add(toAdd.getObject()));
        Collection collection = (Collection)this.getValueUnchecked(fieldName);
        this.modifyCollection(collection, fieldName, newRelationships, deletedRelationships, true);
        if (!updated.isEmpty()) {
            this.markDirty();
        }
        this.transaction.updateToManyRelation(this.transaction, this.obj, fieldName, newRelationships, deletedRelationships, this.requestScope);
        return !updated.isEmpty();
    }

    protected boolean updateToOneRelation(String fieldName, Set<PersistentResource> resourceIdentifiers, Set<PersistentResource> mine) {
        PersistentResource oldResource;
        Object newValue = null;
        PersistentResource newResource = null;
        if (CollectionUtils.isNotEmpty(resourceIdentifiers)) {
            newResource = (PersistentResource)IterableUtils.first(resourceIdentifiers);
            newValue = newResource.getObject();
        }
        if ((oldResource = PersistentResource.firstOrNullIfEmpty(mine)) == null) {
            if (newValue == null) {
                return false;
            }
            this.checkTransferablePermission(resourceIdentifiers);
        } else {
            if (oldResource.getObject().equals(newValue)) {
                return false;
            }
            this.checkTransferablePermission(resourceIdentifiers);
            if (this.hasInverseRelation(fieldName)) {
                this.deleteInverseRelation(fieldName, oldResource.getObject());
                oldResource.markDirty();
            }
        }
        if (newResource != null && this.hasInverseRelation(fieldName)) {
            this.addInverseRelation(fieldName, newValue);
            newResource.markDirty();
        }
        this.setValueChecked(fieldName, newValue);
        this.transaction.updateToOneRelation(this.transaction, this.obj, fieldName, newValue, this.requestScope);
        this.markDirty();
        return true;
    }

    public boolean clearRelation(String relationName) {
        Set mine = (Set)PersistentResource.filter(ReadPermission.class, Optional.empty(), ALL_FIELDS, this.getRelationUncheckedUnfiltered(relationName)).toList(LinkedHashSet::new).blockingGet();
        this.checkFieldAwareDeferPermissions(UpdatePermission.class, relationName, Collections.emptySet(), mine.stream().map(PersistentResource::getObject).collect(Collectors.toCollection(LinkedHashSet::new)));
        if (mine.isEmpty()) {
            return false;
        }
        RelationshipType type = this.getRelationshipType(relationName);
        if (type.isToOne()) {
            PersistentResource oldValue = (PersistentResource)IterableUtils.first((Iterable)mine);
            if (oldValue != null && oldValue.getObject() != null) {
                this.nullValue(relationName, oldValue);
                oldValue.markDirty();
                this.markDirty();
                this.transaction.updateToOneRelation(this.transaction, this.obj, relationName, null, this.requestScope);
            }
        } else {
            Collection collection = (Collection)this.getValueUnchecked(relationName);
            if (CollectionUtils.isNotEmpty((Collection)collection)) {
                LinkedHashSet deletedRelationships = new LinkedHashSet();
                mine.stream().forEach(toDelete -> deletedRelationships.add(toDelete.getObject()));
                this.modifyCollection(collection, relationName, Collections.emptySet(), deletedRelationships, true);
                this.markDirty();
                this.transaction.updateToManyRelation(this.transaction, this.obj, relationName, new LinkedHashSet(), deletedRelationships, this.requestScope);
            }
        }
        return true;
    }

    public void removeRelation(String fieldName, PersistentResource removeResource) {
        RelationshipType type;
        Object relation;
        Object original = relation = this.getValueUnchecked(fieldName);
        Collection modified = null;
        if (relation instanceof Collection) {
            original = this.copyCollection((Collection)relation);
        }
        if (relation instanceof Collection && removeResource != null) {
            modified = CollectionUtils.disjunction((Iterable)((Collection)relation), Collections.singleton(removeResource.getObject()));
        }
        this.checkFieldAwareDeferPermissions(UpdatePermission.class, fieldName, modified, original);
        if (relation instanceof Collection) {
            if (removeResource == null || !((Collection)relation).contains(removeResource.getObject())) {
                return;
            }
            this.modifyCollection((Collection)relation, fieldName, Collections.emptySet(), Set.of(removeResource.getObject()), true);
        } else {
            if (relation == null || removeResource == null || !relation.equals(removeResource.getObject())) {
                return;
            }
            this.nullValue(fieldName, removeResource);
            if (this.hasInverseRelation(fieldName)) {
                this.deleteInverseRelation(fieldName, removeResource.getObject());
                removeResource.markDirty();
            }
        }
        if (!Objects.equals(original, modified)) {
            this.markDirty();
        }
        if ((type = this.getRelationshipType(fieldName)).isToOne()) {
            this.transaction.updateToOneRelation(this.transaction, this.obj, fieldName, null, this.requestScope);
        } else {
            this.transaction.updateToManyRelation(this.transaction, this.obj, fieldName, new LinkedHashSet(), Sets.newHashSet((Object[])new Object[]{removeResource.getObject()}), this.requestScope);
        }
    }

    public void addRelation(String fieldName, PersistentResource newRelation) {
        this.checkTransferablePermission(Collections.singleton(newRelation));
        Object relation = this.getValueUnchecked(fieldName);
        if (relation instanceof Collection) {
            if (this.modifyCollection((Collection)relation, fieldName, Set.of(newRelation.getObject()), Collections.emptySet(), true)) {
                this.markDirty();
                this.transaction.updateToManyRelation(this.transaction, this.obj, fieldName, Sets.newHashSet((Object[])new Object[]{newRelation.getObject()}), new LinkedHashSet(), this.requestScope);
                this.addInverseRelation(fieldName, newRelation.getObject());
            }
        } else {
            this.updateRelation(fieldName, Collections.singleton(newRelation));
        }
    }

    protected void checkTransferablePermission(Set<PersistentResource> resourceIdentifiers) {
        if (resourceIdentifiers == null) {
            return;
        }
        Set<PersistentResource> newResources = this.getRequestScope().getNewPersistentResources();
        for (PersistentResource persistentResource : resourceIdentifiers) {
            if (newResources.contains(persistentResource) || !this.dictionary.isTransferable(this.getResourceType()) && !this.dictionary.isStrictNonTransferable(persistentResource.getResourceType()) && persistentResource.equals(this.lineage.getParent())) continue;
            PersistentResource.checkPermission(NonTransferable.class, persistentResource);
        }
    }

    public void deleteResource() throws ForbiddenAccessException {
        PersistentResource.checkPermission(DeletePermission.class, this);
        Type<T> resourceClass = this.getResourceType();
        List<String> relationships = this.dictionary.getRelationships(resourceClass);
        for (String relationName : relationships) {
            String inverseRelationName;
            if (this.dictionary.cascadeDeletes(resourceClass, relationName) || CLASS_NO_FIELD.equals(inverseRelationName = this.dictionary.getRelationInverse(resourceClass, relationName))) continue;
            for (PersistentResource inverseResource : (List)this.getRelationUncheckedUnfiltered(relationName).toList().blockingGet()) {
                if (!this.hasInverseRelation(relationName)) continue;
                this.deleteInverseRelation(relationName, inverseResource.getObject());
                inverseResource.markDirty();
            }
        }
        this.transaction.delete(this.getObject(), this.requestScope);
        this.auditClass(Audit.Action.DELETE, new ChangeSpec(this, null, this.getObject(), null));
        this.requestScope.publishLifecycleEvent(this, LifeCycleHookBinding.Operation.DELETE);
        this.requestScope.getDeletedResources().add(this);
    }

    @Override
    public String getId() {
        return this.dictionary.getId(this.getObject());
    }

    public void setId(String id) {
        this.dictionary.setId(this.obj, id);
    }

    public boolean isIdGenerated() {
        return this.dictionary.getEntityBinding(this.type).isIdGenerated();
    }

    @Override
    public Optional<String> getUUID() {
        return this.uuid;
    }

    public PersistentResource getRelation(Relationship relationship, String id) {
        List resources = (List)this.getRelation(Collections.singletonList(id), relationship).toList().blockingGet();
        if (resources.isEmpty()) {
            return null;
        }
        for (PersistentResource resource : resources) {
            if (!resource.matchesId(id)) continue;
            return resource;
        }
        return null;
    }

    public Observable<PersistentResource> getRelation(List<String> ids, Relationship relationship) {
        FilterExpression filterExpression = Optional.ofNullable(relationship.getProjection().getFilterExpression()).orElse(null);
        this.assertPropertyExists(relationship.getName());
        Type<?> entityType = this.dictionary.getParameterizedType(this.getResourceType(), relationship.getName());
        Set newResources = new LinkedHashSet();
        if (!ids.isEmpty()) {
            newResources = this.requestScope.getNewPersistentResources().stream().filter(resource -> entityType.isAssignableFrom(resource.getResourceType()) && ids.contains(resource.getUUID().orElse(CLASS_NO_FIELD))).collect(Collectors.toCollection(LinkedHashSet::new));
            FilterExpression idExpression = PersistentResource.buildIdFilterExpression(ids, entityType, this.dictionary, this.requestScope);
            filterExpression = Optional.ofNullable(relationship.getProjection().getFilterExpression()).map(fe -> new AndFilterExpression(idExpression, (FilterExpression)fe)).orElse(idExpression);
        }
        Observable<PersistentResource> existingResources = PersistentResource.filter(ReadPermission.class, Optional.ofNullable(filterExpression), relationship.getProjection().getRequestedFields(), this.getRelation(relationship.copyOf().projection(relationship.getProjection().copyOf().filterExpression(filterExpression).build()).build(), true));
        Observable allResources = Observable.fromIterable(newResources).mergeWith(existingResources);
        LinkedHashSet foundIds = new LinkedHashSet();
        allResources = allResources.doOnNext(resource -> {
            String id = (String)resource.getUUID().orElseGet(resource::getId);
            if (ids.contains(id)) {
                foundIds.add(id);
            }
        });
        allResources = allResources.doOnComplete(() -> {
            Sets.SetView missedIds = Sets.difference(new LinkedHashSet(ids), (Set)foundIds);
            if (!missedIds.isEmpty()) {
                throw new InvalidObjectIdentifierException(missedIds.toString(), relationship.getName());
            }
        });
        return allResources;
    }

    public Observable<PersistentResource> getRelationCheckedFiltered(Relationship relationship) {
        return PersistentResource.filter(ReadPermission.class, Optional.ofNullable(relationship.getProjection().getFilterExpression()), relationship.getProjection().getRequestedFields(), this.getRelation(relationship, true));
    }

    private Observable<PersistentResource> getRelationUncheckedUnfiltered(String relationName) {
        this.assertPropertyExists(relationName);
        return this.getRelation(Relationship.builder().name(relationName).alias(relationName).projection(EntityProjection.builder().type(this.dictionary.getParameterizedType(this.getResourceType(), relationName)).build()).build(), false);
    }

    private void assertPropertyExists(String propertyName) {
        if (propertyName == null || this.dictionary.getParameterizedType(this.obj, propertyName) == null) {
            throw new InvalidAttributeException(propertyName, this.getTypeName());
        }
    }

    private Observable<PersistentResource> getRelation(Relationship relationship, boolean checked) {
        if (checked && !this.checkRelation(relationship)) {
            return Observable.empty();
        }
        Type<?> relationClass = this.dictionary.getParameterizedType(this.obj, relationship.getName());
        Optional<Pagination> pagination = Optional.ofNullable(relationship.getProjection().getPagination());
        if (pagination.filter((Predicate<Pagination>)Predicates.not(Pagination::isDefaultInstance)).isPresent() && !CanPaginateVisitor.canPaginate(relationClass, this.dictionary, this.requestScope, relationship.getProjection().getRequestedFields())) {
            throw new BadRequestException(String.format("Cannot paginate %s", this.dictionary.getJsonAliasFor(relationClass)));
        }
        return this.getRelationUnchecked(relationship);
    }

    protected boolean checkRelation(Relationship relationship) {
        String relationName = relationship.getName();
        String realName = this.dictionary.getNameFromAlias(this.obj, relationName);
        relationName = realName == null ? relationName : realName;
        this.assertPropertyExists(relationName);
        this.checkFieldAwareDeferPermissions(ReadPermission.class, relationName, null, null);
        return !PersistentResource.shouldSkipCollection(this.dictionary.getParameterizedType(this.obj, relationName), ReadPermission.class, this.requestScope, relationship.getProjection().getRequestedFields());
    }

    public Observable<PersistentResource> getRelationChecked(Relationship relationship) {
        if (!this.checkRelation(relationship)) {
            return Observable.empty();
        }
        return this.getRelationUnchecked(relationship);
    }

    private Observable<PersistentResource> getRelationUnchecked(Relationship relationship) {
        Observable resources;
        String relationName = relationship.getName();
        FilterExpression filterExpression = relationship.getProjection().getFilterExpression();
        Pagination pagination = relationship.getProjection().getPagination();
        Sorting sorting = relationship.getProjection().getSorting();
        RelationshipType type = this.getRelationshipType(relationName);
        Type<?> relationClass = this.dictionary.getParameterizedType(this.obj, relationName);
        if (relationClass == null) {
            throw new InvalidAttributeException(relationName, this.getTypeName());
        }
        Optional<FilterExpression> permissionFilter = PersistentResource.getPermissionFilterExpression(relationClass, this.requestScope, relationship.getProjection().getRequestedFields());
        Optional<FilterExpression> computedFilters = Optional.ofNullable(filterExpression);
        if (permissionFilter.isPresent() && filterExpression != null) {
            AndFilterExpression mergedExpression = new AndFilterExpression(filterExpression, permissionFilter.get());
            computedFilters = Optional.of(mergedExpression);
        } else if (permissionFilter.isPresent()) {
            computedFilters = permissionFilter;
        }
        Relationship modifiedRelationship = relationship.copyOf().projection(relationship.getProjection().copyOf().filterExpression(computedFilters.orElse(null)).sorting(sorting).pagination(pagination).build()).build();
        if (type.isToMany()) {
            DataStoreIterable val = this.transaction.getToManyRelation(this.transaction, this.obj, modifiedRelationship, this.requestScope);
            if (val == null) {
                return Observable.empty();
            }
            resources = Observable.fromIterable(new PersistentResourceSet(this, relationName, val, this.requestScope));
        } else {
            Object val = this.transaction.getToOneRelation(this.transaction, this.obj, modifiedRelationship, this.requestScope);
            if (val == null) {
                return Observable.empty();
            }
            resources = Observable.fromArray((Object[])new PersistentResource[]{new PersistentResource(val, this, relationName, this.requestScope.getUUIDFor(val), this.requestScope)});
        }
        return resources;
    }

    public RelationshipType getRelationshipType(String relation) {
        return this.dictionary.getRelationshipType(this.obj, relation);
    }

    @Deprecated
    public Object getAttribute(String attr) {
        this.assertPropertyExists(attr);
        return this.getAttribute(Attribute.builder().name(attr).alias(attr).type(this.dictionary.getParameterizedType(this.getResourceType(), attr)).build());
    }

    public Object getAttribute(Attribute attr) {
        return this.getValueChecked(attr);
    }

    @Override
    public T getObject() {
        return this.obj;
    }

    public void setObject(T obj) {
        this.obj = obj;
    }

    @Override
    @JsonIgnore
    public Type<T> getResourceType() {
        return this.dictionary.lookupBoundClass(EntityDictionary.getType(this.obj));
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            String id = this.dictionary.getId(this.getObject());
            this.hashCode = this.uuid.isPresent() && ("0".equals(id) || "null".equals(id)) ? Objects.hashCode(this.uuid) : Objects.hashCode(id);
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PersistentResource) {
            PersistentResource that = (PersistentResource)obj;
            if (this.getObject() == that.getObject()) {
                return true;
            }
            String theirId = this.dictionary.getId(that.getObject());
            return this.matchesId(theirId) && Objects.equals(this.typeName, that.typeName);
        }
        return false;
    }

    public boolean isNewlyCreated() {
        return this.requestScope.getNewResources().contains(this);
    }

    public ResourceLineage getLineage() {
        return this.lineage;
    }

    public EntityDictionary getDictionary() {
        return this.dictionary;
    }

    @Override
    public RequestScope getRequestScope() {
        return this.requestScope;
    }

    public Resource toResource() {
        return this.toResource(this::getRelationships, this::getAttributes);
    }

    public Resource toResource(EntityProjection projection) {
        return this.toResource(() -> this.getRelationships(projection), this::getAttributes);
    }

    private Resource toResource(Supplier<Map<String, com.yahoo.elide.jsonapi.models.Relationship>> relationshipSupplier, Supplier<Map<String, Object>> attributeSupplier) {
        return this.toResource(relationshipSupplier.get(), attributeSupplier.get());
    }

    public Resource toResource(Map<String, com.yahoo.elide.jsonapi.models.Relationship> relationships, Map<String, Object> attributes) {
        Resource resource = new Resource(this.typeName, this.obj == null ? this.uuid.orElseThrow(() -> new InvalidEntityBodyException("No id found on object")) : this.dictionary.getId(this.obj));
        resource.setRelationships(relationships);
        resource.setAttributes(attributes);
        JsonApiSettings jsonApiSettings = this.requestScope.getElideSettings().getSettings(JsonApiSettings.class);
        if (jsonApiSettings != null && jsonApiSettings.getLinks().isEnabled()) {
            resource.setLinks(jsonApiSettings.getLinks().getJsonApiLinks().getResourceLevelLinks(this));
        }
        if (!(this.getObject() instanceof WithMetadata)) {
            return resource;
        }
        WithMetadata withMetadata = (WithMetadata)this.getObject();
        Set<String> fields = withMetadata.getMetadataFields();
        if (fields.size() == 0) {
            return resource;
        }
        Meta meta = new Meta(new LinkedHashMap<String, Object>());
        for (String field : fields) {
            meta.getMetaMap().put(field, withMetadata.getMetadataField(field).get());
        }
        resource.setMeta(meta);
        return resource;
    }

    protected Map<String, com.yahoo.elide.jsonapi.models.Relationship> getRelationships() {
        return this.getRelationshipsWithRelationshipFunction(relationName -> {
            Optional<FilterExpression> filterExpression = this.requestScope.getExpressionForRelation(this.getResourceType(), (String)relationName);
            return this.getRelationCheckedFiltered(Relationship.builder().alias((String)relationName).name((String)relationName).projection(EntityProjection.builder().type(this.dictionary.getParameterizedType(this.getResourceType(), (String)relationName)).filterExpression(filterExpression.orElse(null)).build()).build());
        });
    }

    private Map<String, com.yahoo.elide.jsonapi.models.Relationship> getRelationships(EntityProjection projection) {
        return this.getRelationshipsWithRelationshipFunction(relationName -> this.getRelationCheckedFiltered(projection.getRelationship((String)relationName).orElseThrow(IllegalStateException::new)));
    }

    protected Map<String, com.yahoo.elide.jsonapi.models.Relationship> getRelationshipsWithRelationshipFunction(Function<String, Observable<PersistentResource>> relationshipFunction) {
        LinkedHashMap<String, com.yahoo.elide.jsonapi.models.Relationship> relationshipMap = new LinkedHashMap<String, com.yahoo.elide.jsonapi.models.Relationship>();
        Set<String> relationshipFields = this.filterFields(this.dictionary.getRelationships(this.obj));
        for (String field : relationshipFields) {
            TreeMap<String, Resource> orderedById = new TreeMap<String, Resource>(this.lengthFirstComparator);
            for (PersistentResource relationship : (List)relationshipFunction.apply(field).toList().blockingGet()) {
                orderedById.put(relationship.getId(), new ResourceIdentifier(relationship.getTypeName(), relationship.getId()).castToResource());
            }
            Observable resources = Observable.fromIterable(orderedById.values());
            RelationshipType relationshipType = this.getRelationshipType(field);
            Data<Resource> data = relationshipType.isToOne() ? new Data<Resource>((Resource)PersistentResource.firstOrNullIfEmpty(resources)) : new Data(resources);
            Map<String, String> links = null;
            JsonApiSettings jsonApiSettings = this.requestScope.getElideSettings().getSettings(JsonApiSettings.class);
            if (jsonApiSettings != null && jsonApiSettings.getLinks().isEnabled()) {
                links = jsonApiSettings.getLinks().getJsonApiLinks().getRelationshipLinks(this, field);
            }
            relationshipMap.put(field, new com.yahoo.elide.jsonapi.models.Relationship(links, data));
        }
        return relationshipMap;
    }

    protected Map<String, Object> getAttributes() {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        Set<String> attrFields = this.filterFields(this.dictionary.getAttributes(this.obj));
        for (String field : attrFields) {
            Object val = this.getAttribute(field);
            attributes.put(field, val);
        }
        return attributes;
    }

    protected void setValueChecked(String fieldName, Object newValue) {
        Object existingValue = this.getValueUnchecked(fieldName);
        this.checkFieldAwareDeferPermissions(UpdatePermission.class, fieldName, newValue, existingValue);
        this.setValue(fieldName, newValue);
    }

    protected void nullValue(String fieldName, PersistentResource oldValue) {
        if (oldValue == null) {
            return;
        }
        String inverseField = this.getInverseRelationField(fieldName);
        if (!inverseField.isEmpty()) {
            oldValue.checkFieldAwareDeferPermissions(UpdatePermission.class, inverseField, null, this.getObject());
        }
        this.setValueChecked(fieldName, null);
    }

    protected Object getValueChecked(Attribute attribute) {
        this.checkFieldAwareDeferPermissions(ReadPermission.class, attribute.getName(), null, null);
        return this.transaction.getAttribute(this.getObject(), attribute, this.requestScope);
    }

    protected Object getValueUnchecked(String fieldName) {
        return PersistentResource.getValue(this.getObject(), fieldName, this.requestScope);
    }

    protected boolean modifyCollection(Collection toModify, String collectionName, Collection toAdd, Collection toRemove, boolean updateInverse) {
        Collection copyOfOriginal = this.copyCollection(toModify);
        Collection modified = CollectionUtils.union((Iterable)CollectionUtils.emptyIfNull((Collection)toModify), (Iterable)toAdd);
        modified = CollectionUtils.subtract((Iterable)modified, (Iterable)toRemove);
        this.checkFieldAwareDeferPermissions(UpdatePermission.class, collectionName, modified, copyOfOriginal);
        if (updateInverse) {
            for (Object adding : toAdd) {
                this.addInverseRelation(collectionName, adding);
            }
            for (Object removing : toRemove) {
                this.deleteInverseRelation(collectionName, removing);
            }
        }
        if (toModify == null) {
            this.setValueChecked(collectionName, modified);
            return true;
        }
        if (copyOfOriginal.equals(modified)) {
            return false;
        }
        toModify.addAll(toAdd);
        toModify.removeAll(toRemove);
        this.triggerUpdate(collectionName, copyOfOriginal, modified);
        return true;
    }

    protected void setValue(String fieldName, Object value) {
        Object original = this.getValueUnchecked(fieldName);
        this.dictionary.setValue(this.obj, fieldName, value);
        this.triggerUpdate(fieldName, original, value);
    }

    protected void deleteInverseRelation(String relationName, Object inverseEntity) {
        String inverseField = this.getInverseRelationField(relationName);
        if (!CLASS_NO_FIELD.equals(inverseField)) {
            Type<T> inverseType = this.dictionary.getType(inverseEntity, inverseField);
            String uuid = this.requestScope.getUUIDFor(inverseEntity);
            PersistentResource<Object> inverseResource = new PersistentResource<Object>(inverseEntity, this, relationName, uuid, this.requestScope);
            Object inverseRelation = inverseResource.getValueUnchecked(inverseField);
            if (inverseRelation == null) {
                return;
            }
            if (inverseRelation instanceof Collection) {
                inverseResource.modifyCollection((Collection)inverseRelation, inverseField, Collections.emptySet(), Set.of(this.getObject()), false);
            } else if (inverseType.isAssignableFrom(this.getResourceType())) {
                inverseResource.nullValue(inverseField, this);
            } else {
                throw new InternalServerErrorException("Relationship type mismatch");
            }
            inverseResource.markDirty();
            RelationshipType inverseRelationType = inverseResource.getRelationshipType(inverseField);
            if (inverseRelationType.isToOne()) {
                this.transaction.updateToOneRelation(this.transaction, inverseEntity, inverseField, null, this.requestScope);
            } else {
                assert (inverseRelation instanceof Collection) : inverseField + " not a collection";
                this.transaction.updateToManyRelation(this.transaction, inverseEntity, inverseField, new LinkedHashSet(), Sets.newHashSet((Object[])new Object[]{this.obj}), this.requestScope);
            }
        }
    }

    private boolean hasInverseRelation(String relationName) {
        String inverseField = this.getInverseRelationField(relationName);
        return StringUtils.isNotEmpty((CharSequence)inverseField);
    }

    private String getInverseRelationField(String relationName) {
        return this.dictionary.getRelationInverse(this.type, relationName);
    }

    protected void addInverseRelation(String relationName, Object inverseObj) {
        String inverseName = this.dictionary.getRelationInverse(this.type, relationName);
        if (!CLASS_NO_FIELD.equals(inverseName)) {
            Type<T> inverseType = this.dictionary.getType(inverseObj, inverseName);
            String uuid = this.requestScope.getUUIDFor(inverseObj);
            PersistentResource<Object> inverseResource = new PersistentResource<Object>(inverseObj, this, relationName, uuid, this.requestScope);
            Object inverseRelation = inverseResource.getValueUnchecked(inverseName);
            if (ClassType.COLLECTION_TYPE.isAssignableFrom((Type)inverseType)) {
                if (inverseRelation != null) {
                    inverseResource.modifyCollection((Collection)inverseRelation, inverseName, Set.of(this.getObject()), Collections.emptySet(), false);
                } else {
                    inverseResource.setValueChecked(inverseName, Collections.singleton(this.getObject()));
                }
            } else if (inverseType.isAssignableFrom(this.getResourceType())) {
                inverseResource.setValueChecked(inverseName, this.getObject());
            } else {
                throw new InternalServerErrorException("Relationship type mismatch");
            }
            inverseResource.markDirty();
            RelationshipType inverseRelationType = inverseResource.getRelationshipType(inverseName);
            if (inverseRelationType.isToOne()) {
                this.transaction.updateToOneRelation(this.transaction, inverseObj, inverseName, this.obj, this.requestScope);
            } else {
                assert (inverseRelation == null || inverseRelation instanceof Collection) : inverseName + " not a collection";
                this.transaction.updateToManyRelation(this.transaction, inverseObj, inverseName, Sets.newHashSet((Object[])new Object[]{this.obj}), new LinkedHashSet(), this.requestScope);
            }
        }
    }

    protected Set<String> filterFields(Collection<String> fields) {
        Set<String> byType;
        LinkedHashSet<String> filteredSet = new LinkedHashSet<String>();
        Map<String, Set<String>> sparseFields = this.requestScope.getSparseFields();
        Stream<Object> stream = sparseFields.isEmpty() ? fields.stream() : ((byType = sparseFields.get(this.typeName)) == null || fields == null || byType.isEmpty() || fields.isEmpty() ? Stream.empty() : byType.stream().filter(fields::contains));
        stream.forEach(field -> {
            try {
                this.checkFieldAwareReadPermissions((String)field);
                filteredSet.add((String)field);
            }
            catch (ForbiddenAccessException forbiddenAccessException) {
                // empty catch block
            }
        });
        return filteredSet;
    }

    private void triggerUpdate(String fieldName, Object original, Object value) {
        ChangeSpec changeSpec = new ChangeSpec(this, fieldName, original, value);
        LifeCycleHookBinding.Operation action = this.isNewlyCreated() ? LifeCycleHookBinding.Operation.CREATE : LifeCycleHookBinding.Operation.UPDATE;
        this.requestScope.publishLifecycleEvent(this, fieldName, action, Optional.of(changeSpec));
        this.requestScope.publishLifecycleEvent(this, action);
        this.auditField(new ChangeSpec(this, fieldName, original, value));
    }

    private <A extends Annotation> ExpressionResult checkFieldAwarePermissions(Class<A> annotationClass, Set<String> requestedFields) {
        return this.requestScope.getPermissionExecutor().checkPermission(annotationClass, this, requestedFields);
    }

    private <A extends Annotation> ExpressionResult checkFieldAwareReadPermissions(String fieldName) {
        return this.requestScope.getPermissionExecutor().checkSpecificFieldPermissions(this, null, ReadPermission.class, fieldName);
    }

    private <A extends Annotation> ExpressionResult checkFieldAwareDeferPermissions(Class<A> annotationClass, String fieldName, Object modified, Object original) {
        ChangeSpec changeSpec = UpdatePermission.class.isAssignableFrom(annotationClass) ? new ChangeSpec(this, fieldName, original, modified) : null;
        return this.requestScope.getPermissionExecutor().checkSpecificFieldPermissionsDeferred(this, changeSpec, annotationClass, fieldName);
    }

    protected void auditField(ChangeSpec changeSpec) {
        String fieldName = changeSpec.getFieldName();
        Audit[] annotations = (Audit[])this.dictionary.getAttributeOrRelationAnnotations(this.getResourceType(), Audit.class, fieldName);
        if (annotations == null || annotations.length == 0) {
            this.auditClass(Audit.Action.UPDATE, changeSpec);
            return;
        }
        for (Audit annotation : annotations) {
            if (annotation.action().length != 1 || annotation.action()[0] != Audit.Action.UPDATE) {
                throw new InvalidSyntaxException("Only Audit.Action.UPDATE is allowed on fields.");
            }
            LogMessageImpl message = new LogMessageImpl(annotation, this, Optional.of(changeSpec));
            this.getRequestScope().getAuditLogger().log(message);
        }
    }

    protected void auditClass(Audit.Action action, ChangeSpec changeSpec) {
        Audit[] annotations = (Audit[])this.getResourceType().getAnnotationsByType(Audit.class);
        if (annotations == null) {
            return;
        }
        for (Audit annotation : annotations) {
            for (Audit.Action auditAction : annotation.action()) {
                if (auditAction != action) continue;
                LogMessageImpl message = new LogMessageImpl(annotation, this, Optional.ofNullable(changeSpec));
                this.getRequestScope().getAuditLogger().log(message);
            }
        }
    }

    private Collection copyCollection(Collection collection) {
        ArrayList newCollection = new ArrayList();
        if (CollectionUtils.isEmpty((Collection)collection)) {
            return newCollection;
        }
        collection.iterator().forEachRemaining(newCollection::add);
        return newCollection;
    }

    private void markDirty() {
        this.requestScope.getDirtyResources().add(this);
    }
}

