/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.elide.Serdes;
import com.yahoo.elide.Settings;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.audit.AuditLogger;
import com.yahoo.elide.core.audit.Slf4jLogger;
import com.yahoo.elide.core.datastore.DataStore;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.exceptions.ExceptionMappers;
import com.yahoo.elide.core.security.PermissionExecutor;
import com.yahoo.elide.core.security.executors.ActivePermissionExecutor;
import com.yahoo.elide.core.utils.coerce.converters.Serde;
import com.yahoo.elide.utils.HeaderProcessor;
import com.yahoo.elide.utils.Headers;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public class ElideSettings {
    private final AuditLogger auditLogger;
    private final DataStore dataStore;
    private final EntityDictionary entityDictionary;
    private final ObjectMapper objectMapper;
    private final Function<RequestScope, PermissionExecutor> permissionExecutor;
    private final HeaderProcessor headerProcessor;
    private final int maxPageSize;
    private final int defaultPageSize;
    private final Serdes serdes;
    private final String baseUrl;
    private final boolean verboseErrors;
    private final Map<Class<? extends Settings>, Settings> settings;

    public ElideSettings(AuditLogger auditLogger, DataStore dataStore, EntityDictionary entityDictionary, ObjectMapper objectMapper, Function<RequestScope, PermissionExecutor> permissionExecutor, HeaderProcessor headerProcessor, int maxPageSize, int defaultPageSize, Serdes serdes, String baseUrl, boolean verboseErrors, Map<Class<? extends Settings>, Settings> settings) {
        this.auditLogger = auditLogger;
        this.dataStore = dataStore;
        this.entityDictionary = entityDictionary;
        this.objectMapper = objectMapper;
        this.permissionExecutor = permissionExecutor;
        this.headerProcessor = headerProcessor;
        this.maxPageSize = maxPageSize;
        this.defaultPageSize = defaultPageSize;
        this.serdes = serdes;
        this.baseUrl = baseUrl;
        this.verboseErrors = verboseErrors;
        this.settings = settings;
    }

    public ElideSettingsBuilder mutate() {
        ElideSettingsBuilder builder = (ElideSettingsBuilder)((ElideSettingsBuilder)((ElideSettingsBuilder)((ElideSettingsBuilder)((ElideSettingsBuilder)((ElideSettingsBuilder)((ElideSettingsBuilder)((ElideSettingsBuilder)((ElideSettingsBuilder)((ElideSettingsBuilder)ElideSettings.builder().auditLogger(this.auditLogger)).dataStore(this.dataStore)).entityDictionary(this.entityDictionary)).objectMapper(this.objectMapper)).permissionExecutor(this.permissionExecutor)).headerProcessor(this.headerProcessor)).maxPageSize(this.maxPageSize)).defaultPageSize(this.defaultPageSize)).baseUrl(this.baseUrl)).verboseErrors(this.verboseErrors);
        builder.serdes(newSerdes -> newSerdes.entries(entries -> {
            entries.clear();
            this.serdes.entrySet().stream().forEach(entry -> entries.put((Class)entry.getKey(), (Serde)entry.getValue()));
        }));
        this.settings.values().forEach(oldSettings -> builder.settings(oldSettings.mutate()));
        return builder;
    }

    public <T extends Settings> T getSettings(Class<T> clazz) {
        return (T)((Settings)clazz.cast(this.settings.get(clazz)));
    }

    public static ElideSettingsBuilder builder() {
        return new ElideSettingsBuilder();
    }

    public AuditLogger getAuditLogger() {
        return this.auditLogger;
    }

    public DataStore getDataStore() {
        return this.dataStore;
    }

    public EntityDictionary getEntityDictionary() {
        return this.entityDictionary;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public Function<RequestScope, PermissionExecutor> getPermissionExecutor() {
        return this.permissionExecutor;
    }

    public HeaderProcessor getHeaderProcessor() {
        return this.headerProcessor;
    }

    public int getMaxPageSize() {
        return this.maxPageSize;
    }

    public int getDefaultPageSize() {
        return this.defaultPageSize;
    }

    public Serdes getSerdes() {
        return this.serdes;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public boolean isVerboseErrors() {
        return this.verboseErrors;
    }

    public Map<Class<? extends Settings>, Settings> getSettings() {
        return this.settings;
    }

    public static class ElideSettingsBuilder
    extends ElideSettingsBuilderSupport<ElideSettingsBuilder> {
        @Override
        public ElideSettingsBuilder self() {
            return this;
        }

        public ElideSettings build() {
            LinkedHashMap<Class<? extends Settings>, Settings> settings = new LinkedHashMap<Class<? extends Settings>, Settings>();
            this.settings.values().forEach(value -> {
                Settings result = value.build();
                settings.put(result.getClass(), result);
            });
            return new ElideSettings(this.auditLogger, this.dataStore, this.entityDictionary, this.objectMapper, this.permissionExecutor, this.headerProcessor, this.maxPageSize, this.defaultPageSize, this.serdes.build(), this.baseUrl, this.verboseErrors, settings);
        }
    }

    public static abstract class ElideSettingsBuilderSupport<S> {
        protected Serdes.SerdesBuilder serdes = Serdes.builder();
        protected String baseUrl = "";
        protected AuditLogger auditLogger = new Slf4jLogger();
        protected HeaderProcessor headerProcessor = Headers::removeAuthorizationHeaders;
        protected ObjectMapper objectMapper = new ObjectMapper();
        protected int maxPageSize = 10000;
        protected int defaultPageSize = 500;
        protected Function<RequestScope, PermissionExecutor> permissionExecutor = ActivePermissionExecutor::new;
        protected Map<Class<?>, Settings.SettingsBuilder> settings = new LinkedHashMap();
        protected DataStore dataStore;
        protected EntityDictionary entityDictionary;
        protected ExceptionMappers exceptionMappers;
        protected boolean verboseErrors = false;

        protected ElideSettingsBuilderSupport() {
            ((Serdes.SerdesBuilder)((Serdes.SerdesBuilder)this.serdes.withDefaults()).withEpochDates()).build();
        }

        public <T extends Settings.SettingsBuilder> T getSettings(Class<T> clazz) {
            return (T)((Settings.SettingsBuilder)clazz.cast(this.settings.get(clazz)));
        }

        public S serdes(Consumer<Serdes.SerdesBuilder> serdes) {
            serdes.accept(this.serdes);
            return this.self();
        }

        public S settings(Settings.SettingsBuilder ... settings) {
            Arrays.asList(settings).stream().forEach(item -> this.settings.put(item.getClass(), (Settings.SettingsBuilder)item));
            return this.self();
        }

        public S settings(Consumer<Map<Class<?>, Settings.SettingsBuilder>> settings) {
            settings.accept(this.settings);
            return this.self();
        }

        public S verboseErrors(boolean verboseErrors) {
            this.verboseErrors = verboseErrors;
            return this.self();
        }

        public S baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this.self();
        }

        public S auditLogger(AuditLogger auditLogger) {
            this.auditLogger = auditLogger;
            return this.self();
        }

        public S headerProcessor(HeaderProcessor headerProcessor) {
            this.headerProcessor = headerProcessor;
            return this.self();
        }

        public S objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this.self();
        }

        public S maxPageSize(int maxPageSize) {
            this.maxPageSize = maxPageSize;
            return this.self();
        }

        public S defaultPageSize(int defaultPageSize) {
            this.defaultPageSize = defaultPageSize;
            return this.self();
        }

        public S permissionExecutor(Function<RequestScope, PermissionExecutor> permissionExecutor) {
            this.permissionExecutor = permissionExecutor;
            return this.self();
        }

        public S dataStore(DataStore dataStore) {
            this.dataStore = dataStore;
            return this.self();
        }

        public S entityDictionary(EntityDictionary entityDictionary) {
            this.entityDictionary = entityDictionary;
            return this.self();
        }

        public abstract S self();
    }
}

