/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide;

public class ElideModules {
    private static final boolean GRAPHQL_PRESENT = ElideModules.isPresent("com.yahoo.elide.graphql.GraphQLSettings", ElideModules.class.getClassLoader());
    private static final boolean JSON_API_PRESENT = ElideModules.isPresent("com.yahoo.elide.jsonapi.JsonApiSettings", ElideModules.class.getClassLoader());
    private static final boolean ASYNC_PRESENT = ElideModules.isPresent("com.yahoo.elide.async.AsyncSettings", ElideModules.class.getClassLoader());

    private ElideModules() {
    }

    public static boolean isGraphQLPresent() {
        return GRAPHQL_PRESENT;
    }

    public static boolean isJsonApiPresent() {
        return JSON_API_PRESENT;
    }

    public static boolean isAsyncPresent() {
        return ASYNC_PRESENT;
    }

    private static boolean isPresent(String name, ClassLoader classLoader) {
        try {
            Class.forName(name, false, classLoader);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

