/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;

public class ElideError {
    private final String message;
    private final Map<String, Object> attributes;

    public ElideError(String message, Map<String, Object> attributes) {
        this.message = message;
        this.attributes = attributes;
    }

    public static ElideErrorBuilder builder() {
        return new ElideErrorBuilder();
    }

    public String getMessage() {
        return this.message;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public static class ElideErrorBuilder {
        private String message;
        private Map<String, Object> attributes = new LinkedHashMap<String, Object>();

        public ElideErrorBuilder message(String message) {
            this.message = message;
            return this;
        }

        public ElideErrorBuilder attributes(Map<String, Object> attributes) {
            this.attributes = attributes;
            return this;
        }

        public ElideErrorBuilder attributes(Consumer<Map<String, Object>> attributes) {
            attributes.accept(this.attributes);
            return this;
        }

        public ElideErrorBuilder attribute(String key, Object value) {
            this.attributes.put(key, value);
            return this;
        }

        public ElideError build() {
            return new ElideError(this.message, this.attributes);
        }
    }
}

