/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.yahoo.elide.ElideSettings;
import com.yahoo.elide.Settings;
import com.yahoo.elide.core.TransactionRegistry;
import com.yahoo.elide.core.audit.AuditLogger;
import com.yahoo.elide.core.datastore.DataStore;
import com.yahoo.elide.core.datastore.inmemory.InMemoryDataStore;
import com.yahoo.elide.core.dictionary.Injector;
import com.yahoo.elide.core.utils.ClassScanner;
import com.yahoo.elide.core.utils.coerce.CoerceUtil;
import com.yahoo.elide.core.utils.coerce.converters.ElideTypeConverter;
import com.yahoo.elide.core.utils.coerce.converters.Serde;
import java.io.IOException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Elide {
    private static final Logger log = LoggerFactory.getLogger(Elide.class);
    private final ElideSettings elideSettings;
    private final AuditLogger auditLogger;
    private final DataStore dataStore;
    private final ObjectMapper objectMapper;
    private final TransactionRegistry transactionRegistry;
    private final ClassScanner scanner;
    private boolean initialized = false;

    public Elide(ElideSettings elideSettings) {
        this(elideSettings, new TransactionRegistry(), elideSettings.getEntityDictionary().getScanner(), false);
    }

    public Elide(ElideSettings elideSettings, TransactionRegistry transactionRegistry) {
        this(elideSettings, transactionRegistry, elideSettings.getEntityDictionary().getScanner(), false);
    }

    public Elide(ElideSettings elideSettings, TransactionRegistry transactionRegistry, ClassScanner scanner, boolean doScans) {
        this.elideSettings = elideSettings;
        this.scanner = scanner;
        this.auditLogger = elideSettings.getAuditLogger();
        this.dataStore = new InMemoryDataStore(elideSettings.getDataStore());
        this.objectMapper = elideSettings.getObjectMapper();
        this.transactionRegistry = transactionRegistry;
        if (doScans) {
            this.doScans();
        }
    }

    public void doScans() {
        if (!this.initialized) {
            this.elideSettings.getSerdes().forEach((type, serde) -> this.registerCustomSerde((Class<?>)type, (Serde)serde, type.getSimpleName()));
            this.registerCustomSerde();
            this.elideSettings.getEntityDictionary().scanForSecurityChecks();
            this.dataStore.populateEntityDictionary(this.elideSettings.getEntityDictionary());
            this.initialized = true;
        }
    }

    protected void registerCustomSerde() {
        Injector injector = this.elideSettings.getEntityDictionary().getInjector();
        Set<Class<?>> classes = this.registerCustomSerdeScan();
        for (Class<?> clazz : classes) {
            if (!Serde.class.isAssignableFrom(clazz)) {
                log.warn("Skipping Serde registration (not a Serde!): {}", clazz);
                continue;
            }
            Serde serde = (Serde)injector.instantiate(clazz);
            injector.inject(serde);
            ElideTypeConverter converter = clazz.getAnnotation(ElideTypeConverter.class);
            Class<?> baseType = converter.type();
            this.registerCustomSerde(baseType, serde, converter.name());
            for (Class<?> type : converter.subTypes()) {
                if (!baseType.isAssignableFrom(type)) {
                    throw new IllegalArgumentException("Mentioned type " + type + " not subtype of " + baseType);
                }
                this.registerCustomSerde(type, serde, converter.name());
            }
        }
    }

    protected void registerCustomSerde(Class<?> type, Serde serde, String name) {
        log.info("Registering serde for type : {}", type);
        CoerceUtil.register(type, serde);
        this.registerCustomSerdeInObjectMapper(type, serde, name);
    }

    protected void registerCustomSerdeInObjectMapper(Class<?> type, final Serde serde, String name) {
        ObjectMapper objectMapper = this.objectMapper;
        objectMapper.registerModule((Module)new SimpleModule(name).addSerializer(type, (JsonSerializer)new JsonSerializer<Object>(){

            public void serialize(Object obj, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
                jsonGenerator.writeObject(serde.serialize(obj));
            }
        }));
    }

    protected Set<Class<?>> registerCustomSerdeScan() {
        return this.scanner.getAnnotatedClasses(ElideTypeConverter.class);
    }

    public <T extends Settings> T getSettings(Class<T> clazz) {
        return this.elideSettings.getSettings(clazz);
    }

    public ElideSettings getElideSettings() {
        return this.elideSettings;
    }

    public AuditLogger getAuditLogger() {
        return this.auditLogger;
    }

    public DataStore getDataStore() {
        return this.dataStore;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public TransactionRegistry getTransactionRegistry() {
        return this.transactionRegistry;
    }

    public ClassScanner getScanner() {
        return this.scanner;
    }
}

