/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.utils.coerce.converters;

import com.yahoo.elide.core.exceptions.InvalidAttributeException;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.lang3.ClassUtils;

public class ToEnumConverter
implements Converter {
    public <T> T convert(Class<T> cls, Object value) {
        try {
            if (ClassUtils.isAssignable(value.getClass(), String.class)) {
                return ToEnumConverter.stringToEnum(cls, (String)value);
            }
            if (ClassUtils.isAssignable(value.getClass(), Integer.class, (boolean)true)) {
                return ToEnumConverter.intToEnum(cls, (Integer)value);
            }
            throw new UnsupportedOperationException(value.getClass().getSimpleName() + " to Enum no supported");
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException | ReflectiveOperationException | UnsupportedOperationException e) {
            throw new InvalidAttributeException("Unknown " + cls.getSimpleName() + " value " + value, e);
        }
    }

    private static <T> T intToEnum(Class<?> cls, Integer value) throws ReflectiveOperationException {
        Object[] values = (Object[])cls.getMethod("values", new Class[0]).invoke(null, (Object[])null);
        return (T)values[value];
    }

    private static <T> T stringToEnum(Class<?> cls, String value) {
        return (T)Enum.valueOf(cls, value);
    }
}

