/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.exceptions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.yahoo.elide.core.exceptions.HttpStatusException;
import org.apache.commons.lang3.tuple.Pair;
import org.owasp.encoder.Encode;

public class JsonPatchExtensionException
extends HttpStatusException {
    private final Pair<Integer, JsonNode> response;

    public JsonPatchExtensionException(int status, JsonNode errorNode) {
        super(status, null);
        this.response = Pair.of((Object)status, (Object)errorNode);
    }

    @Deprecated
    public Pair<Integer, JsonNode> getResponse() {
        return this.response;
    }

    @Override
    public Pair<Integer, JsonNode> getErrorResponse() {
        return this.getErrorResponse(false);
    }

    @Override
    public Pair<Integer, JsonNode> getErrorResponse(boolean encodeResponse) {
        if (!encodeResponse) {
            return this.response;
        }
        return this.encodeResponse();
    }

    @Override
    public Pair<Integer, JsonNode> getVerboseErrorResponse() {
        return this.getVerboseErrorResponse(false);
    }

    @Override
    public Pair<Integer, JsonNode> getVerboseErrorResponse(boolean encodeResponse) {
        if (!encodeResponse) {
            return this.response;
        }
        return this.encodeResponse();
    }

    private Pair<Integer, JsonNode> encodeResponse() {
        ArrayNode encodedArray = JsonNodeFactory.instance.arrayNode();
        ArrayNode errors = (ArrayNode)((JsonNode)this.response.getRight()).get("errors");
        for (JsonNode node : errors) {
            ObjectNode objectNode = (ObjectNode)node;
            TextNode text = (TextNode)objectNode.get("detail");
            IntNode status = (IntNode)objectNode.get("status");
            ObjectNode encodedObjectNode = JsonNodeFactory.instance.objectNode();
            TextNode encodedTextNode = JsonNodeFactory.instance.textNode(Encode.forHtml((String)text.asText()));
            encodedObjectNode.set("detail", (JsonNode)encodedTextNode);
            encodedObjectNode.set("status", (JsonNode)status);
            encodedArray.add((JsonNode)encodedObjectNode);
        }
        return Pair.of((Object)this.response.getLeft(), (Object)encodedArray);
    }
}

