/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.exceptions;

import com.fasterxml.jackson.databind.JsonNode;
import com.yahoo.elide.core.ErrorObjects;
import com.yahoo.elide.core.exceptions.HttpStatusException;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;

public class CustomErrorException
extends HttpStatusException {
    private static final long serialVersionUID = 1L;
    private final ErrorObjects errorObjects;

    public CustomErrorException(int status, String message, ErrorObjects errorObjects) {
        this(status, message, null, errorObjects);
    }

    public CustomErrorException(int status, String message, Throwable cause, ErrorObjects errorObjects) {
        super(status, message, cause, null);
        this.errorObjects = Objects.requireNonNull(errorObjects, "errorObjects must not be null");
    }

    @Override
    public Pair<Integer, JsonNode> getErrorResponse(boolean encodeResponse) {
        return this.buildCustomResponse();
    }

    @Override
    public Pair<Integer, JsonNode> getVerboseErrorResponse(boolean encodeResponse) {
        return this.buildCustomResponse();
    }

    private Pair<Integer, JsonNode> buildCustomResponse() {
        JsonNode responseBody = (JsonNode)OBJECT_MAPPER.convertValue((Object)this.errorObjects, JsonNode.class);
        return Pair.of((Object)this.getStatus(), (Object)responseBody);
    }
}

