/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core;

import com.google.common.collect.ImmutableList;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.exceptions.InvalidValueException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class Path {
    private static final String PERIOD = ".";
    private static final String UNDERSCORE = "_";
    private List<PathElement> pathElements;

    public Path(Path copy) {
        this(copy.pathElements);
    }

    public Path(List<PathElement> pathElements) {
        this.pathElements = ImmutableList.copyOf(pathElements);
    }

    public Path(Class<?> entityClass, EntityDictionary dictionary, String dotSeparatedPath) {
        ArrayList<PathElement> elements = new ArrayList<PathElement>();
        String[] fieldNames = dotSeparatedPath.split("\\.");
        Class<?> currentClass = entityClass;
        for (String fieldName : fieldNames) {
            if (dictionary.isRelation(currentClass, fieldName)) {
                Class<?> relationClass = dictionary.getParameterizedType(currentClass, fieldName);
                elements.add(new PathElement(currentClass, relationClass, fieldName));
                currentClass = relationClass;
                continue;
            }
            if (dictionary.isAttribute(currentClass, fieldName) || fieldName.equals(dictionary.getIdFieldName(entityClass))) {
                Class<?> attributeClass = dictionary.getType(currentClass, fieldName);
                elements.add(new PathElement(currentClass, attributeClass, fieldName));
                continue;
            }
            if ("this".equals(fieldName)) {
                elements.add(new PathElement(currentClass, null, fieldName));
                continue;
            }
            String alias = dictionary.getJsonAliasFor(currentClass);
            throw new InvalidValueException((Object)(alias + " doesn't contain the field " + fieldName));
        }
        this.pathElements = ImmutableList.copyOf(elements);
    }

    public Optional<PathElement> lastElement() {
        return this.pathElements.isEmpty() ? Optional.empty() : Optional.of(this.pathElements.get(this.pathElements.size() - 1));
    }

    public String getFieldPath() {
        return this.pathElements.stream().map(PathElement::getFieldName).collect(Collectors.joining(PERIOD));
    }

    public String getAlias() {
        if (this.pathElements.size() < 2) {
            return this.lastElement().map(e -> Path.getTypeAlias(e.getType())).orElse(null);
        }
        PathElement previous = this.pathElements.get(this.pathElements.size() - 2);
        return Path.getTypeAlias(previous.getType()) + UNDERSCORE + previous.getFieldName();
    }

    public String toString() {
        return this.pathElements.size() == 0 ? "EMPTY" : this.pathElements.stream().map(e -> '[' + EntityDictionary.getSimpleName(e.getType()) + ']' + PERIOD + e.getFieldName()).collect(Collectors.joining("/"));
    }

    public static String getTypeAlias(Class<?> type) {
        return type.getCanonicalName().replace(PERIOD, UNDERSCORE);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Path)) {
            return false;
        }
        Path other = (Path)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<PathElement> this$pathElements = this.getPathElements();
        List<PathElement> other$pathElements = other.getPathElements();
        return !(this$pathElements == null ? other$pathElements != null : !((Object)this$pathElements).equals(other$pathElements));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Path;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<PathElement> $pathElements = this.getPathElements();
        result = result * 59 + ($pathElements == null ? 43 : ((Object)$pathElements).hashCode());
        return result;
    }

    public List<PathElement> getPathElements() {
        return this.pathElements;
    }

    public static class PathElement {
        private Class type;
        private Class fieldType;
        private String fieldName;

        public PathElement(Class type, Class fieldType, String fieldName) {
            this.type = type;
            this.fieldType = fieldType;
            this.fieldName = fieldName;
        }

        public String toString() {
            return "Path.PathElement(type=" + this.getType() + ", fieldType=" + this.getFieldType() + ", fieldName=" + this.getFieldName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PathElement)) {
                return false;
            }
            PathElement other = (PathElement)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class this$type = this.getType();
            Class other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Class this$fieldType = this.getFieldType();
            Class other$fieldType = other.getFieldType();
            if (this$fieldType == null ? other$fieldType != null : !this$fieldType.equals(other$fieldType)) {
                return false;
            }
            String this$fieldName = this.getFieldName();
            String other$fieldName = other.getFieldName();
            return !(this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PathElement;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Class $fieldType = this.getFieldType();
            result = result * 59 + ($fieldType == null ? 43 : $fieldType.hashCode());
            String $fieldName = this.getFieldName();
            result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
            return result;
        }

        public Class getType() {
            return this.type;
        }

        public Class getFieldType() {
            return this.fieldType;
        }

        public String getFieldName() {
            return this.fieldName;
        }
    }
}

