/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.audit;

import com.yahoo.elide.audit.LogMessage;
import com.yahoo.elide.core.RequestScope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class AuditLogger {
    protected final ThreadLocal<List<LogMessage>> messages = ThreadLocal.withInitial(ArrayList::new);

    public void log(LogMessage message) {
        this.messages.get().add(message);
    }

    public abstract void commit(RequestScope var1) throws IOException;

    public void clear() {
        List<LogMessage> remainingMessages = this.messages.get();
        if (remainingMessages != null) {
            remainingMessages.clear();
        }
    }
}

