/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.security.permissions;

import com.yahoo.elide.annotation.ReadPermission;
import com.yahoo.elide.core.CheckInstantiator;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.OrFilterExpression;
import com.yahoo.elide.parsers.expression.FilterExpressionNormalizationVisitor;
import com.yahoo.elide.parsers.expression.PermissionExpressionVisitor;
import com.yahoo.elide.parsers.expression.PermissionToFilterExpressionVisitor;
import com.yahoo.elide.security.ChangeSpec;
import com.yahoo.elide.security.PersistentResource;
import com.yahoo.elide.security.checks.Check;
import com.yahoo.elide.security.permissions.ExpressionResultCache;
import com.yahoo.elide.security.permissions.PermissionCondition;
import com.yahoo.elide.security.permissions.expressions.AnyFieldExpression;
import com.yahoo.elide.security.permissions.expressions.CheckExpression;
import com.yahoo.elide.security.permissions.expressions.Expression;
import com.yahoo.elide.security.permissions.expressions.OrExpression;
import com.yahoo.elide.security.permissions.expressions.SpecificFieldExpression;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;

public class PermissionExpressionBuilder
implements CheckInstantiator {
    private final EntityDictionary entityDictionary;
    private final ExpressionResultCache cache;
    private static final Expression SUCCESSFUL_EXPRESSION = OrExpression.SUCCESSFUL_EXPRESSION;
    public static final Expression FAIL_EXPRESSION = OrExpression.FAILURE_EXPRESSION;

    public PermissionExpressionBuilder(ExpressionResultCache cache, EntityDictionary dictionary) {
        this.cache = cache;
        this.entityDictionary = dictionary;
    }

    public <A extends Annotation> Expression buildSpecificFieldExpressions(PersistentResource resource, Class<A> annotationClass, String field, ChangeSpec changeSpec) {
        Class resourceClass = resource.getResourceClass();
        if (!this.entityDictionary.entityHasChecksForPermission(resourceClass, annotationClass)) {
            return SUCCESSFUL_EXPRESSION;
        }
        Function<Check, Expression> leafBuilderFn = this.leafBuilder(resource, changeSpec);
        Function<Function, Expression> buildExpressionFn = checkFn -> this.buildSpecificFieldExpression(PermissionCondition.create(annotationClass, resource, field, changeSpec), (Function<Check, Expression>)checkFn);
        return buildExpressionFn.apply(leafBuilderFn);
    }

    public <A extends Annotation> Expression buildAnyFieldExpressions(PersistentResource resource, Class<A> annotationClass, ChangeSpec changeSpec) {
        Class resourceClass = resource.getResourceClass();
        if (!this.entityDictionary.entityHasChecksForPermission(resourceClass, annotationClass)) {
            return SUCCESSFUL_EXPRESSION;
        }
        Function<Check, Expression> leafBuilderFn = this.leafBuilder(resource, changeSpec);
        Function<Function, Expression> expressionFunction = checkFn -> this.buildAnyFieldExpression(PermissionCondition.create(annotationClass, resource, null, changeSpec), (Function<Check, Expression>)checkFn, (RequestScope)resource.getRequestScope());
        return expressionFunction.apply(leafBuilderFn);
    }

    public <A extends Annotation> Expression buildUserCheckFieldExpressions(PersistentResource resource, Class<A> annotationClass, String field) {
        Class resourceClass = resource.getResourceClass();
        if (!this.entityDictionary.entityHasChecksForPermission(resourceClass, annotationClass)) {
            return SUCCESSFUL_EXPRESSION;
        }
        Function<Check, Expression> leafBuilderFn = this.leafBuilder(resource, null);
        return this.buildSpecificFieldExpression(new PermissionCondition(annotationClass, resource, field), leafBuilderFn);
    }

    public <A extends Annotation> Expression buildUserCheckAnyExpression(Class<?> resourceClass, Class<A> annotationClass, RequestScope requestScope) {
        Function<Check, Expression> leafBuilderFn = check -> new CheckExpression((Check)check, null, requestScope, null, this.cache);
        return this.buildAnyFieldExpression(new PermissionCondition(annotationClass, resourceClass), leafBuilderFn, requestScope);
    }

    private Expression buildSpecificFieldExpression(PermissionCondition condition, Function<Check, Expression> checkFn) {
        Class<?> resourceClass = condition.getEntityClass();
        Class<? extends Annotation> annotationClass = condition.getPermission();
        String field = condition.getField().isPresent() ? condition.getField().get() : null;
        ParseTree classPermissions = this.entityDictionary.getPermissionsForClass(resourceClass, annotationClass);
        ParseTree fieldPermissions = this.entityDictionary.getPermissionsForField(resourceClass, field, annotationClass);
        return new SpecificFieldExpression(condition, this.expressionFromParseTree(classPermissions, checkFn), this.expressionFromParseTree(fieldPermissions, checkFn));
    }

    private Expression buildAnyFieldExpression(PermissionCondition condition, Function<Check, Expression> checkFn, RequestScope scope) {
        Class<?> resourceClass = condition.getEntityClass();
        Class<? extends Annotation> annotationClass = condition.getPermission();
        ParseTree classPermissions = this.entityDictionary.getPermissionsForClass(resourceClass, annotationClass);
        Expression entityExpression = this.expressionFromParseTree(classPermissions, checkFn);
        OrExpression allFieldsExpression = new OrExpression(Expression.Results.FAILURE, null);
        List<String> fields = this.entityDictionary.getAllFields(resourceClass);
        Set<String> sparseFields = scope.getSparseFields().get(this.entityDictionary.getJsonAliasFor(resourceClass));
        for (String field : fields) {
            if (sparseFields != null && !sparseFields.contains(field)) continue;
            ParseTree fieldPermissions = this.entityDictionary.getPermissionsForField(resourceClass, field, annotationClass);
            Expression fieldExpression = this.expressionFromParseTree(fieldPermissions, checkFn);
            allFieldsExpression = new OrExpression(allFieldsExpression, fieldExpression);
        }
        return new AnyFieldExpression(condition, entityExpression, allFieldsExpression);
    }

    public FilterExpression buildAnyFieldFilterExpression(Class<?> forType, RequestScope requestScope) {
        Class<ReadPermission> annotationClass = ReadPermission.class;
        ParseTree classPermissions = this.entityDictionary.getPermissionsForClass(forType, annotationClass);
        FilterExpression entityFilter = this.filterExpressionFromParseTree(classPermissions, forType, requestScope);
        if (entityFilter == PermissionToFilterExpressionVisitor.FALSE_USER_CHECK_EXPRESSION || entityFilter == PermissionToFilterExpressionVisitor.NO_EVALUATION_EXPRESSION || entityFilter == PermissionToFilterExpressionVisitor.TRUE_USER_CHECK_EXPRESSION) {
            entityFilter = null;
        }
        Set<String> sparseFields = requestScope.getSparseFields().get(this.entityDictionary.getJsonAliasFor(forType));
        FilterExpression allFieldsFilterExpression = entityFilter;
        List fields = this.entityDictionary.getAllFields(forType).stream().filter(field -> sparseFields == null || sparseFields.contains(field)).collect(Collectors.toList());
        for (String field2 : fields) {
            ParseTree fieldPermissions = this.entityDictionary.getPermissionsForField(forType, field2, annotationClass);
            FilterExpression fieldExpression = this.filterExpressionFromParseTree(fieldPermissions, forType, requestScope);
            if (fieldExpression == null && entityFilter == null) {
                return null;
            }
            if (fieldExpression == null || fieldExpression == PermissionToFilterExpressionVisitor.FALSE_USER_CHECK_EXPRESSION) continue;
            if (fieldExpression == PermissionToFilterExpressionVisitor.NO_EVALUATION_EXPRESSION || fieldExpression == PermissionToFilterExpressionVisitor.TRUE_USER_CHECK_EXPRESSION) {
                return null;
            }
            if (allFieldsFilterExpression != null) {
                allFieldsFilterExpression = new OrFilterExpression(allFieldsFilterExpression, fieldExpression);
                continue;
            }
            allFieldsFilterExpression = fieldExpression;
        }
        return allFieldsFilterExpression;
    }

    private Expression expressionFromParseTree(ParseTree permissions, Function<Check, Expression> checkFn) {
        if (permissions == null) {
            return null;
        }
        return (Expression)new PermissionExpressionVisitor(this.entityDictionary, checkFn).visit(permissions);
    }

    private FilterExpression filterExpressionFromParseTree(ParseTree permissions, Class type, RequestScope scope) {
        if (permissions == null) {
            return null;
        }
        FilterExpression expression = (FilterExpression)new PermissionToFilterExpressionVisitor(this.entityDictionary, scope, type).visit(permissions);
        return expression.accept(new FilterExpressionNormalizationVisitor());
    }

    private Function<Check, Expression> leafBuilder(PersistentResource resource, ChangeSpec changeSpec) {
        Function<Check, Expression> leafBuilderFn = check -> new CheckExpression((Check)check, resource, resource.getRequestScope(), changeSpec, this.cache);
        return leafBuilderFn;
    }
}

