/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.security.executors;

import com.yahoo.elide.annotation.CreatePermission;
import com.yahoo.elide.annotation.DeletePermission;
import com.yahoo.elide.annotation.ReadPermission;
import com.yahoo.elide.annotation.SharePermission;
import com.yahoo.elide.annotation.UpdatePermission;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.exceptions.ForbiddenAccessException;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.security.ChangeSpec;
import com.yahoo.elide.security.PermissionExecutor;
import com.yahoo.elide.security.PersistentResource;
import com.yahoo.elide.security.permissions.ExpressionResult;
import com.yahoo.elide.security.permissions.ExpressionResultCache;
import com.yahoo.elide.security.permissions.PermissionExpressionBuilder;
import com.yahoo.elide.security.permissions.expressions.Expression;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivePermissionExecutor
implements PermissionExecutor {
    private static final Logger log = LoggerFactory.getLogger(ActivePermissionExecutor.class);
    private final Queue<QueuedCheck> commitCheckQueue = new LinkedBlockingQueue<QueuedCheck>();
    private final RequestScope requestScope;
    private final PermissionExpressionBuilder expressionBuilder;
    private final Map<Triple<Class<? extends Annotation>, Class, String>, ExpressionResult> userPermissionCheckCache;
    private final Map<String, Long> checkStats;
    private final boolean verbose;

    public ActivePermissionExecutor(RequestScope requestScope) {
        this(false, requestScope);
    }

    public ActivePermissionExecutor(boolean verbose, RequestScope requestScope) {
        ExpressionResultCache cache = new ExpressionResultCache();
        this.requestScope = requestScope;
        this.expressionBuilder = new PermissionExpressionBuilder(cache, requestScope.getDictionary());
        this.userPermissionCheckCache = new HashMap<Triple<Class<? extends Annotation>, Class, String>, ExpressionResult>();
        this.checkStats = new HashMap<String, Long>();
        this.verbose = verbose;
    }

    @Override
    public <A extends Annotation> ExpressionResult checkPermission(Class<A> annotationClass, PersistentResource resource) {
        return this.checkPermission(annotationClass, resource, null);
    }

    @Override
    public <A extends Annotation> ExpressionResult checkPermission(Class<A> annotationClass, PersistentResource resource, ChangeSpec changeSpec) {
        Supplier<Expression> expressionSupplier = () -> {
            if (SharePermission.class == annotationClass) {
                if (this.requestScope.getDictionary().isShareable(resource.getResourceClass())) {
                    return this.expressionBuilder.buildAnyFieldExpressions(resource, ReadPermission.class, changeSpec);
                }
                return PermissionExpressionBuilder.FAIL_EXPRESSION;
            }
            return this.expressionBuilder.buildAnyFieldExpressions(resource, annotationClass, changeSpec);
        };
        Function<Expression, ExpressionResult> expressionExecutor = expression -> {
            if (resource.isNewlyCreated()) {
                return this.executeUserChecksDeferInline(annotationClass, (Expression)expression);
            }
            return this.executeExpressions((Expression)expression, annotationClass, Expression.EvaluationMode.INLINE_CHECKS_ONLY);
        };
        return this.checkPermissions(resource.getResourceClass(), annotationClass, Optional.empty(), expressionSupplier, expressionExecutor);
    }

    private <A extends Annotation> ExpressionResult executeUserChecksDeferInline(Class<A> annotationClass, Expression expression) {
        ExpressionResult result = this.executeExpressions(expression, annotationClass, Expression.EvaluationMode.USER_CHECKS_ONLY);
        if (result == ExpressionResult.DEFERRED) {
            this.commitCheckQueue.add(new QueuedCheck(expression, annotationClass));
        }
        return result;
    }

    @Override
    public <A extends Annotation> ExpressionResult checkSpecificFieldPermissions(PersistentResource<?> resource, ChangeSpec changeSpec, Class<A> annotationClass, String field) {
        Supplier<Expression> expressionSupplier = () -> this.expressionBuilder.buildSpecificFieldExpressions(resource, annotationClass, field, changeSpec);
        Function<Expression, ExpressionResult> expressionExecutor = expression -> this.executeExpressions((Expression)expression, annotationClass, Expression.EvaluationMode.INLINE_CHECKS_ONLY);
        return this.checkPermissions(resource.getResourceClass(), annotationClass, Optional.of(field), expressionSupplier, expressionExecutor);
    }

    @Override
    public <A extends Annotation> ExpressionResult checkSpecificFieldPermissionsDeferred(PersistentResource<?> resource, ChangeSpec changeSpec, Class<A> annotationClass, String field) {
        Class expressionAnnotation = annotationClass.isAssignableFrom(UpdatePermission.class) && this.requestScope.getNewResources().contains(resource) ? CreatePermission.class : annotationClass;
        Supplier<Expression> expressionSupplier = () -> this.expressionBuilder.buildSpecificFieldExpressions(resource, expressionAnnotation, field, changeSpec);
        Function<Expression, ExpressionResult> expressionExecutor = expression -> {
            if (this.requestScope.getNewPersistentResources().contains(resource)) {
                return this.executeUserChecksDeferInline(expressionAnnotation, (Expression)expression);
            }
            return this.executeExpressions((Expression)expression, expressionAnnotation, Expression.EvaluationMode.INLINE_CHECKS_ONLY);
        };
        return this.checkPermissions(resource.getResourceClass(), expressionAnnotation, Optional.of(field), expressionSupplier, expressionExecutor);
    }

    @Override
    public <A extends Annotation> ExpressionResult checkUserPermissions(Class<?> resourceClass, Class<A> annotationClass) {
        Supplier<Expression> expressionSupplier = () -> this.expressionBuilder.buildUserCheckAnyExpression(resourceClass, annotationClass, this.requestScope);
        return this.checkOnlyUserPermissions(resourceClass, annotationClass, Optional.empty(), expressionSupplier);
    }

    protected <A extends Annotation> ExpressionResult checkPermissions(Class<?> resourceClass, Class<A> annotationClass, Optional<String> field, Supplier<Expression> expressionSupplier, Optional<Function<Expression, ExpressionResult>> expressionExecutor) {
        ExpressionResult expressionResult = this.userPermissionCheckCache.get(Triple.of(annotationClass, resourceClass, field.orElse(null)));
        if (expressionResult == ExpressionResult.PASS) {
            return expressionResult;
        }
        Expression expression = expressionSupplier.get();
        if (expressionResult == null) {
            expressionResult = this.executeExpressions(expression, annotationClass, Expression.EvaluationMode.USER_CHECKS_ONLY);
            this.userPermissionCheckCache.put((Triple<Class<? extends Annotation>, Class, String>)Triple.of(annotationClass, resourceClass, field.orElse(null)), expressionResult);
            if (expressionResult == ExpressionResult.PASS) {
                return expressionResult;
            }
        }
        return expressionExecutor.map(executor -> (ExpressionResult)((Object)((Object)executor.apply(expression)))).orElse(expressionResult);
    }

    protected <A extends Annotation> ExpressionResult checkOnlyUserPermissions(Class<?> resourceClass, Class<A> annotationClass, Optional<String> field, Supplier<Expression> expressionSupplier) {
        return this.checkPermissions(resourceClass, annotationClass, field, expressionSupplier, Optional.empty());
    }

    protected <A extends Annotation> ExpressionResult checkPermissions(Class<?> resourceClass, Class<A> annotationClass, Optional<String> field, Supplier<Expression> expressionSupplier, Function<Expression, ExpressionResult> expressionExecutor) {
        return this.checkPermissions(resourceClass, annotationClass, field, expressionSupplier, Optional.of(expressionExecutor));
    }

    @Override
    public Optional<FilterExpression> getReadPermissionFilter(Class<?> resourceClass) {
        FilterExpression filterExpression = this.expressionBuilder.buildAnyFieldFilterExpression(resourceClass, this.requestScope);
        return Optional.ofNullable(filterExpression);
    }

    @Override
    public void executeCommitChecks() {
        this.commitCheckQueue.forEach(expr -> {
            Expression expression = expr.getExpression();
            ExpressionResult result = expression.evaluate(Expression.EvaluationMode.ALL_CHECKS);
            if (result == ExpressionResult.FAIL) {
                ForbiddenAccessException e = new ForbiddenAccessException(EntityDictionary.getSimpleName(expr.getAnnotationClass()), expression, Expression.EvaluationMode.ALL_CHECKS);
                if (log.isTraceEnabled()) {
                    log.trace("{}", (Object)e.getLoggedMessage());
                }
                throw e;
            }
        });
        this.commitCheckQueue.clear();
    }

    private ExpressionResult executeExpressions(Expression expression, Class<? extends Annotation> annotationClass, Expression.EvaluationMode mode) {
        ForbiddenAccessException e;
        ExpressionResult result = expression.evaluate(mode);
        if (log.isTraceEnabled()) {
            String checkKey = expression.toString();
            Long checkOccurrences = this.checkStats.getOrDefault(checkKey, 0L) + 1L;
            this.checkStats.put(checkKey, checkOccurrences);
        }
        if (result == ExpressionResult.DEFERRED) {
            if (mode == Expression.EvaluationMode.USER_CHECKS_ONLY) {
                return ExpressionResult.DEFERRED;
            }
            if (this.isInlineOnlyCheck(annotationClass)) {
                result = expression.evaluate(Expression.EvaluationMode.ALL_CHECKS);
                if (result == ExpressionResult.FAIL) {
                    e = new ForbiddenAccessException(EntityDictionary.getSimpleName(annotationClass), expression, Expression.EvaluationMode.ALL_CHECKS);
                    if (log.isTraceEnabled()) {
                        log.trace("{}", (Object)e.getLoggedMessage());
                    }
                    throw e;
                }
            } else {
                this.commitCheckQueue.add(new QueuedCheck(expression, annotationClass));
            }
            return ExpressionResult.DEFERRED;
        }
        if (result == ExpressionResult.FAIL) {
            e = new ForbiddenAccessException(EntityDictionary.getSimpleName(annotationClass), expression, mode);
            if (log.isTraceEnabled()) {
                log.trace("{}", (Object)e.getLoggedMessage());
            }
            throw e;
        }
        return result;
    }

    private boolean isInlineOnlyCheck(Class<? extends Annotation> annotationClass) {
        return ReadPermission.class.isAssignableFrom(annotationClass) || DeletePermission.class.isAssignableFrom(annotationClass);
    }

    @Override
    public String printCheckStats() {
        if (log.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder("Permission Check Statistics:\n");
            this.checkStats.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEachOrdered(e -> sb.append((String)e.getKey() + ": " + e.getValue() + "\n"));
            String stats = sb.toString();
            log.trace(stats);
            return stats;
        }
        return null;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    private static class QueuedCheck {
        private final Expression expression;
        private final Class<? extends Annotation> annotationClass;

        public QueuedCheck(Expression expression, Class<? extends Annotation> annotationClass) {
            this.expression = expression;
            this.annotationClass = annotationClass;
        }

        public Expression getExpression() {
            return this.expression;
        }

        public Class<? extends Annotation> getAnnotationClass() {
            return this.annotationClass;
        }
    }
}

