/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.parsers.expression;

import com.yahoo.elide.annotation.ReadPermission;
import com.yahoo.elide.core.CheckInstantiator;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.generated.parsers.ExpressionBaseVisitor;
import com.yahoo.elide.generated.parsers.ExpressionParser;
import com.yahoo.elide.security.FilterExpressionCheck;
import com.yahoo.elide.security.checks.Check;
import com.yahoo.elide.security.checks.UserCheck;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.tree.ParseTree;

public class CanPaginateVisitor
extends ExpressionBaseVisitor<PaginationStatus>
implements CheckInstantiator {
    private final EntityDictionary dictionary;
    private final RequestScope scope;

    public CanPaginateVisitor(EntityDictionary dictionary, RequestScope scope) {
        this.dictionary = dictionary;
        this.scope = scope;
    }

    @Override
    public PaginationStatus visitNOT(ExpressionParser.NOTContext ctx) {
        PaginationStatus status = (PaginationStatus)((Object)this.visit((ParseTree)ctx.expression()));
        if (status == PaginationStatus.USER_CHECK_FALSE) {
            return PaginationStatus.USER_CHECK_TRUE;
        }
        if (status == PaginationStatus.USER_CHECK_TRUE) {
            return PaginationStatus.USER_CHECK_FALSE;
        }
        return status;
    }

    @Override
    public PaginationStatus visitOR(ExpressionParser.ORContext ctx) {
        PaginationStatus lhs = (PaginationStatus)((Object)this.visit((ParseTree)ctx.left));
        PaginationStatus rhs = (PaginationStatus)((Object)this.visit((ParseTree)ctx.right));
        if (lhs == PaginationStatus.USER_CHECK_TRUE || rhs == PaginationStatus.USER_CHECK_TRUE) {
            return PaginationStatus.USER_CHECK_TRUE;
        }
        if (rhs == PaginationStatus.CANNOT_PAGINATE || lhs == PaginationStatus.CANNOT_PAGINATE) {
            return PaginationStatus.CANNOT_PAGINATE;
        }
        return PaginationStatus.CAN_PAGINATE;
    }

    @Override
    public PaginationStatus visitAND(ExpressionParser.ANDContext ctx) {
        PaginationStatus lhs = (PaginationStatus)((Object)this.visit((ParseTree)ctx.left));
        PaginationStatus rhs = (PaginationStatus)((Object)this.visit((ParseTree)ctx.right));
        if (lhs == PaginationStatus.USER_CHECK_FALSE || rhs == PaginationStatus.USER_CHECK_FALSE) {
            return PaginationStatus.USER_CHECK_FALSE;
        }
        if (rhs == PaginationStatus.CANNOT_PAGINATE || lhs == PaginationStatus.CANNOT_PAGINATE) {
            return PaginationStatus.CANNOT_PAGINATE;
        }
        return PaginationStatus.CAN_PAGINATE;
    }

    @Override
    public PaginationStatus visitPAREN(ExpressionParser.PARENContext ctx) {
        return (PaginationStatus)((Object)this.visit((ParseTree)ctx.expression()));
    }

    @Override
    public PaginationStatus visitPermissionClass(ExpressionParser.PermissionClassContext ctx) {
        Check check = this.getCheck(this.dictionary, ctx.getText());
        if (check instanceof FilterExpressionCheck) {
            return PaginationStatus.CAN_PAGINATE;
        }
        if (check instanceof UserCheck) {
            if (check.ok(this.scope.getUser())) {
                return PaginationStatus.USER_CHECK_TRUE;
            }
            return PaginationStatus.USER_CHECK_FALSE;
        }
        return PaginationStatus.CANNOT_PAGINATE;
    }

    public static boolean canPaginate(Class<?> resourceClass, EntityDictionary dictionary, RequestScope scope) {
        CanPaginateVisitor visitor = new CanPaginateVisitor(dictionary, scope);
        Class<ReadPermission> annotationClass = ReadPermission.class;
        ParseTree classPermissions = dictionary.getPermissionsForClass(resourceClass, annotationClass);
        PaginationStatus canPaginateClass = PaginationStatus.CAN_PAGINATE;
        if (classPermissions != null) {
            canPaginateClass = (PaginationStatus)((Object)visitor.visit(classPermissions));
        }
        List<String> fields = dictionary.getAllFields(resourceClass);
        String resourceName = dictionary.getJsonAliasFor(resourceClass);
        Set<String> requestedFields = scope.getSparseFields().getOrDefault(resourceName, Collections.EMPTY_SET);
        boolean canPaginate = true;
        for (String field : fields) {
            if (!requestedFields.isEmpty() && !requestedFields.contains(field)) continue;
            PaginationStatus canPaginateField = canPaginateClass;
            ParseTree fieldPermissions = dictionary.getPermissionsForField(resourceClass, field, annotationClass);
            if (fieldPermissions != null) {
                canPaginateField = (PaginationStatus)((Object)visitor.visit(fieldPermissions));
            }
            if (canPaginateField == PaginationStatus.USER_CHECK_TRUE) {
                return true;
            }
            if (canPaginateField != PaginationStatus.CANNOT_PAGINATE) continue;
            canPaginate = false;
        }
        return canPaginate;
    }

    public static enum PaginationStatus {
        CAN_PAGINATE,
        USER_CHECK_FALSE,
        USER_CHECK_TRUE,
        CANNOT_PAGINATE;

    }
}

