/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.jsonapi.models;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.yahoo.elide.core.RelationshipType;
import com.yahoo.elide.jsonapi.models.ResourceIdentifier;
import com.yahoo.elide.jsonapi.models.SingleElementSet;
import com.yahoo.elide.jsonapi.serialization.DataDeserializer;
import com.yahoo.elide.jsonapi.serialization.DataSerializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

@JsonSerialize(using=DataSerializer.class)
@JsonDeserialize(using=DataDeserializer.class)
public class Data<T> {
    private final Collection<T> values;
    private final RelationshipType relationshipType;

    public Data(T value) {
        this.values = new SingleElementSet<T>(value);
        this.relationshipType = RelationshipType.MANY_TO_ONE;
    }

    public Data(Collection<T> values) {
        this.values = values;
        this.relationshipType = RelationshipType.MANY_TO_MANY;
    }

    public void sort(Comparator<T> sortFunction) {
        if (this.values instanceof List) {
            ((List)this.values).sort(sortFunction);
        } else {
            ArrayList<T> sortedList = new ArrayList<T>(this.values);
            sortedList.sort(sortFunction);
            this.values.clear();
            this.values.addAll(sortedList);
        }
    }

    public Collection<T> get() {
        return this.values;
    }

    public boolean isToOne() {
        return this.relationshipType.isToOne();
    }

    public T getSingleValue() {
        if (this.isToOne()) {
            return ((SingleElementSet)this.values).getValue();
        }
        throw new IllegalAccessError("Data is not toOne");
    }

    public Collection<ResourceIdentifier> toResourceIdentifiers() {
        return this.get().stream().map(object -> object != null ? object.toResourceIdentifier() : null).collect(Collectors.toList());
    }

    public String toString() {
        return "Data(values=" + this.values + ", relationshipType=" + (Object)((Object)this.relationshipType) + ")";
    }
}

