/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.sort;

import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.exceptions.InvalidValueException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.core.MultivaluedMap;

public class Sorting {
    private final Map<String, SortOrder> sortRules = new LinkedHashMap<String, SortOrder>();
    private static final Sorting DEFAULT_EMPTY_INSTANCE = null;
    private static final String JSONAPI_ID_KEYWORD = "id";

    public Sorting(Map<String, SortOrder> sortingRules) {
        if (sortingRules != null) {
            this.sortRules.putAll(sortingRules);
        }
    }

    public <T> Map<Path, SortOrder> getValidSortingRules(Class<T> entityClass, EntityDictionary dictionary) throws InvalidValueException {
        LinkedHashMap<Path, SortOrder> returnMap = new LinkedHashMap<Path, SortOrder>();
        for (Map.Entry<String, SortOrder> entry : this.replaceIdRule(dictionary.getIdFieldName(entityClass)).entrySet()) {
            String dotSeparatedPath = entry.getKey();
            SortOrder order = entry.getValue();
            Path path = new Path(entityClass, dictionary, dotSeparatedPath);
            if (!Sorting.isValidSortRulePath(path, dictionary)) {
                throw new InvalidValueException((Object)("Cannot sort across a to-many relationship: " + path.getFieldPath()));
            }
            returnMap.put(path, order);
        }
        return returnMap;
    }

    protected static boolean isValidSortRulePath(Path path, EntityDictionary dictionary) {
        for (Path.PathElement pathElement : path.getPathElements()) {
            if (!dictionary.isRelation(pathElement.getType(), pathElement.getFieldName()) || !dictionary.getRelationshipType(pathElement.getType(), pathElement.getFieldName()).isToMany()) continue;
            return false;
        }
        return true;
    }

    public boolean isDefaultInstance() {
        return this.sortRules.isEmpty();
    }

    public static Sorting parseQueryParams(MultivaluedMap<String, String> queryParams) {
        List<String> sortRules = queryParams.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals("sort")).map(entry -> (String)((List)entry.getValue()).get(0)).collect(Collectors.toList());
        return Sorting.parseSortRules(sortRules);
    }

    public static Sorting parseSortRule(String sortRule) {
        return Sorting.parseSortRules(Arrays.asList(sortRule));
    }

    private static Sorting parseSortRules(List<String> sortRules) {
        LinkedHashMap<String, SortOrder> sortingRules = new LinkedHashMap<String, SortOrder>();
        for (String sortRule : sortRules) {
            if (sortRule.contains(",")) {
                for (String sortRuleSplit : sortRule.split(",")) {
                    Sorting.parseSortRule(sortRuleSplit, sortingRules);
                }
                continue;
            }
            Sorting.parseSortRule(sortRule, sortingRules);
        }
        return sortingRules.isEmpty() ? DEFAULT_EMPTY_INSTANCE : new Sorting(sortingRules);
    }

    private static void parseSortRule(String sortRule, Map<String, SortOrder> sortingRules) {
        boolean isDesc = false;
        char firstCharacter = sortRule.charAt(0);
        if (firstCharacter == '-') {
            isDesc = true;
            sortRule = sortRule.substring(1);
        }
        if (firstCharacter == '+') {
            sortRule = sortRule.substring(1);
        }
        sortingRules.put(sortRule, isDesc ? SortOrder.desc : SortOrder.asc);
    }

    private LinkedHashMap<String, SortOrder> replaceIdRule(String idFieldName) {
        LinkedHashMap<String, SortOrder> result = new LinkedHashMap<String, SortOrder>();
        for (Map.Entry<String, SortOrder> entry : this.sortRules.entrySet()) {
            String key = entry.getKey();
            SortOrder value = entry.getValue();
            if (JSONAPI_ID_KEYWORD.equals(key)) {
                result.put(idFieldName, value);
                continue;
            }
            result.put(key, value);
        }
        return result;
    }

    public static Sorting getDefaultEmptyInstance() {
        return DEFAULT_EMPTY_INSTANCE;
    }

    public String toString() {
        return "Sorting(sortRules=" + this.sortRules + ")";
    }

    public static enum SortOrder {
        asc,
        desc;

    }
}

