/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core.filter.expression;

import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.filter.FilterPredicate;
import com.yahoo.elide.core.filter.expression.AndFilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpressionVisitor;
import com.yahoo.elide.core.filter.expression.NotFilterExpression;
import com.yahoo.elide.core.filter.expression.OrFilterExpression;

public class ExpressionScopingVisitor
implements FilterExpressionVisitor<FilterExpression> {
    Path.PathElement scope;

    public ExpressionScopingVisitor(Path.PathElement scope) {
        this.scope = scope;
    }

    @Override
    public FilterExpression visitPredicate(FilterPredicate filterPredicate) {
        return filterPredicate.scopedBy(this.scope);
    }

    @Override
    public FilterExpression visitAndExpression(AndFilterExpression expression) {
        return new AndFilterExpression(expression.getLeft().accept(this), expression.getRight().accept(this));
    }

    @Override
    public FilterExpression visitOrExpression(OrFilterExpression expression) {
        return new OrFilterExpression(expression.getLeft().accept(this), expression.getRight().accept(this));
    }

    @Override
    public FilterExpression visitNotExpression(NotFilterExpression expression) {
        return new NotFilterExpression(expression.getNegated().accept(this));
    }
}

