/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.core;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.yahoo.elide.annotation.ComputedAttribute;
import com.yahoo.elide.annotation.ComputedRelationship;
import com.yahoo.elide.annotation.Exclude;
import com.yahoo.elide.annotation.OnCreatePostCommit;
import com.yahoo.elide.annotation.OnCreatePreCommit;
import com.yahoo.elide.annotation.OnCreatePreSecurity;
import com.yahoo.elide.annotation.OnDeletePostCommit;
import com.yahoo.elide.annotation.OnDeletePreCommit;
import com.yahoo.elide.annotation.OnDeletePreSecurity;
import com.yahoo.elide.annotation.OnReadPostCommit;
import com.yahoo.elide.annotation.OnReadPreCommit;
import com.yahoo.elide.annotation.OnReadPreSecurity;
import com.yahoo.elide.annotation.OnUpdatePostCommit;
import com.yahoo.elide.annotation.OnUpdatePreCommit;
import com.yahoo.elide.annotation.OnUpdatePreSecurity;
import com.yahoo.elide.annotation.ToMany;
import com.yahoo.elide.annotation.ToOne;
import com.yahoo.elide.core.EntityDictionary;
import com.yahoo.elide.core.EntityPermissions;
import com.yahoo.elide.core.Initializer;
import com.yahoo.elide.core.RelationshipType;
import com.yahoo.elide.core.exceptions.DuplicateMappingException;
import com.yahoo.elide.functions.LifeCycleHook;
import com.yahoo.elide.security.RequestScope;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapsId;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.apache.commons.lang3.tuple.Pair;

public class EntityBinding {
    private static final List<Method> OBJ_METHODS = ImmutableList.copyOf((Object[])Object.class.getMethods());
    private static final List<Class<? extends Annotation>> RELATIONSHIP_TYPES = Arrays.asList(ManyToMany.class, ManyToOne.class, OneToMany.class, OneToOne.class, ToOne.class, ToMany.class);
    public final Class<?> entityClass;
    public final String jsonApiType;
    public final String entityName;
    public boolean idGenerated;
    private AccessibleObject idField;
    private String idFieldName;
    private Class<?> idType;
    private Initializer initializer;
    private AccessType accessType;
    public final EntityPermissions entityPermissions;
    public final List<String> attributes;
    public final List<String> relationships;
    public final List<Class<?>> inheritedTypes;
    public final ConcurrentLinkedDeque<String> attributesDeque = new ConcurrentLinkedDeque();
    public final ConcurrentLinkedDeque<String> relationshipsDeque = new ConcurrentLinkedDeque();
    public final ConcurrentHashMap<String, RelationshipType> relationshipTypes = new ConcurrentHashMap();
    public final ConcurrentHashMap<String, String> relationshipToInverse = new ConcurrentHashMap();
    public final ConcurrentHashMap<String, CascadeType[]> relationshipToCascadeTypes = new ConcurrentHashMap();
    public final ConcurrentHashMap<String, AccessibleObject> fieldsToValues = new ConcurrentHashMap();
    public final MultiValuedMap<Pair<Class, String>, LifeCycleHook> fieldsToTriggers = new HashSetValuedHashMap();
    public final MultiValuedMap<Class, LifeCycleHook> classToTriggers = new HashSetValuedHashMap();
    public final ConcurrentHashMap<String, Class<?>> fieldsToTypes = new ConcurrentHashMap();
    public final ConcurrentHashMap<String, String> aliasesToFields = new ConcurrentHashMap();
    public final ConcurrentHashMap<Method, Boolean> requestScopeableMethods = new ConcurrentHashMap();
    public final ConcurrentHashMap<Class<? extends Annotation>, Annotation> annotations = new ConcurrentHashMap();
    public static final EntityBinding EMPTY_BINDING = new EntityBinding();
    private static final String ALL_FIELDS = "*";
    private static final Annotation NO_ANNOTATION = new Annotation(){

        @Override
        public Class<? extends Annotation> annotationType() {
            return null;
        }
    };

    private EntityBinding() {
        this.jsonApiType = null;
        this.entityName = null;
        this.attributes = new ArrayList<String>();
        this.relationships = new ArrayList<String>();
        this.inheritedTypes = new ArrayList();
        this.idField = null;
        this.idType = null;
        this.entityClass = null;
        this.entityPermissions = EntityPermissions.EMPTY_PERMISSIONS;
        this.idGenerated = false;
    }

    public EntityBinding(EntityDictionary dictionary, Class<?> cls, String type, String name) {
        this.entityClass = cls;
        this.jsonApiType = type;
        this.entityName = name;
        this.inheritedTypes = this.getInheritedTypes(cls);
        List<AccessibleObject> fieldOrMethodList = this.getAllFields();
        if (fieldOrMethodList.stream().anyMatch(field -> field.isAnnotationPresent(Id.class))) {
            this.accessType = AccessType.FIELD;
            fieldOrMethodList.addAll(this.getInstanceMembers(cls.getMethods(), method -> method.isAnnotationPresent(ComputedAttribute.class) || method.isAnnotationPresent(ComputedRelationship.class) || method.isAnnotationPresent(OnReadPreSecurity.class) || method.isAnnotationPresent(OnReadPreCommit.class) || method.isAnnotationPresent(OnReadPostCommit.class) || method.isAnnotationPresent(OnUpdatePreSecurity.class) || method.isAnnotationPresent(OnUpdatePreCommit.class) || method.isAnnotationPresent(OnUpdatePostCommit.class) || method.isAnnotationPresent(OnCreatePreSecurity.class) || method.isAnnotationPresent(OnCreatePreCommit.class) || method.isAnnotationPresent(OnCreatePostCommit.class) || method.isAnnotationPresent(OnDeletePreSecurity.class) || method.isAnnotationPresent(OnDeletePreCommit.class) || method.isAnnotationPresent(OnDeletePostCommit.class)));
            fieldOrMethodList.forEach(field -> field.setAccessible(true));
        } else {
            this.accessType = AccessType.PROPERTY;
            fieldOrMethodList.clear();
            fieldOrMethodList.addAll(this.getInstanceMembers(cls.getFields()));
            fieldOrMethodList.addAll(this.getInstanceMembers(cls.getMethods()));
        }
        this.bindEntityFields(cls, type, fieldOrMethodList);
        this.attributes = EntityBinding.dequeToList(this.attributesDeque);
        this.relationships = EntityBinding.dequeToList(this.relationshipsDeque);
        this.entityPermissions = new EntityPermissions(dictionary, cls, fieldOrMethodList);
    }

    private <T extends Member> List<T> getInstanceMembers(T[] objects) {
        return this.getInstanceMembers((Member[])objects, o -> true);
    }

    private <T extends Member> List<T> getInstanceMembers(T[] objects, Predicate<T> filteredBy) {
        return Arrays.stream(objects).filter(o -> !Modifier.isStatic(o.getModifiers())).filter(filteredBy).collect(Collectors.toList());
    }

    public List<AccessibleObject> getAllFields() {
        ArrayList<AccessibleObject> fields = new ArrayList<AccessibleObject>();
        fields.addAll(this.getInstanceMembers(this.entityClass.getDeclaredFields(), field -> !field.isSynthetic()));
        for (Class<?> type : this.inheritedTypes) {
            fields.addAll(this.getInstanceMembers(type.getDeclaredFields(), field -> !field.isSynthetic()));
        }
        return fields;
    }

    private void bindEntityFields(Class<?> cls, String type, Collection<AccessibleObject> fieldOrMethodList) {
        for (AccessibleObject fieldOrMethod : fieldOrMethodList) {
            this.bindTriggerIfPresent(OnCreatePreSecurity.class, fieldOrMethod);
            this.bindTriggerIfPresent(OnDeletePreSecurity.class, fieldOrMethod);
            this.bindTriggerIfPresent(OnUpdatePreSecurity.class, fieldOrMethod);
            this.bindTriggerIfPresent(OnReadPreSecurity.class, fieldOrMethod);
            this.bindTriggerIfPresent(OnCreatePreCommit.class, fieldOrMethod);
            this.bindTriggerIfPresent(OnDeletePreCommit.class, fieldOrMethod);
            this.bindTriggerIfPresent(OnUpdatePreCommit.class, fieldOrMethod);
            this.bindTriggerIfPresent(OnReadPreCommit.class, fieldOrMethod);
            this.bindTriggerIfPresent(OnCreatePostCommit.class, fieldOrMethod);
            this.bindTriggerIfPresent(OnDeletePostCommit.class, fieldOrMethod);
            this.bindTriggerIfPresent(OnUpdatePostCommit.class, fieldOrMethod);
            this.bindTriggerIfPresent(OnReadPostCommit.class, fieldOrMethod);
            if (fieldOrMethod.isAnnotationPresent(Id.class)) {
                this.bindEntityId(cls, type, fieldOrMethod);
                continue;
            }
            if (fieldOrMethod.isAnnotationPresent(Transient.class) && !fieldOrMethod.isAnnotationPresent(ComputedAttribute.class) && !fieldOrMethod.isAnnotationPresent(ComputedRelationship.class) || fieldOrMethod.isAnnotationPresent(Exclude.class) || fieldOrMethod instanceof Field && Modifier.isTransient(((Field)fieldOrMethod).getModifiers()) || fieldOrMethod instanceof Method && Modifier.isTransient(((Method)fieldOrMethod).getModifiers()) || fieldOrMethod instanceof Field && !fieldOrMethod.isAnnotationPresent(Column.class) && Modifier.isStatic(((Field)fieldOrMethod).getModifiers())) continue;
            this.bindAttrOrRelation(fieldOrMethod);
        }
    }

    private void bindEntityId(Class<?> cls, String type, AccessibleObject fieldOrMethod) {
        String fieldName = EntityBinding.getFieldName(fieldOrMethod);
        Class<?> fieldType = EntityBinding.getFieldType(cls, fieldOrMethod);
        this.fieldsToTypes.put(fieldName, fieldType);
        this.idField = fieldOrMethod;
        this.idType = fieldType;
        this.idFieldName = fieldName;
        this.fieldsToValues.put(fieldName, fieldOrMethod);
        if (this.idField != null && !fieldOrMethod.equals(this.idField)) {
            throw new DuplicateMappingException(type + " " + cls.getName() + ":" + fieldName);
        }
        if (fieldOrMethod.isAnnotationPresent(GeneratedValue.class)) {
            this.idGenerated = true;
        }
    }

    private static List<String> dequeToList(Deque<String> deque) {
        ArrayList result = new ArrayList();
        deque.stream().forEachOrdered(result::add);
        result.sort(String.CASE_INSENSITIVE_ORDER);
        return Collections.unmodifiableList(result);
    }

    private void bindAttrOrRelation(AccessibleObject fieldOrMethod) {
        boolean isRelation = RELATIONSHIP_TYPES.stream().anyMatch(fieldOrMethod::isAnnotationPresent);
        String fieldName = EntityBinding.getFieldName(fieldOrMethod);
        Class<?> fieldType = EntityBinding.getFieldType(this.entityClass, fieldOrMethod);
        if (fieldName == null || "id".equals(fieldName) || "class".equals(fieldName) || OBJ_METHODS.contains(fieldOrMethod)) {
            return;
        }
        if (fieldOrMethod instanceof Method) {
            Method method = (Method)fieldOrMethod;
            this.requestScopeableMethods.put(method, EntityBinding.isRequestScopeableMethod(method));
        }
        if (isRelation) {
            this.bindRelation(fieldOrMethod, fieldName, fieldType);
        } else {
            this.bindAttr(fieldOrMethod, fieldName, fieldType);
        }
    }

    private void bindRelation(AccessibleObject fieldOrMethod, String fieldName, Class<?> fieldType) {
        RelationshipType type;
        boolean manyToMany = fieldOrMethod.isAnnotationPresent(ManyToMany.class);
        boolean manyToOne = fieldOrMethod.isAnnotationPresent(ManyToOne.class);
        boolean oneToMany = fieldOrMethod.isAnnotationPresent(OneToMany.class);
        boolean oneToOne = fieldOrMethod.isAnnotationPresent(OneToOne.class);
        boolean toOne = fieldOrMethod.isAnnotationPresent(ToOne.class);
        boolean toMany = fieldOrMethod.isAnnotationPresent(ToMany.class);
        boolean computedRelationship = fieldOrMethod.isAnnotationPresent(ComputedRelationship.class);
        if (fieldOrMethod.isAnnotationPresent(MapsId.class)) {
            this.idGenerated = true;
        }
        String mappedBy = "";
        CascadeType[] cascadeTypes = new CascadeType[]{};
        if (oneToMany) {
            type = computedRelationship ? RelationshipType.COMPUTED_ONE_TO_MANY : RelationshipType.ONE_TO_MANY;
            mappedBy = fieldOrMethod.getAnnotation(OneToMany.class).mappedBy();
            cascadeTypes = fieldOrMethod.getAnnotation(OneToMany.class).cascade();
        } else if (oneToOne) {
            type = computedRelationship ? RelationshipType.COMPUTED_ONE_TO_ONE : RelationshipType.ONE_TO_ONE;
            mappedBy = fieldOrMethod.getAnnotation(OneToOne.class).mappedBy();
            cascadeTypes = fieldOrMethod.getAnnotation(OneToOne.class).cascade();
        } else if (manyToMany) {
            type = computedRelationship ? RelationshipType.COMPUTED_MANY_TO_MANY : RelationshipType.MANY_TO_MANY;
            mappedBy = fieldOrMethod.getAnnotation(ManyToMany.class).mappedBy();
            cascadeTypes = fieldOrMethod.getAnnotation(ManyToMany.class).cascade();
        } else if (manyToOne) {
            type = computedRelationship ? RelationshipType.COMPUTED_MANY_TO_ONE : RelationshipType.MANY_TO_ONE;
            cascadeTypes = fieldOrMethod.getAnnotation(ManyToOne.class).cascade();
        } else {
            type = toOne ? RelationshipType.COMPUTED_ONE_TO_ONE : (toMany ? RelationshipType.COMPUTED_ONE_TO_MANY : (computedRelationship ? RelationshipType.COMPUTED_NONE : RelationshipType.NONE));
        }
        this.relationshipTypes.put(fieldName, type);
        this.relationshipToInverse.put(fieldName, mappedBy);
        this.relationshipToCascadeTypes.put(fieldName, cascadeTypes);
        this.relationshipsDeque.push(fieldName);
        this.fieldsToValues.put(fieldName, fieldOrMethod);
        this.fieldsToTypes.put(fieldName, fieldType);
    }

    private void bindAttr(AccessibleObject fieldOrMethod, String fieldName, Class<?> fieldType) {
        this.attributesDeque.push(fieldName);
        this.fieldsToValues.put(fieldName, fieldOrMethod);
        this.fieldsToTypes.put(fieldName, fieldType);
    }

    public static String getFieldName(AccessibleObject fieldOrMethod) {
        boolean hasValidParameterCount;
        if (fieldOrMethod instanceof Field) {
            return ((Field)fieldOrMethod).getName();
        }
        Method method = (Method)fieldOrMethod;
        String name = method.getName();
        boolean bl = hasValidParameterCount = method.getParameterCount() == 0 || EntityBinding.isRequestScopeableMethod(method);
        if (name.startsWith("get") && hasValidParameterCount) {
            return StringUtils.uncapitalize((String)name.substring("get".length()));
        }
        if (name.startsWith("is") && hasValidParameterCount) {
            return StringUtils.uncapitalize((String)name.substring("is".length()));
        }
        return null;
    }

    public static boolean isRequestScopeableMethod(Method method) {
        return EntityBinding.isComputedMethod(method) && method.getParameterCount() == 1 && RequestScope.class.isAssignableFrom(method.getParameterTypes()[0]);
    }

    public static boolean isComputedMethod(Method method) {
        return Stream.of(method.getAnnotations()).map(Annotation::annotationType).anyMatch(c -> ComputedAttribute.class == c || ComputedRelationship.class == c);
    }

    public static Class<?> getFieldType(Class<?> parentClass, AccessibleObject fieldOrMethod) {
        return EntityBinding.getFieldType(parentClass, fieldOrMethod, Optional.empty());
    }

    public static Class<?> getFieldType(Class<?> parentClass, AccessibleObject fieldOrMethod, Optional<Integer> index) {
        Type type = fieldOrMethod instanceof Field ? ((Field)fieldOrMethod).getGenericType() : ((Method)fieldOrMethod).getGenericReturnType();
        if (type instanceof ParameterizedType && index.isPresent()) {
            type = ((ParameterizedType)type).getActualTypeArguments()[index.get()];
        }
        return TypeUtils.getRawType((Type)type, parentClass);
    }

    private void bindTriggerIfPresent(Class<? extends Annotation> annotationClass, AccessibleObject fieldOrMethod) {
        if (fieldOrMethod instanceof Method && fieldOrMethod.isAnnotationPresent(annotationClass)) {
            String value;
            Annotation trigger = fieldOrMethod.getAnnotation(annotationClass);
            try {
                value = (String)annotationClass.getMethod("value", new Class[0]).invoke((Object)trigger, new Object[0]);
            }
            catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
                value = "";
            }
            Method method = (Method)fieldOrMethod;
            int paramCount = method.getParameterCount();
            Class[] paramTypes = method.getParameterTypes();
            LifeCycleHook callback = (entity, scope, changes) -> {
                block5: {
                    try {
                        if (changes.isPresent() && paramCount == 2 && paramTypes[0].isInstance(scope) && paramTypes[1].isInstance(changes.get())) {
                            method.invoke(entity, scope, changes.get());
                            break block5;
                        }
                        if (paramCount == 1 && paramTypes[0].isInstance(scope)) {
                            method.invoke(entity, scope);
                            break block5;
                        }
                        if (paramCount == 0) {
                            method.invoke(entity, new Object[0]);
                            break block5;
                        }
                        throw new IllegalArgumentException();
                    }
                    catch (ReflectiveOperationException e) {
                        Throwables.propagateIfPossible((Throwable)e.getCause());
                        throw new IllegalArgumentException(e);
                    }
                }
            };
            if (value.equals(ALL_FIELDS)) {
                this.bindTrigger(annotationClass, callback);
            } else {
                this.bindTrigger(annotationClass, value, callback);
            }
        }
    }

    public void bindTrigger(Class<? extends Annotation> annotationClass, String fieldOrMethodName, LifeCycleHook callback) {
        this.fieldsToTriggers.put((Object)Pair.of(annotationClass, (Object)fieldOrMethodName), (Object)callback);
    }

    public void bindTrigger(Class<? extends Annotation> annotationClass, LifeCycleHook callback) {
        this.classToTriggers.put(annotationClass, (Object)callback);
    }

    public <A extends Annotation> Collection<LifeCycleHook> getTriggers(Class<A> annotationClass, String fieldName) {
        Collection methods = this.fieldsToTriggers.get((Object)Pair.of(annotationClass, (Object)fieldName));
        return methods == null ? Collections.emptyList() : methods;
    }

    public <A extends Annotation> Collection<LifeCycleHook> getTriggers(Class<A> annotationClass) {
        Collection methods = this.classToTriggers.get(annotationClass);
        return methods == null ? Collections.emptyList() : methods;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        Annotation annotation = this.annotations.get(annotationClass);
        if (annotation == null) {
            annotation = EntityDictionary.getFirstAnnotation(this.entityClass, Collections.singletonList(annotationClass));
            if (annotation == null) {
                annotation = NO_ANNOTATION;
            }
            this.annotations.putIfAbsent(annotationClass, annotation);
        }
        return (A)(annotation == NO_ANNOTATION ? null : (Annotation)annotationClass.cast(annotation));
    }

    private List<Class<?>> getInheritedTypes(Class<?> entityClass) {
        ArrayList results = new ArrayList();
        for (Class<?> cls = entityClass.getSuperclass(); cls != Object.class; cls = cls.getSuperclass()) {
            results.add(cls);
        }
        return results;
    }

    public boolean isIdGenerated() {
        return this.idGenerated;
    }

    public AccessibleObject getIdField() {
        return this.idField;
    }

    public String getIdFieldName() {
        return this.idFieldName;
    }

    public Class<?> getIdType() {
        return this.idType;
    }

    public Initializer getInitializer() {
        return this.initializer;
    }

    public void setInitializer(Initializer initializer) {
        this.initializer = initializer;
    }

    public AccessType getAccessType() {
        return this.accessType;
    }
}

