/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.service.storageengine;

import com.yahoo.elide.async.models.FileExtensionType;
import com.yahoo.elide.async.models.TableExport;
import com.yahoo.elide.async.models.TableExportResult;
import com.yahoo.elide.async.service.storageengine.ResultStorageEngine;
import io.reactivex.Observable;
import jakarta.inject.Singleton;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class FileResultStorageEngine
implements ResultStorageEngine {
    private static final Logger log = LoggerFactory.getLogger(FileResultStorageEngine.class);
    private String basePath;
    private boolean enableExtension;

    public FileResultStorageEngine(String basePath, boolean enableExtension) {
        this.basePath = basePath;
        this.enableExtension = enableExtension;
    }

    @Override
    public TableExportResult storeResults(TableExport tableExport, Observable<String> result) {
        log.debug("store TableExportResults for Download");
        String extension = this.isExtensionEnabled() ? tableExport.getResultType().getFileExtensionType().getExtension() : FileExtensionType.NONE.getExtension();
        TableExportResult exportResult = new TableExportResult();
        try (BufferedWriter writer = this.getWriter(tableExport.getId(), extension);){
            result.map(record -> record.concat(System.lineSeparator())).subscribe(recordCharArray -> {
                writer.write((String)recordCharArray);
                writer.flush();
            }, throwable -> {
                StringBuilder message = new StringBuilder();
                message.append(throwable.getClass().getCanonicalName()).append(" : ");
                message.append(throwable.getMessage());
                exportResult.setMessage(message.toString());
                throw new IllegalStateException("Unable to store results.", (Throwable)throwable);
            }, writer::flush);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to store results.", e);
        }
        return exportResult;
    }

    @Override
    public Observable<String> getResultsByID(String tableExportID) {
        log.debug("getTableExportResultsByID");
        return Observable.using(() -> this.getReader(tableExportID), reader -> Observable.fromIterable(() -> new Iterator<String>(){
            private String record = null;

            @Override
            public boolean hasNext() {
                try {
                    this.record = reader.readLine();
                    return this.record != null;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to retrieve results.", e);
                }
            }

            @Override
            public String next() {
                if (this.record != null) {
                    return this.record;
                }
                throw new IllegalStateException("null line found.");
            }
        }), BufferedReader::close);
    }

    private BufferedReader getReader(String tableExportID) {
        try {
            return Files.newBufferedReader(Paths.get(this.basePath + File.separator + tableExportID, new String[0]));
        }
        catch (IOException e) {
            log.debug(e.getMessage());
            throw new IllegalStateException("Unable to retrieve results.", e);
        }
    }

    private BufferedWriter getWriter(String tableExportID, String extension) {
        try {
            return Files.newBufferedWriter(Paths.get(this.basePath + File.separator + tableExportID + extension, new String[0]), new OpenOption[0]);
        }
        catch (IOException e) {
            log.debug(e.getMessage());
            throw new IllegalStateException("Unable to store results.", e);
        }
    }

    @Override
    public boolean isExtensionEnabled() {
        return this.enableExtension;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public boolean isEnableExtension() {
        return this.enableExtension;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setEnableExtension(boolean enableExtension) {
        this.enableExtension = enableExtension;
    }
}

