/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.operation;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.yahoo.elide.ElideResponse;
import com.yahoo.elide.async.models.AsyncApi;
import com.yahoo.elide.async.models.AsyncApiResult;
import com.yahoo.elide.async.models.AsyncQuery;
import com.yahoo.elide.async.models.AsyncQueryResult;
import com.yahoo.elide.async.service.AsyncExecutorService;
import com.yahoo.elide.core.RequestScope;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AsyncQueryOperation
implements Callable<AsyncApiResult> {
    private static final Logger log = LoggerFactory.getLogger(AsyncQueryOperation.class);
    private AsyncExecutorService service;
    private AsyncQuery queryObj;
    private RequestScope scope;

    public AsyncQueryOperation(AsyncExecutorService service, AsyncApi queryObj, RequestScope scope) {
        this.service = service;
        this.queryObj = (AsyncQuery)queryObj;
        this.scope = scope;
    }

    @Override
    public AsyncApiResult call() throws URISyntaxException {
        ElideResponse<String> response = null;
        log.debug("AsyncQuery Object from request: {}", (Object)this.queryObj);
        response = this.execute(this.queryObj, this.scope);
        this.nullResponseCheck(response);
        AsyncQueryResult queryResult = new AsyncQueryResult();
        queryResult.setHttpStatus(response.getStatus());
        queryResult.setCompletedOn(new Date());
        queryResult.setResponseBody((String)response.getBody());
        queryResult.setContentLength(((String)response.getBody()).length());
        if (response.getStatus() == 200) {
            queryResult.setRecordCount(this.calculateRecordCount(this.queryObj, response));
        }
        return queryResult;
    }

    public abstract Integer calculateRecordCount(AsyncQuery var1, ElideResponse<String> var2);

    public void nullResponseCheck(ElideResponse<String> response) {
        if (response == null) {
            throw new IllegalStateException("No Response for request returned");
        }
    }

    public abstract ElideResponse<String> execute(AsyncApi var1, RequestScope var2) throws URISyntaxException;

    public static Integer safeJsonPathLength(String json, String path) {
        Object result = JsonPath.read((String)json, (String)path, (Predicate[])new Predicate[0]);
        if (Integer.class.isAssignableFrom(result.getClass())) {
            return (Integer)result;
        }
        if (List.class.isAssignableFrom(result.getClass())) {
            List resultList = (List)result;
            Object object = result = resultList.isEmpty() ? Integer.valueOf(0) : resultList.get(0);
            if (Integer.class.isAssignableFrom(result.getClass())) {
                return (Integer)result;
            }
        }
        throw new IllegalStateException("Incompatible version of JSONPath");
    }

    public AsyncExecutorService getService() {
        return this.service;
    }
}

