/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.models;

import com.yahoo.elide.annotation.DeletePermission;
import com.yahoo.elide.annotation.Include;
import com.yahoo.elide.annotation.ReadPermission;
import com.yahoo.elide.annotation.UpdatePermission;
import com.yahoo.elide.async.models.AsyncApi;
import com.yahoo.elide.async.models.AsyncApiResult;
import com.yahoo.elide.async.models.ResultType;
import com.yahoo.elide.async.models.TableExportResult;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.validation.constraints.NotNull;

@Entity
@Include(name="tableExport")
@ReadPermission(expression="Principal is Owner OR Principal is Admin")
@UpdatePermission(expression="Prefab.Role.None")
@DeletePermission(expression="Prefab.Role.None")
public class TableExport
extends AsyncApi {
    @Enumerated(value=EnumType.STRING)
    @NotNull
    private ResultType resultType;
    @Embedded
    private TableExportResult result;

    @Override
    public void setResult(AsyncApiResult result) {
        this.result = (TableExportResult)result;
    }

    public ResultType getResultType() {
        return this.resultType;
    }

    @Override
    public TableExportResult getResult() {
        return this.result;
    }

    public void setResultType(ResultType resultType) {
        this.resultType = resultType;
    }

    @Override
    public String toString() {
        return "TableExport(resultType=" + this.getResultType() + ", result=" + this.getResult() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableExport)) {
            return false;
        }
        TableExport other = (TableExport)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResultType this$resultType = this.getResultType();
        ResultType other$resultType = other.getResultType();
        if (this$resultType == null ? other$resultType != null : !((Object)((Object)this$resultType)).equals((Object)other$resultType)) {
            return false;
        }
        TableExportResult this$result = this.getResult();
        TableExportResult other$result = other.getResult();
        return !(this$result == null ? other$result != null : !((Object)this$result).equals(other$result));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableExport;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ResultType $resultType = this.getResultType();
        result = result * 59 + ($resultType == null ? 43 : ((Object)((Object)$resultType)).hashCode());
        TableExportResult $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
        return result;
    }
}

